/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.filters.TableLineFilter;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.search.MediaTypeFilter;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.settings.SearchSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;

final class SchemaBox
extends JPanel {
    private static final long serialVersionUID = 4148383858573954999L;
    private static final String SELECT_TYPE = I18n.tr("Select Search Types:");
    private static final String MEDIA = "NAMED_MEDIA_TYPE";
    private static final String SELECTED = "SELECTED_ICON";
    private static final String DESELECTED = "DESELECTED_ICON";
    private final JPanel SCHEMAS;
    private final ItemListener HIGHLIGHTER = new Highlighter();
    private final MouseListener CLICK_FORWARDER = new Clicker();
    private final Ditherer DITHERER = new Ditherer(20, ThemeMediator.CURRENT_THEME.getCustomUI().getFilterTitleTopColor(), ThemeMediator.CURRENT_THEME.getCustomUI().getFilterTitleColor());
    private Set<AbstractButton> buttons = new HashSet<AbstractButton>();

    SchemaBox() {
        List<NamedMediaType> list = NamedMediaType.getAllNamedMediaTypes();
        int n = 2;
        int n2 = (int)Math.ceil((double)list.size() / 2.0);
        this.SCHEMAS = new JPanel();
        this.SCHEMAS.setLayout(new GridLayout(n2 - 1, n, 0, 0));
        this.SCHEMAS.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.addSchemas(list);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel(SELECT_TYPE));
        this.add(jPanel);
        this.setLayout(new BoxLayout(this, 1));
        BoxPanel boxPanel = new BoxPanel(0);
        boxPanel.add(this.SCHEMAS);
        boxPanel.add(Box.createHorizontalStrut(1));
        this.add(boxPanel);
        Dimension dimension = this.getPreferredSize();
        dimension.height += 10;
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
    }

    public void addSelectionListener(ActionListener actionListener2) {
    }

    public Icon getSelectedIcon() {
        NamedMediaType namedMediaType = this.getSelectedMedia();
        if (namedMediaType == null) {
            return null;
        }
        return namedMediaType.getIcon();
    }

    public String getSelectedItem() {
        NamedMediaType namedMediaType = this.getSelectedMedia();
        if (namedMediaType == null) {
            return null;
        }
        return namedMediaType.getName();
    }

    public MediaType getSelectedMediaType() {
        NamedMediaType namedMediaType = this.getSelectedMedia();
        if (namedMediaType == null) {
            return null;
        }
        return namedMediaType.getMediaType();
    }

    private void addSchemas(List<? extends NamedMediaType> list) {
        Color color = this.getBorderColor(this);
        NamedMediaType namedMediaType = NamedMediaType.getFromDescription("audio");
        list.remove(namedMediaType);
        MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 1, 0, 1, color);
        this.addMediaType(namedMediaType, I18n.tr("Search For Audio Files, Including mp3, wav, ogg, and More"), matteBorder);
        namedMediaType = NamedMediaType.getFromDescription("image");
        list.remove(namedMediaType);
        matteBorder = BorderFactory.createMatteBorder(1, 0, 0, 1, color);
        this.addMediaType(namedMediaType, I18n.tr("Search For Image Files, Including jpg, gif, png and More"), matteBorder);
        namedMediaType = NamedMediaType.getFromDescription("video");
        list.remove(namedMediaType);
        matteBorder = BorderFactory.createMatteBorder(1, 1, 0, 1, color);
        this.addMediaType(namedMediaType, I18n.tr("Search For Video Files, Including avi, mpg, wmv, and More"), matteBorder);
        namedMediaType = NamedMediaType.getFromDescription("document");
        list.remove(namedMediaType);
        matteBorder = BorderFactory.createMatteBorder(1, 0, 0, 1, color);
        this.addMediaType(namedMediaType, I18n.tr("Search for Document Files, Including html, txt, pdf, and More"), matteBorder);
        namedMediaType = NamedMediaType.getFromDescription("application");
        list.remove(namedMediaType);
        matteBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, color);
        this.addMediaType(namedMediaType, I18n.tr("Search for Program Files, Including exe, zip, gz, and More"), matteBorder);
        namedMediaType = NamedMediaType.getFromDescription("torrent");
        list.remove(namedMediaType);
        matteBorder = BorderFactory.createMatteBorder(1, 0, 1, 1, color);
        this.addMediaType(namedMediaType, I18n.tr("Search for Torrents!"), matteBorder);
    }

    private void addMediaType(NamedMediaType namedMediaType, String string, Border border) {
        Icon icon = namedMediaType.getIcon();
        Icon icon2 = null;
        Icon icon3 = null;
        final JRadioButton jRadioButton = new JRadioButton(namedMediaType.getName());
        jRadioButton.putClientProperty(MEDIA, namedMediaType);
        jRadioButton.putClientProperty(SELECTED, icon);
        if (icon != null) {
            icon2 = ImageManipulator.darken(icon);
            icon3 = ImageManipulator.brighten(icon);
        }
        jRadioButton.putClientProperty(DESELECTED, icon2);
        jRadioButton.setIcon(icon2);
        jRadioButton.setRolloverIcon(icon3);
        jRadioButton.addItemListener(this.HIGHLIGHTER);
        jRadioButton.setBorderPainted(false);
        jRadioButton.setFocusPainted(false);
        jRadioButton.setContentAreaFilled(false);
        jRadioButton.setMargin(new Insets(0, 0, 0, 0));
        jRadioButton.setOpaque(false);
        jRadioButton.addMouseListener(this.CLICK_FORWARDER);
        jRadioButton.setPreferredSize(new Dimension(95, 22));
        if (string != null) {
            jRadioButton.setToolTipText(string);
        }
        DitherPanel ditherPanel = new DitherPanel(this.DITHERER, null);
        ditherPanel.setDithering(false);
        ditherPanel.setLayout(new FlowLayout(0, 7, 1));
        ditherPanel.add(jRadioButton);
        ditherPanel.addMouseListener(this.CLICK_FORWARDER);
        ditherPanel.setBorder(border);
        this.SCHEMAS.add(ditherPanel);
        if (SearchSettings.LAST_MEDIA_TYPES_USED.getValue().contains(namedMediaType.getMediaType().getMimeType())) {
            jRadioButton.setSelected(true);
        } else {
            jRadioButton.setSelected(false);
        }
        if (SearchSettings.LAST_MEDIA_TYPES_USED.getValue().isEmpty() && namedMediaType.getMediaType().equals(MediaType.getAudioMediaType())) {
            jRadioButton.setSelected(true);
        }
        this.buttons.add(jRadioButton);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SchemaBox.this.checkButtonStates()) {
                    SchemaBox.this.onFileTypeChanged(jRadioButton);
                } else {
                    jRadioButton.setSelected(true);
                }
            }
        });
    }

    private boolean checkButtonStates() {
        int n = 0;
        for (AbstractButton abstractButton : this.buttons) {
            if (!abstractButton.isSelected()) continue;
            ++n;
        }
        return n > 0;
    }

    NamedMediaType getSelectedMedia() {
        return null;
    }

    private Color getBorderColor(JPanel jPanel) {
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jPanel, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        return substanceColorScheme.getLineColor();
    }

    private static void setIfNotNull(JComponent jComponent, String string) {
        Color color = UIManager.getColor(string);
        if (color != null) {
            jComponent.setBackground(color);
        }
    }

    protected void onFileTypeChanged(AbstractButton abstractButton) {
        NamedMediaType namedMediaType = (NamedMediaType)abstractButton.getClientProperty(MEDIA);
        if (abstractButton.isSelected()) {
            SearchSettings.LAST_MEDIA_TYPES_USED.add(namedMediaType.getMediaType().getMimeType());
        } else {
            SearchSettings.LAST_MEDIA_TYPES_USED.remove(namedMediaType.getMediaType().getMimeType());
        }
        this.updateSearchResults(new MediaTypeFilter());
    }

    private void updateSearchResults(TableLineFilter<SearchResultDataLine> tableLineFilter) {
        List<SearchResultMediator> list = SearchMediator.getSearchResultDisplayer().getResultPanels();
        for (SearchResultMediator searchResultMediator : list) {
            searchResultMediator.filterChanged(tableLineFilter, 2);
        }
    }

    public void setFilterFor(SearchResultMediator searchResultMediator) {
        searchResultMediator.filterChanged(new MediaTypeFilter(), 2);
    }

    public void panelReset(SearchResultMediator searchResultMediator) {
        searchResultMediator.filterChanged(new MediaTypeFilter(), 2);
    }

    private static class Clicker
    implements MouseListener {
        private Clicker() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            if (jComponent instanceof AbstractButton) {
                abstractButton = (AbstractButton)jComponent;
                jComponent = (JComponent)jComponent.getParent();
            } else {
                abstractButton = (AbstractButton)jComponent.getComponent(0);
            }
            if (!abstractButton.isSelected()) {
                SchemaBox.setIfNotNull(jComponent, "TabbedPane.selected");
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            if (jComponent instanceof AbstractButton) {
                abstractButton = (AbstractButton)jComponent;
                jComponent = (JComponent)jComponent.getParent();
            } else {
                abstractButton = (AbstractButton)jComponent.getComponent(0);
            }
            if (!abstractButton.isSelected()) {
                SchemaBox.setIfNotNull(jComponent, "TabbedPane.background");
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            if (!(jComponent instanceof AbstractButton)) {
                AbstractButton abstractButton = (AbstractButton)jComponent.getComponent(0);
                abstractButton.doClick();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private static class Highlighter
    implements ItemListener {
        private Highlighter() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            AbstractButton abstractButton = (AbstractButton)itemEvent.getSource();
            DitherPanel ditherPanel = (DitherPanel)abstractButton.getParent();
            if (itemEvent.getStateChange() == 1) {
                abstractButton.setIcon((Icon)abstractButton.getClientProperty(SchemaBox.SELECTED));
                ditherPanel.setDithering(true);
            } else {
                abstractButton.setIcon((Icon)abstractButton.getClientProperty(SchemaBox.DESELECTED));
                ditherPanel.setDithering(false);
            }
            ditherPanel.repaint();
        }
    }
}

