/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.bittorrent.websearch.WebSearchPerformer;
import com.frostwire.bittorrent.websearch.clearbits.ClearBitsWebSearchPerformer;
import com.frostwire.bittorrent.websearch.extratorrent.ExtratorrentWebSearchPerformer;
import com.frostwire.bittorrent.websearch.isohunt.ISOHuntWebSearchPerformer;
import com.frostwire.bittorrent.websearch.kat.KATWebSearchPerformer;
import com.frostwire.bittorrent.websearch.mininova.MininovaWebSearchPerformer;
import com.frostwire.bittorrent.websearch.monova.MonovaWebSearchPerformer;
import com.frostwire.bittorrent.websearch.soundcloud.SoundcloudSearchPerformer;
import com.frostwire.bittorrent.websearch.tpb.TPBWebSearchPerformer;
import com.frostwire.bittorrent.websearch.vertor.VertorWebSearchPerformer;
import com.frostwire.websearch.youtube.YouTubeSearchPerformer;
import com.limegroup.gnutella.settings.SearchEnginesSettings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.limewire.setting.BooleanSetting;

public final class SearchEngine {
    public String redirectUrl = null;
    private final int _id;
    private final String _name;
    private final WebSearchPerformer _performer;
    private final BooleanSetting _setting;
    public static final int CLEARBITS_ID = 0;
    public static final int MININOVA_ID = 1;
    public static final int ISOHUNT_ID = 2;
    public static final int KAT_ID = 8;
    public static final int EXTRATORRENT_ID = 4;
    public static final int VERTOR_ID = 5;
    public static final int TPB_ID = 6;
    public static final int MONOVA_ID = 7;
    public static final int YOUTUBE_ID = 9;
    public static final int SOUNDCLOUD_ID = 10;
    public static final SearchEngine CLEARBITS = new SearchEngine(0, "ClearBits", new ClearBitsWebSearchPerformer(), SearchEnginesSettings.CLEARBITS_SEARCH_ENABLED);
    public static final SearchEngine MININOVA = new SearchEngine(1, "Mininova", new MininovaWebSearchPerformer(), SearchEnginesSettings.MININOVA_SEARCH_ENABLED);
    public static final SearchEngine ISOHUNT = new SearchEngine(2, "ISOHunt", new ISOHuntWebSearchPerformer(), SearchEnginesSettings.ISOHUNT_SEARCH_ENABLED);
    public static final SearchEngine KAT = new SearchEngine(8, "KAT", new KATWebSearchPerformer(), SearchEnginesSettings.KAT_SEARCH_ENABLED);
    public static final SearchEngine EXTRATORRENT = new SearchEngine(4, "Extratorrent", new ExtratorrentWebSearchPerformer(), SearchEnginesSettings.EXTRATORRENT_SEARCH_ENABLED);
    public static final SearchEngine VERTOR = new SearchEngine(5, "Vertor", new VertorWebSearchPerformer(), SearchEnginesSettings.VERTOR_SEARCH_ENABLED);
    public static final SearchEngine TPB = new SearchEngine(6, "TPB", new TPBWebSearchPerformer(), SearchEnginesSettings.TPB_SEARCH_ENABLED);
    public static final SearchEngine MONOVA = new SearchEngine(7, "Monova", new MonovaWebSearchPerformer(), SearchEnginesSettings.MONOVA_SEARCH_ENABLED);
    public static final SearchEngine YOUTUBE = new SearchEngine(9, "YouTube", new YouTubeSearchPerformer(), SearchEnginesSettings.YOUTUBE_SEARCH_ENABLED);
    public static final SearchEngine SOUNDCLOUD = new SearchEngine(10, "Soundcloud", new SoundcloudSearchPerformer(), SearchEnginesSettings.SOUNDCLOUD_SEARCH_ENABLED);

    private SearchEngine(int n, String string, WebSearchPerformer webSearchPerformer, BooleanSetting booleanSetting) {
        this._id = n;
        this._name = string;
        this._performer = webSearchPerformer;
        this._setting = booleanSetting;
    }

    public int getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public boolean isEnabled() {
        return this._setting.getValue();
    }

    public boolean equals(Object object) {
        return this._id == ((SearchEngine)object)._id;
    }

    public static List<SearchEngine> getSearchEngines() {
        return Arrays.asList(ISOHUNT, YOUTUBE, CLEARBITS, MININOVA, KAT, EXTRATORRENT, VERTOR, TPB, MONOVA, SOUNDCLOUD);
    }

    public WebSearchPerformer getPerformer() {
        return this._performer;
    }

    public static SearchEngine getSearchEngineById(int n) {
        List<SearchEngine> list = SearchEngine.getSearchEngines();
        for (SearchEngine searchEngine : list) {
            if (searchEngine.getId() != n) continue;
            return searchEngine;
        }
        return null;
    }

    public static Map<Integer, SearchEngine> getSearchEngineMap() {
        HashMap<Integer, SearchEngine> hashMap = new HashMap<Integer, SearchEngine>();
        List<SearchEngine> list = SearchEngine.getSearchEngines();
        for (SearchEngine searchEngine : list) {
            hashMap.put(searchEngine.getId(), searchEngine);
        }
        return hashMap;
    }

    public BooleanSetting getEnabledSetting() {
        return this._setting;
    }
}

