/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.components.LabeledRangeSlider;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledTextField;
import com.limegroup.gnutella.gui.search.GeneralResultFilter;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SearchFilterPanel
extends JPanel {
    private static final long serialVersionUID = 346186974515196119L;
    private LabeledRangeSlider _rangeSliderSeeds;
    private LabeledRangeSlider _rangeSliderSize;
    private LabeledTextField _keywordFilterTextField;
    private GeneralResultFilter _activeFilter;
    private final Map<SearchResultMediator, GeneralResultFilter> ACTIVE_FILTERS = new HashMap<SearchResultMediator, GeneralResultFilter>();

    public SearchFilterPanel() {
        this.setupUI();
        this.setFilterControlsEnabled(false);
    }

    protected void setupUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this._keywordFilterTextField = new LabeledTextField("Name", 40, -1, 100);
        this._keywordFilterTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                SearchFilterPanel.this.keywordFilterChanged(keyEvent);
            }
        });
        this.add((Component)this._keywordFilterTextField, gridBagConstraints);
        this._rangeSliderSize = new LabeledRangeSlider("Size", null, 0, 1000);
        this._rangeSliderSize.setPreferredSize(new Dimension(80, (int)this._rangeSliderSize.getPreferredSize().getHeight()));
        this._rangeSliderSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SearchFilterPanel.this.rangeSliderSize_stateChanged(changeEvent);
            }
        });
        this.add((Component)this._rangeSliderSize, gridBagConstraints);
        this._rangeSliderSeeds = new LabeledRangeSlider("Seeds", null, 0, 1000);
        this._rangeSliderSeeds.setPreferredSize(new Dimension(80, (int)this._rangeSliderSeeds.getPreferredSize().getHeight()));
        this._rangeSliderSeeds.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SearchFilterPanel.this.rangeSliderSeeds_stateChanged(changeEvent);
            }
        });
        this.add((Component)this._rangeSliderSeeds, gridBagConstraints);
    }

    protected void keywordFilterChanged(KeyEvent keyEvent) {
        if (this._activeFilter != null) {
            this._activeFilter.updateKeywordFiltering(this._keywordFilterTextField.getText());
        }
    }

    protected void rangeSliderSeeds_stateChanged(ChangeEvent changeEvent) {
        if (this._activeFilter != null) {
            this._activeFilter.setRangeSeeds(this._rangeSliderSeeds.getValue(), this._rangeSliderSeeds.getUpperValue());
        }
    }

    protected void rangeSliderSize_stateChanged(ChangeEvent changeEvent) {
        if (this._activeFilter != null) {
            this._activeFilter.setRangeSize(this._rangeSliderSize.getValue(), this._rangeSliderSize.getUpperValue());
        }
    }

    public void setFilterControlsEnabled(boolean bl) {
        this._rangeSliderSeeds.setEnabled(bl);
        this._rangeSliderSize.setEnabled(bl);
        this._keywordFilterTextField.setEnabled(bl);
    }

    public void reset() {
        this._activeFilter = null;
        this._rangeSliderSeeds.setMinimum(0);
        this._rangeSliderSeeds.setMaximum(1000);
        this._rangeSliderSeeds.setValue(0);
        this._rangeSliderSeeds.setUpperValue(1000);
        this._rangeSliderSize.setMinimum(0);
        this._rangeSliderSize.setMaximum(1000);
        this._rangeSliderSize.setValue(0);
        this._rangeSliderSize.setUpperValue(1000);
        this._rangeSliderSeeds.getMinimumValueLabel().setText(I18n.tr("0"));
        this._rangeSliderSeeds.getMaximumValueLabel().setText(I18n.tr("Max"));
        this._rangeSliderSize.getMinimumValueLabel().setText(I18n.tr("0"));
        this._rangeSliderSize.getMaximumValueLabel().setText(I18n.tr("Max"));
        this._keywordFilterTextField.setText("");
    }

    private void updateFilterControls(GeneralResultFilter generalResultFilter) {
        this._activeFilter = null;
        this._rangeSliderSeeds.setMinimum(0);
        this._rangeSliderSeeds.setMaximum(1000);
        this._rangeSliderSeeds.setValue(generalResultFilter.getMinSeeds());
        this._rangeSliderSeeds.setUpperValue(generalResultFilter.getMaxSeeds());
        this._rangeSliderSize.setMinimum(0);
        this._rangeSliderSize.setMaximum(1000);
        this._rangeSliderSize.setValue(generalResultFilter.getMinSize());
        this._rangeSliderSize.setUpperValue(generalResultFilter.getMaxSize());
        this._keywordFilterTextField.setText(generalResultFilter.getKeywordFilterText());
        if (generalResultFilter.getMinResultsSeeds() == Integer.MAX_VALUE) {
            this._rangeSliderSeeds.getMinimumValueLabel().setText(I18n.tr("0"));
        } else {
            this._rangeSliderSeeds.getMinimumValueLabel().setText(String.valueOf(generalResultFilter.getMinResultsSeeds()));
        }
        if (generalResultFilter.getMaxResultsSeeds() == 0) {
            this._rangeSliderSeeds.getMaximumValueLabel().setText(I18n.tr("Max"));
        } else {
            this._rangeSliderSeeds.getMaximumValueLabel().setText(String.valueOf(generalResultFilter.getMaxResultsSeeds()));
        }
        if (generalResultFilter.getMinResultsSize() == Long.MAX_VALUE) {
            this._rangeSliderSize.getMinimumValueLabel().setText(I18n.tr("0"));
        } else {
            this._rangeSliderSize.getMinimumValueLabel().setText(GUIUtils.toUnitbytes(generalResultFilter.getMinResultsSize()));
        }
        if (generalResultFilter.getMaxResultsSize() == 0L) {
            this._rangeSliderSize.getMaximumValueLabel().setText(I18n.tr("Max"));
        } else {
            this._rangeSliderSize.getMaximumValueLabel().setText(GUIUtils.toUnitbytes(generalResultFilter.getMaxResultsSize()));
        }
    }

    public void clearFilters() {
        this.ACTIVE_FILTERS.clear();
        this.setFilterControlsEnabled(false);
        this.reset();
    }

    public void setFilterFor(SearchResultMediator searchResultMediator) {
        GeneralResultFilter generalResultFilter = this.ACTIVE_FILTERS.get(searchResultMediator);
        if (generalResultFilter == null) {
            generalResultFilter = new GeneralResultFilter(searchResultMediator, this._rangeSliderSeeds, this._rangeSliderSize, this._keywordFilterTextField);
            this.ACTIVE_FILTERS.put(searchResultMediator, generalResultFilter);
            searchResultMediator.filterChanged(generalResultFilter, 1);
        }
        this.setActiveFilter(generalResultFilter);
    }

    private void setActiveFilter(GeneralResultFilter generalResultFilter) {
        this._activeFilter = null;
        this.setFilterControlsEnabled(true);
        this.updateFilterControls(generalResultFilter);
        this._activeFilter = generalResultFilter;
    }

    public void panelReset(SearchResultMediator searchResultMediator) {
        GeneralResultFilter generalResultFilter = this.ACTIVE_FILTERS.get(searchResultMediator);
        if (generalResultFilter != null) {
            this.ACTIVE_FILTERS.remove(searchResultMediator);
            this.setFilterFor(searchResultMediator);
        }
    }

    public boolean panelRemoved(SearchResultMediator searchResultMediator) {
        GeneralResultFilter generalResultFilter = this.ACTIVE_FILTERS.get(searchResultMediator);
        if (generalResultFilter != null) {
            this.ACTIVE_FILTERS.remove(searchResultMediator);
        }
        return this.ACTIVE_FILTERS.isEmpty();
    }
}

