/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SearchInformation {
    private static final String MAP_TYPE = "type";
    private static final String MAP_QUERY = "query";
    private static final String MAP_XML = "xml";
    private static final String MAP_MEDIA = "media";
    private static final String MAP_TITLE = "title";
    public static final int KEYWORD = 0;
    private final int type;
    private final String query;
    private final String xml;
    private final MediaType media;
    private final String title;

    private SearchInformation(int n, String string, String string2, MediaType mediaType, String string3) {
        if (mediaType == null) {
            throw new NullPointerException("null media");
        }
        if (string == null) {
            throw new NullPointerException("null query");
        }
        this.type = n;
        this.query = string.trim();
        this.xml = string2;
        this.media = mediaType;
        this.title = string3 != null ? string3 : string;
    }

    private SearchInformation(int n, String string, String string2, MediaType mediaType) {
        this(n, string, string2, mediaType, null);
    }

    private SearchInformation(Map<?, ?> map) {
        Integer n = (Integer)map.get(MAP_TYPE);
        if (n == null) {
            throw new NullPointerException("null type");
        }
        this.type = n;
        this.query = (String)map.get(MAP_QUERY);
        this.xml = (String)map.get(MAP_XML);
        this.media = (MediaType)map.get(MAP_MEDIA);
        this.title = (String)map.get(MAP_TITLE);
        if (this.media == null) {
            throw new NullPointerException("null media");
        }
        if (this.query == null) {
            throw new NullPointerException("null query");
        }
    }

    public static SearchInformation createKeywordSearch(String string, String string2, MediaType mediaType) {
        return new SearchInformation(0, string, string2, mediaType);
    }

    public static SearchInformation createTitledKeywordSearch(String string, String string2, MediaType mediaType, String string3) {
        return new SearchInformation(0, string, string2, mediaType, string3);
    }

    public String getQuery() {
        return this.query;
    }

    public String getXML() {
        return this.xml;
    }

    public MediaType getMediaType() {
        return this.media;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isXMLSearch() {
        return this.xml != null && this.xml.length() > 0;
    }

    public boolean isKeywordSearch() {
        return this.type == 0;
    }

    public String toString() {
        return this.toMap().toString();
    }

    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>(5);
        hashMap.put(MAP_TYPE, new Integer(this.type));
        hashMap.put(MAP_QUERY, (Serializable)((Object)this.query));
        hashMap.put(MAP_XML, (Serializable)((Object)this.xml));
        hashMap.put(MAP_MEDIA, this.media);
        hashMap.put(MAP_TITLE, (Serializable)((Object)this.title));
        return hashMap;
    }

    public static SearchInformation createFromMap(Map<?, ?> map) {
        return new SearchInformation(map);
    }
}

