/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.bittorrent.SendFileProgressDialog;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.actions.FileMenuActions;
import com.limegroup.gnutella.gui.search.SearchInputPanel;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

final class SearchInputManager
implements ThemeObserver {
    private JPanel COMPONENT_PANEL;
    private JPanel MAIN_PANEL;
    private SearchInputPanel SEARCH;

    SearchInputManager() {
        this.updateTheme();
        ThemeMediator.addThemeObserver(this);
    }

    @Override
    public void updateTheme() {
        this.SEARCH = new SearchInputPanel();
        this.getMainPanel().removeAll();
        this.getMainPanel().add((Component)this.SEARCH, "Center");
        this.getMainPanel().putClientProperty("CLIENT_PROPERTY_DARK_NOISE", true);
        this.getMainPanel().add((Component)this.createTorrentActionsPanel(), "Last");
        this.getComponent().removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.getComponent().add((Component)this.MAIN_PANEL, gridBagConstraints);
    }

    void rebuild() {
        this.updateTheme();
    }

    void goToSearch() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchInputManager.this.requestSearchFocus(false);
            }
        });
    }

    void requestSearchFocus() {
        this.requestSearchFocus(false);
    }

    JComponent getComponent() {
        if (this.COMPONENT_PANEL == null) {
            this.COMPONENT_PANEL = new JPanel(new GridBagLayout());
            this.COMPONENT_PANEL.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, ThemeMediator.CURRENT_THEME.getCustomUI().getDarkBorder()));
        }
        return this.COMPONENT_PANEL;
    }

    void panelReset(SearchResultMediator searchResultMediator) {
        this.SEARCH.panelReset(searchResultMediator);
    }

    void panelRemoved(SearchResultMediator searchResultMediator) {
        if (this.SEARCH.panelRemoved(searchResultMediator)) {
            this.requestSearchFocus(false);
        }
    }

    private void requestSearchFocus(boolean bl) {
        if (bl) {
            this.SEARCH.requestSearchFocusImmediately();
        } else {
            this.SEARCH.requestSearchFocus();
        }
    }

    private JPanel getMainPanel() {
        if (this.MAIN_PANEL == null) {
            this.MAIN_PANEL = new JPanel(new BorderLayout());
        }
        return this.MAIN_PANEL;
    }

    public void clearFilters() {
        this.SEARCH.clearFilters();
    }

    public void setFiltersFor(SearchResultMediator searchResultMediator) {
        this.SEARCH.setFiltersFor(searchResultMediator);
    }

    private JPanel createTorrentActionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.putClientProperty("CLIENT_PROPERTY_DARK_NOISE", true);
        IconButton iconButton = new IconButton("Open", "OPEN_TORRENT");
        iconButton.setToolTipText(I18n.tr("Open a .torrent or Magnet link or YouTube video link"));
        iconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileMenuActions.OpenMagnetTorrentAction openMagnetTorrentAction = new FileMenuActions.OpenMagnetTorrentAction();
                openMagnetTorrentAction.actionPerformed(null);
            }
        });
        IconButton iconButton2 = new IconButton("Send", "SHARE");
        iconButton2.setToolTipText(I18n.tr("Send a file or folder to a friend (No size limit, No third parties involved)"));
        iconButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendFileProgressDialog sendFileProgressDialog = new SendFileProgressDialog(GUIMediator.getAppFrame());
                sendFileProgressDialog.setVisible(true);
            }
        });
        jPanel.add(iconButton);
        jPanel.add(iconButton2);
        return jPanel;
    }
}

