/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.components.GoogleSearchField;
import com.frostwire.gui.filters.TableLineFilter;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.search.SchemaBox;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchEngineFilter;
import com.limegroup.gnutella.gui.search.SearchFilterPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.limewire.setting.BooleanSetting;

class SearchInputPanel
extends JPanel {
    private static final long serialVersionUID = -5638062215253666235L;
    private final SchemaBox SCHEMA_BOX = new SchemaBox();
    private final GoogleSearchField SEARCH_FIELD = new GoogleSearchField();
    private final ActionListener SEARCH_LISTENER = new SearchListener();
    private JXCollapsiblePane SEARCH_OPTIONS_COLLAPSIBLE_PANEL;
    private SearchFilterPanel _filterPanel;

    SearchInputPanel() {
        SchemaListener schemaListener = new SchemaListener();
        this.SEARCH_FIELD.addActionListener(this.SEARCH_LISTENER);
        this.createDefaultSearchPanel();
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 5, 2));
        schemaListener.actionPerformed(null);
    }

    void requestSearchFocusImmediately() {
        if (this.SEARCH_FIELD != null) {
            this.SEARCH_FIELD.requestFocus();
        }
    }

    void requestSearchFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchInputPanel.this.requestSearchFocusImmediately();
            }
        });
    }

    private void createDefaultSearchPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.SCHEMA_BOX);
        this.add(Box.createVerticalStrut(3));
        this.SEARCH_FIELD.setMinimumSize(new Dimension(100, 27));
        this.add(this.SEARCH_FIELD);
        this.add(Box.createVerticalStrut(5));
        this.add(this.createSearchButtonPanel());
        JXCollapsiblePane jXCollapsiblePane = this.createSearchOptionsPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jXCollapsiblePane, "First");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        Dimension dimension = new Dimension(100, 70000);
        jScrollPane.setPreferredSize(dimension);
        this.add(jScrollPane);
        Font font = this.SEARCH_FIELD.getFont();
        Font font2 = font.deriveFont(font.getSize2D() + 2.0f);
        this.SEARCH_FIELD.setFont(font2);
    }

    private JXCollapsiblePane createSearchOptionsPanel() {
        this.SEARCH_OPTIONS_COLLAPSIBLE_PANEL = new JXCollapsiblePane();
        this.SEARCH_OPTIONS_COLLAPSIBLE_PANEL.setCollapsed(ApplicationSettings.SEARCH_OPTIONS_COLLAPSED.getValue());
        this.SEARCH_OPTIONS_COLLAPSIBLE_PANEL.setLayout(new BorderLayout());
        this.SEARCH_OPTIONS_COLLAPSIBLE_PANEL.setAnimated(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.putClientProperty("CLIENT_PROPERTY_DARK_DARK_NOISE", true);
        jPanel2.setBorder(ThemeMediator.CURRENT_THEME.getCustomUI().createTitledBorder(I18n.tr("Search Engines")));
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setAlignmentX(0.0f);
        List<SearchEngine> list = SearchEngine.getSearchEngines();
        this.setupCheckboxes(list, jPanel2);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(15));
        this._filterPanel = new SearchFilterPanel();
        this._filterPanel.putClientProperty("CLIENT_PROPERTY_DARK_DARK_NOISE", true);
        this._filterPanel.setBorder(ThemeMediator.CURRENT_THEME.getCustomUI().createTitledBorder(I18n.tr("Filter")));
        this._filterPanel.setAlignmentX(0.0f);
        jPanel.add(this._filterPanel);
        this.SEARCH_OPTIONS_COLLAPSIBLE_PANEL.add(jPanel);
        return this.SEARCH_OPTIONS_COLLAPSIBLE_PANEL;
    }

    private void setupCheckboxes(List<SearchEngine> list, JPanel jPanel) {
        final HashMap<JCheckBox, BooleanSetting> hashMap = new HashMap<JCheckBox, BooleanSetting>();
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = true;
                for (JCheckBox jCheckBox : hashMap.keySet()) {
                    if (!jCheckBox.isSelected()) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    ((JCheckBox)itemEvent.getItemSelectable()).setSelected(true);
                }
                for (JCheckBox jCheckBox : hashMap.keySet()) {
                    ((BooleanSetting)hashMap.get(jCheckBox)).setValue(jCheckBox.isSelected());
                }
                SearchInputPanel.this.updateSearchResults(new SearchEngineFilter());
            }
        };
        for (SearchEngine searchEngine : list) {
            JCheckBox jCheckBox = new JCheckBox(searchEngine.getName());
            jCheckBox.setSelected(searchEngine.isEnabled());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(0, 10, 2, 10);
            jPanel.add((Component)jCheckBox, gridBagConstraints);
            hashMap.put(jCheckBox, searchEngine.getEnabledSetting());
            jCheckBox.addItemListener(itemListener);
        }
    }

    private void updateSearchResults(TableLineFilter<SearchResultDataLine> tableLineFilter) {
        List<SearchResultMediator> list = SearchMediator.getSearchResultDisplayer().getResultPanels();
        for (SearchResultMediator searchResultMediator : list) {
            searchResultMediator.filterChanged(tableLineFilter, 0);
        }
    }

    private JPanel createSearchButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        final ToggleSearchOptionsPanelAction toggleSearchOptionsPanelAction = new ToggleSearchOptionsPanelAction();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        JLabel jLabel = new JLabel(I18n.tr("<html><strong>Refine Results</strong></html>"));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        final JButton jButton = new JButton();
        jButton.setAction(toggleSearchOptionsPanelAction);
        jButton.setIcon(ApplicationSettings.SEARCH_OPTIONS_COLLAPSED.getValue() ? IconManager.instance().getSmallIconForButton("SEARCH_OPTIONS_MORE") : IconManager.instance().getSmallIconForButton("SEARCH_OPTIONS_LESS"));
        this.fixIconButton(jButton);
        jPanel2.add((Component)jButton, gridBagConstraints);
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ActionEvent actionEvent = new ActionEvent(jButton, 1, null);
                toggleSearchOptionsPanelAction.actionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    private void fixIconButton(JButton jButton) {
        jButton.setBorderPainted(false);
        jButton.setFocusable(false);
        jButton.setBorder(null);
        jButton.setFocusPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setPreferredSize(new Dimension(16, 16));
    }

    public void clearFilters() {
        this._filterPanel.clearFilters();
    }

    public void setFiltersFor(SearchResultMediator searchResultMediator) {
        this._filterPanel.setFilterFor(searchResultMediator);
        this.SCHEMA_BOX.setFilterFor(searchResultMediator);
    }

    void panelReset(SearchResultMediator searchResultMediator) {
        this._filterPanel.panelReset(searchResultMediator);
        this.SCHEMA_BOX.panelReset(searchResultMediator);
    }

    boolean panelRemoved(SearchResultMediator searchResultMediator) {
        return this._filterPanel.panelRemoved(searchResultMediator);
    }

    private class ToggleSearchOptionsPanelAction
    extends AbstractAction {
        private final String TOOLTIP_COLLAPSED = I18n.tr("Show search result filter controls");
        private final String TOOLTIP_SHOWN = I18n.tr("Hide search result filter controls");
        private static final long serialVersionUID = -2415729526575357348L;

        public ToggleSearchOptionsPanelAction() {
            this.putValue("ShortDescription", this.TOOLTIP_COLLAPSED);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchInputPanel.this.SEARCH_OPTIONS_COLLAPSIBLE_PANEL.getActionMap().get("toggle").actionPerformed(actionEvent);
            JButton jButton = (JButton)actionEvent.getSource();
            Icon icon = null;
            if (!SearchInputPanel.this.SEARCH_OPTIONS_COLLAPSIBLE_PANEL.isCollapsed()) {
                icon = IconManager.instance().getSmallIconForButton("SEARCH_OPTIONS_LESS");
                ApplicationSettings.SEARCH_OPTIONS_COLLAPSED.setValue(false);
                this.putValue("ShortDescription", this.TOOLTIP_SHOWN);
            } else {
                icon = IconManager.instance().getSmallIconForButton("SEARCH_OPTIONS_MORE");
                ApplicationSettings.SEARCH_OPTIONS_COLLAPSED.setValue(true);
                this.putValue("ShortDescription", this.TOOLTIP_COLLAPSED);
            }
            jButton.setIcon(icon);
            SearchInputPanel.this.fixIconButton(jButton);
        }
    }

    private class SearchListener
    implements ActionListener {
        private SearchListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = SearchInputPanel.this.SEARCH_FIELD.getText();
            SearchInformation searchInformation = SearchInformation.createTitledKeywordSearch(string, null, MediaType.getTorrentMediaType(), string);
            if (SearchMediator.triggerSearch(searchInformation) != null && searchInformation.isKeywordSearch()) {
                SearchInputPanel.this.SEARCH_FIELD.addToDictionary();
                SearchInputPanel.this.SEARCH_FIELD.setText("");
                SearchInputPanel.this.SEARCH_FIELD.hidePopup();
            }
        }
    }

    private class SchemaListener
    implements ActionListener {
        private SchemaListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchSettings.MAX_QUERY_LENGTH.revertToDefault();
            if (SearchInputPanel.this.SEARCH_FIELD.getText().length() > SearchSettings.MAX_QUERY_LENGTH.getValue()) {
                try {
                    SearchInputPanel.this.SEARCH_FIELD.setText(SearchInputPanel.this.SEARCH_FIELD.getText(0, SearchSettings.MAX_QUERY_LENGTH.getValue()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            SearchInputPanel.this.requestSearchFocus();
        }
    }
}

