/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.AzureusStarter;
import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.bittorrent.websearch.soundcloud.SoundcloudTrackSearchResult;
import com.frostwire.gui.filters.SearchFilter;
import com.frostwire.gui.filters.SearchFilterFactory;
import com.frostwire.gui.filters.SearchFilterFactoryImpl;
import com.frostwire.websearch.youtube.YouTubeSearchResult;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.AbstractSearchResult;
import com.limegroup.gnutella.gui.search.BittorrentSearchResult;
import com.limegroup.gnutella.gui.search.LocalSearchEngine;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchEngineSearchResult;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchInputManager;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultDisplayer;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.search.SmartSearchResult;
import com.limegroup.gnutella.gui.search.SoundcloudSearchResult;
import com.limegroup.gnutella.gui.search.YouTubePackageSearchResult;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.limewire.util.I18NConvert;

public final class SearchMediator {
    public static final int QUERY_VALID = 0;
    public static final int QUERY_EMPTY = 1;
    public static final int QUERY_TOO_SHORT = 2;
    public static final int QUERY_TOO_LONG = 3;
    public static final int QUERY_XML_TOO_LONG = 4;
    public static final int QUERY_INVALID_CHARACTERS = 5;
    static final String DOWNLOAD_STRING = I18n.tr("Download");
    static final String KILL_STRING = I18n.tr("Close Search");
    static final String LAUNCH_STRING = I18n.tr("Launch Action");
    static final String REPEAT_SEARCH_STRING = I18n.tr("Repeat Search");
    static final String DOWNLOAD_PARTIAL_FILES_STRING = I18n.tr("Download Partial Files");
    static final String TORRENT_DETAILS_STRING = I18n.tr("Torrent Details");
    static final String YOUTUBE_DETAILS_STRING = I18n.tr("View in YouTube");
    static final String SOUNDCLOUD_DETAILS_STRING = I18n.tr("View in Soundcloud");
    private static SearchInputManager INPUT_MANAGER;
    private static SearchResultDisplayer RESULT_DISPLAYER;
    private static SearchFilterFactory SEARCH_FILTER_FACTORY;

    public SearchMediator() {
        String string = I18n.tr("Loading Search Window...");
        GUIMediator.setSplashScreenString(string);
        GUIMediator.addRefreshListener(SearchMediator.getSearchResultDisplayer());
        SearchMediator.getSearchResultDisplayer().setSearchListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SearchResultMediator searchResultMediator = SearchMediator.getSearchResultDisplayer().getSelectedResultPanel();
                if (searchResultMediator == null) {
                    SearchMediator.getSearchInputManager().clearFilters();
                } else {
                    SearchMediator.getSearchInputManager().setFiltersFor(searchResultMediator);
                }
            }
        });
    }

    public static void rebuildInputPanel() {
        SearchMediator.getSearchInputManager().rebuild();
    }

    public static void showSearchInput() {
        SearchMediator.getSearchInputManager().goToSearch();
    }

    public static void requestSearchFocus() {
        SearchMediator.getSearchInputManager().requestSearchFocus();
    }

    public static void updateResults() {
        SearchMediator.getSearchResultDisplayer().updateResults();
    }

    static byte[] repeatSearch(SearchResultMediator searchResultMediator, SearchInformation searchInformation) {
        return SearchMediator.repeatSearch(searchResultMediator, searchInformation, true);
    }

    static byte[] repeatSearch(SearchResultMediator searchResultMediator, SearchInformation searchInformation, boolean bl) {
        if (!SearchMediator.validate(searchInformation)) {
            return null;
        }
        byte[] byArray = SearchMediator.newQueryGUID();
        GUID gUID = new GUID(byArray);
        searchResultMediator.setGUID(gUID);
        if (bl) {
            SearchMediator.getSearchInputManager().panelReset(searchResultMediator);
        }
        GUIMediator.instance().setSearching(true);
        SearchMediator.doSearch(byArray, searchInformation);
        return byArray;
    }

    private static byte[] newQueryGUID() {
        return GUID.makeGuid();
    }

    public static byte[] triggerSearch(SearchInformation searchInformation) {
        if (!SearchMediator.validate(searchInformation)) {
            return null;
        }
        byte[] byArray = SearchMediator.newQueryGUID();
        SearchMediator.addResultTab(new GUID(byArray), searchInformation);
        SearchMediator.doSearch(byArray, searchInformation);
        return byArray;
    }

    public static byte[] triggerSearch(String string) {
        return SearchMediator.triggerSearch(SearchInformation.createKeywordSearch(string, null, MediaType.getAnyTypeMediaType()));
    }

    private static boolean validate(SearchInformation searchInformation) {
        switch (SearchMediator.validateInfo(searchInformation)) {
            case 1: {
                return false;
            }
            case 2: {
                GUIMediator.showMessage(I18n.tr("Your search must be at least three characters to avoid congesting the network."));
                return false;
            }
            case 3: {
                GUIMediator.showMessage(I18n.tr("Your search is too long. Please make your search smaller and try again."));
                return false;
            }
        }
        return true;
    }

    public static int validateInfo(SearchInformation searchInformation) {
        String string = I18NConvert.instance().getNorm(searchInformation.getQuery());
        if (string.length() == 0) {
            return 1;
        }
        if (!(string.length() > 2 || string.length() == 2 && (Character.isDigit(string.charAt(0)) && Character.isLetter(string.charAt(1)) || Character.isLetter(string.charAt(0)) && Character.isDigit(string.charAt(1))))) {
            return 2;
        }
        if (string.length() > SearchSettings.MAX_QUERY_LENGTH.getValue()) {
            return 3;
        }
        return 0;
    }

    private static void doSearch(final byte[] byArray, final SearchInformation searchInformation) {
        final String string = searchInformation.getQuery();
        List<SearchEngine> list = SearchEngine.getSearchEngines();
        for (final SearchEngine searchEngine : list) {
            if (!searchEngine.isEnabled()) continue;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    final SearchResultMediator searchResultMediator = SearchMediator.getResultPanelForGUID(new GUID(byArray));
                    if (searchResultMediator != null && !searchResultMediator.isStopped()) {
                        searchResultMediator.incrementSearchCount();
                        List<WebSearchResult> list = searchEngine.getPerformer().search(string);
                        if (list.size() > 0) {
                            final List list2 = SearchMediator.normalizeWebResults(list, searchEngine, searchInformation);
                            GUIMediator.safeInvokeAndWait(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        SearchFilter searchFilter = SearchMediator.getSearchFilterFactory().createFilter();
                                        for (SearchResult searchResult : list2) {
                                            if (!searchFilter.allow(searchResult)) continue;
                                            SearchMediator.getSearchResultDisplayer().addQueryResult(byArray, searchResult, searchResultMediator);
                                        }
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                    finally {
                                        SearchResultMediator searchResultMediator2 = SearchMediator.getResultPanelForGUID(new GUID(byArray));
                                        if (searchResultMediator2 != null) {
                                            searchResultMediator2.decrementSearchCount();
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
            });
            thread.setDaemon(true);
            thread.start();
        }
        SearchMediator.doLocalSearch(byArray, string, searchInformation);
    }

    public static void doLocalSearch(final byte[] byArray, final String string, SearchInformation searchInformation) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                final SearchResultMediator searchResultMediator = SearchMediator.getResultPanelForGUID(new GUID(byArray));
                if (searchResultMediator != null && !searchResultMediator.isStopped()) {
                    searchResultMediator.incrementSearchCount();
                    final List<SmartSearchResult> list = LocalSearchEngine.instance().search(string);
                    final SearchFilter searchFilter = SearchMediator.getSearchFilterFactory().createFilter();
                    if (list.size() > 0) {
                        GUIMediator.safeInvokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    for (SmartSearchResult smartSearchResult : list) {
                                        if (!searchFilter.allow(smartSearchResult)) continue;
                                        SearchMediator.getSearchResultDisplayer().addQueryResult(byArray, smartSearchResult, searchResultMediator);
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                finally {
                                    SearchResultMediator searchResultMediator2 = SearchMediator.getResultPanelForGUID(new GUID(byArray));
                                    if (searchResultMediator2 != null) {
                                        searchResultMediator2.decrementSearchCount();
                                    }
                                }
                            }
                        });
                    }
                }
                LocalSearchEngine.instance().deepSearch(byArray, string);
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    private static List<SearchResult> normalizeWebResults(List<WebSearchResult> list, SearchEngine searchEngine, SearchInformation searchInformation) {
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        for (WebSearchResult webSearchResult : list) {
            AbstractSearchResult abstractSearchResult = null;
            abstractSearchResult = webSearchResult instanceof YouTubeSearchResult ? new YouTubePackageSearchResult((YouTubeSearchResult)webSearchResult, searchEngine, searchInformation.getQuery()) : (webSearchResult instanceof SoundcloudTrackSearchResult ? new SoundcloudSearchResult((SoundcloudTrackSearchResult)webSearchResult, searchEngine, searchInformation.getQuery()) : new SearchEngineSearchResult(webSearchResult, searchEngine, searchInformation.getQuery()));
            arrayList.add(abstractSearchResult);
        }
        return arrayList;
    }

    private static SearchResultMediator addResultTab(GUID gUID, SearchInformation searchInformation) {
        return SearchMediator.getSearchResultDisplayer().addResultTab(gUID, searchInformation);
    }

    public static void downloadFromPanel(SearchResultMediator searchResultMediator, SearchResultDataLine[] searchResultDataLineArray) {
        SearchMediator.downloadAll(searchResultDataLineArray, new GUID(searchResultMediator.getGUID()), searchResultMediator.getSearchInformation());
        searchResultMediator.refresh();
    }

    public static boolean hasTorrentDownloads(SearchResultDataLine[] searchResultDataLineArray) {
        for (SearchResultDataLine searchResultDataLine : searchResultDataLineArray) {
            SearchResult searchResult = (SearchResult)searchResultDataLine.getInitializeObject();
            if (!(searchResult instanceof BittorrentSearchResult)) continue;
            return true;
        }
        return false;
    }

    static void doDownload(final SearchResultMediator searchResultMediator) {
        final SearchResultDataLine[] searchResultDataLineArray = searchResultMediator.getAllSelectedLines();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!AzureusStarter.isAzureusCoreStarted() && SearchMediator.hasTorrentDownloads(searchResultDataLineArray)) {
                    GUIMediator.showMessage(I18n.tr("Please try this download in a few seconds, FrostWire is still warming up."));
                    return;
                }
                SearchMediator.downloadAll(searchResultDataLineArray, new GUID(searchResultMediator.getGUID()), searchResultMediator.getSearchInformation());
                searchResultMediator.refresh();
            }
        });
    }

    private static void downloadAll(SearchResultDataLine[] searchResultDataLineArray, GUID gUID, SearchInformation searchInformation) {
        for (int i = 0; i < searchResultDataLineArray.length; ++i) {
            SearchMediator.downloadLine(searchResultDataLineArray[i], gUID, null, null, false, searchInformation);
        }
    }

    private static void downloadLine(SearchResultDataLine searchResultDataLine, GUID gUID, File file, String string, boolean bl, SearchInformation searchInformation) {
        if (searchResultDataLine == null) {
            throw new NullPointerException("Tried to download null line");
        }
        searchResultDataLine.getSearchResult().download(false);
    }

    static void setTabDisplayCount(SearchResultMediator searchResultMediator) {
        SearchMediator.getSearchResultDisplayer().setTabDisplayCount(searchResultMediator);
    }

    static void killSearch() {
        SearchMediator.getSearchResultDisplayer().killSearch();
    }

    static void panelSelected(SearchResultMediator searchResultMediator) {
    }

    static void searchKilled(SearchResultMediator searchResultMediator) {
        SearchMediator.getSearchInputManager().panelRemoved(searchResultMediator);
        SearchResultMediator searchResultMediator2 = SearchMediator.getSearchResultDisplayer().getSelectedResultPanel();
        if (searchResultMediator2 != null) {
            // empty if block
        }
        searchResultMediator.cleanup();
    }

    static void checkToStopLime() {
        SearchMediator.getSearchResultDisplayer().checkToStopLime();
    }

    static SearchResultMediator getResultPanelForGUID(GUID gUID) {
        return SearchMediator.getSearchResultDisplayer().getResultPanelForGUID(gUID);
    }

    public static JComponent getSearchComponent() {
        return SearchMediator.getSearchInputManager().getComponent();
    }

    public static JComponent getResultComponent() {
        return SearchMediator.getSearchResultDisplayer().getComponent();
    }

    private static SearchInputManager getSearchInputManager() {
        if (INPUT_MANAGER == null) {
            INPUT_MANAGER = new SearchInputManager();
        }
        return INPUT_MANAGER;
    }

    public static SearchResultDisplayer getSearchResultDisplayer() {
        if (RESULT_DISPLAYER == null) {
            RESULT_DISPLAYER = new SearchResultDisplayer();
        }
        return RESULT_DISPLAYER;
    }

    public static SearchFilterFactory getSearchFilterFactory() {
        if (SEARCH_FILTER_FACTORY == null) {
            SEARCH_FILTER_FACTORY = new SearchFilterFactoryImpl();
        }
        return SEARCH_FILTER_FACTORY;
    }
}

