/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchResultNameHolder;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.ActionIconAndNameHolder;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;

public final class SearchResultDataLine
extends AbstractDataLine<SearchResult> {
    private final SearchTableColumns COLUMNS;
    private SearchResult RESULT;
    private List<SearchResult> _otherResults;
    private NamedMediaType _mediaType;
    private ResultSpeed _speed = null;
    private ActionListener _torrentDetailsAction;
    private Date addedOn;
    private SearchResultNameHolder name;
    private Object seeds;
    private Icon icon;
    private SizeHolder size;
    private ActionIconAndNameHolder source;

    public SearchResultDataLine(SearchTableColumns searchTableColumns) {
        this.COLUMNS = searchTableColumns;
    }

    @Override
    public void initialize(SearchResult searchResult) {
        super.initialize(searchResult);
        this.RESULT = searchResult;
        this._mediaType = NamedMediaType.getFromExtension(this.getExtension());
        this._speed = new ResultSpeed(searchResult.getSpeed(), searchResult.isMeasuredSpeed());
        this._torrentDetailsAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultDataLine.this.RESULT.showDetails(true);
            }
        };
        this.addedOn = searchResult.getCreationTime() > 0L ? new Date(searchResult.getCreationTime()) : null;
        this.name = new SearchResultNameHolder(searchResult);
        this.seeds = this.RESULT.getSeeds() <= 0 ? "" : Integer.valueOf(this.RESULT.getSeeds());
        this.icon = this.getIcon();
        this.size = new SizeHolder(this.getSize());
        this.source = new ActionIconAndNameHolder(null, this._torrentDetailsAction, "<html><a href=\"#\">" + this.RESULT.getSource() + "</a></html>");
    }

    @Override
    public void update() {
    }

    public String toString() {
        return this.getFilename() + " (" + this.getSeeds() + ")";
    }

    ResultSpeed getSpeed() {
        return this._speed;
    }

    private boolean isDownloading() {
        if (this.RESULT.getHash() != null) {
            return BTDownloadMediator.instance().isDownloading(this.RESULT.getHash());
        }
        return false;
    }

    public NamedMediaType getNamedMediaType() {
        return this._mediaType;
    }

    List<SearchResult> getOtherResults() {
        if (this._otherResults == null) {
            return Collections.emptyList();
        }
        return this._otherResults;
    }

    boolean isLaunchable() {
        return false;
    }

    Icon getIcon() {
        if (this.isDownloading()) {
            return GUIMediator.getThemeImage("downloading");
        }
        String string = this.getExtension();
        if (string.equals("torrent")) {
            String string2 = this.getFilename().replace(".torrent", "");
            Matcher matcher = Pattern.compile(".*\\.(\\S*)$").matcher(string2);
            if (matcher.matches()) {
                string = matcher.group(1);
            }
        }
        return IconManager.instance().getIconForExtension(string);
    }

    String getExtension() {
        return this.RESULT.getExtension();
    }

    public String getFilename() {
        return this.RESULT.getFileName();
    }

    public String getDisplayName() {
        return this.RESULT.getDisplayName();
    }

    public long getSize() {
        return this.RESULT.getSize();
    }

    String getVendor() {
        return this.RESULT.getSource();
    }

    @Override
    public LimeTableColumn getColumn(int n) {
        return this.COLUMNS.getColumn(n);
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public boolean isDynamic(int n) {
        return false;
    }

    @Override
    public boolean isClippable(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTypeAheadColumn() {
        return 2;
    }

    @Override
    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this.seeds;
            }
            case 1: {
                return this.icon;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.size;
            }
            case 4: {
                return this.source;
            }
            case 5: {
                return this.addedOn;
            }
            case 6: {
                return this.getExtension();
            }
        }
        return null;
    }

    public final boolean isSameKindAs(SearchResultDataLine searchResultDataLine) {
        return this.getSearchResult().getClass().equals(searchResultDataLine.getSearchResult().getClass());
    }

    public final SearchResult getSearchResult() {
        return this.RESULT;
    }

    public int getSeeds() {
        return this.RESULT.getSeeds();
    }

    public String getHash() {
        return this.RESULT.getHash();
    }

    public SearchEngine getSearchEngine() {
        return this.RESULT.getSearchEngine();
    }
}

