/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.components.Slide;
import com.frostwire.gui.components.SlideshowPanel;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.search.CancelSearchIconProxy;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.themes.SkinTabbedPane;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.UpdateManagerSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;

public final class SearchResultDisplayer
implements ThemeObserver,
RefreshListener {
    private JPanel MAIN_PANEL;
    private SkinTabbedPane tabbedPane;
    private static final List<SearchResultMediator> entries = new ArrayList<SearchResultMediator>();
    private JPanel results;
    private CardLayout switcher = new CardLayout();
    private SearchResultMediator DUMMY;
    private JPanel mainScreen;
    private ChangeListener _activeSearchListener;
    private final PaneListener PANE_LISTENER = new PaneListener();
    private SlideshowPanel promoSlides;

    public SearchResultDisplayer() {
        Object object;
        this.MAIN_PANEL = new BoxPanel(1);
        this.MAIN_PANEL.setMinimumSize(new Dimension(0, 0));
        this.tabbedPane = new SkinTabbedPane(GUIMediator.getThemeImage("indeterminate_small_progress"));
        this.results = new JPanel();
        this.results.setPreferredSize(new Dimension(10000, 10000));
        this.results.setLayout(this.switcher);
        this.results.setBackground(Color.WHITE);
        this.promoSlides = null;
        if (!UpdateManagerSettings.SHOW_PROMOTION_OVERLAYS.getValue()) {
            object = new Slide("http://static.frostwire.com/images/overlays/default_now_on_android.png", "http://www.frostwire.com/?from=defaultSlide", 10000L);
            Slide slide = new Slide("http://static.frostwire.com/images/overlays/frostclick_default_overlay.jpg", "http://www.frostclick.com/?from=defaultSlide", 10000L);
            this.promoSlides = new SlideshowPanel(Arrays.asList(object, slide), false);
        } else {
            this.promoSlides = new SlideshowPanel(UpdateManagerSettings.OVERLAY_SLIDESHOW_JSON_URL.getValue());
        }
        if (this.promoSlides != null) {
            this.promoSlides.setBackground(Color.WHITE);
            object = new Dimension(717, 380);
            this.promoSlides.setPreferredSize((Dimension)object);
            this.promoSlides.setSize((Dimension)object);
            this.promoSlides.setMaximumSize((Dimension)object);
            this.DUMMY = new SearchResultMediator(this.promoSlides);
            this.mainScreen = new JPanel(new BorderLayout());
            this.promoSlides.setupContainerAndControls(this.mainScreen, true);
            this.mainScreen.add((Component)this.DUMMY.getComponent(), "Center");
            this.results.add("dummy", this.mainScreen);
        }
        this.switcher.first(this.results);
        this.setupTabbedPane();
        this.MAIN_PANEL.add(this.results);
        ThemeMediator.addThemeObserver(this);
        CancelSearchIconProxy.updateTheme();
    }

    void setSearchListener(ChangeListener changeListener) {
        this._activeSearchListener = changeListener;
    }

    void updateResults() {
        for (int i = 0; i < entries.size(); ++i) {
            entries.get(i).refresh();
        }
    }

    public SlideshowPanel getSlideshowPanel() {
        return this.promoSlides;
    }

    SearchResultMediator addResultTab(GUID gUID, SearchInformation searchInformation) {
        SearchResultMediator searchResultMediator = new SearchResultMediator(gUID, searchInformation);
        return this.addResultPanelInternal(searchResultMediator, searchInformation.getTitle());
    }

    private void removeTabbedPaneListeners() {
        if (this.tabbedPane != null) {
            this.tabbedPane.removeMouseListener(this.PANE_LISTENER);
            this.tabbedPane.removeMouseMotionListener(this.PANE_LISTENER);
            this.tabbedPane.removeChangeListener(this.PANE_LISTENER);
        }
    }

    private void addTabbedPaneListeners() {
        if (this.tabbedPane != null) {
            this.tabbedPane.addMouseListener(this.PANE_LISTENER);
            this.tabbedPane.addMouseMotionListener(this.PANE_LISTENER);
            this.tabbedPane.addChangeListener(this.PANE_LISTENER);
        }
    }

    private void setupTabbedPane() {
        this.removeTabbedPaneListeners();
        this.tabbedPane = new SkinTabbedPane(GUIMediator.getThemeImage("indeterminate_small_progress"));
        this.tabbedPane.setRequestFocusEnabled(false);
        this.results.add("tabbedPane", this.tabbedPane);
        this.addTabbedPaneListeners();
    }

    private void resetTabbedPane() {
        int n;
        ArrayList<SearchResultMediator> arrayList = new ArrayList<SearchResultMediator>();
        ArrayList<Component> arrayList2 = new ArrayList<Component>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (n = 0; n < this.tabbedPane.getTabCount() && n < entries.size(); ++n) {
            arrayList2.add(this.tabbedPane.getComponent(n));
            arrayList3.add(this.tabbedPane.getTitleAt(n));
            arrayList.add(entries.get(n));
        }
        this.tabbedPane.removeAll();
        entries.clear();
        this.setupTabbedPane();
        for (n = 0; n < arrayList2.size(); ++n) {
            entries.add((SearchResultMediator)arrayList.get(n));
            this.tabbedPane.addTab((String)arrayList3.get(n), (Component)arrayList2.get(n));
        }
    }

    private SearchResultMediator addResultPanelInternal(SearchResultMediator searchResultMediator, String string) {
        entries.add(searchResultMediator);
        try {
            this.tabbedPane.addTab(string, CancelSearchIconProxy.createSelected(), searchResultMediator.getComponent());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.resetTabbedPane();
            entries.add(searchResultMediator);
            this.tabbedPane.addTab(string, CancelSearchIconProxy.createSelected(), searchResultMediator.getComponent());
        }
        try {
            this.tabbedPane.setSelectedIndex(entries.size() - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.resetTabbedPane();
            this.tabbedPane.setSelectedIndex(entries.size() - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.resetTabbedPane();
            this.tabbedPane.setSelectedIndex(entries.size() - 1);
        }
        try {
            this.tabbedPane.setExtraIconActiveAt(entries.size() - 1, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (SearchSettings.PARALLEL_SEARCH.getValue() > 10) {
            SearchSettings.PARALLEL_SEARCH.revertToDefault();
        }
        if (entries.size() > SearchSettings.PARALLEL_SEARCH.getValue()) {
            this.killSearchAtIndex(0);
        }
        GUIMediator.instance().setSearching(true);
        this.promoSlides.setVisible(false);
        this.switcher.last(this.results);
        this.MAIN_PANEL.revalidate();
        return searchResultMediator;
    }

    void addQueryResult(byte[] byArray, SearchResult searchResult, SearchResultMediator searchResultMediator) {
        if (searchResultMediator.isStopped()) {
            return;
        }
        if (!searchResultMediator.matches(new GUID(byArray))) {
            throw new IllegalArgumentException("guids don't match");
        }
        searchResultMediator.add(searchResult);
        int n = -1;
        n = entries.indexOf(searchResultMediator);
        if (n == -1) {
            return;
        }
        this.tabbedPane.setTitleAt(n, this.titleOf(searchResultMediator));
    }

    void updateSearchIcon(SearchResultMediator searchResultMediator, boolean bl) {
        int n = -1;
        n = entries.indexOf(searchResultMediator);
        if (n == -1) {
            return;
        }
        this.tabbedPane.setExtraIconActiveAt(n, bl);
    }

    void addChangeListener(ChangeListener changeListener) {
        this.tabbedPane.addChangeListener(changeListener);
    }

    void addFocusListener(FocusListener focusListener) {
        this.tabbedPane.addFocusListener(focusListener);
    }

    void showMenu(MouseEvent mouseEvent) {
        SearchResultMediator searchResultMediator = this.getSelectedResultPanel();
        if (searchResultMediator != null) {
            JPopupMenu jPopupMenu = searchResultMediator.createPopupMenu(new SearchResultDataLine[0]);
            Point point = mouseEvent.getPoint();
            if (jPopupMenu != null) {
                try {
                    jPopupMenu.show(this.MAIN_PANEL, point.x + 1, point.y - 6);
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
            }
        }
    }

    SearchResultMediator getSelectedResultPanel() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        try {
            return entries.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    SearchResultMediator getResultPanelForGUID(GUID gUID) {
        for (int i = 0; i < entries.size(); ++i) {
            SearchResultMediator searchResultMediator = entries.get(i);
            if (!searchResultMediator.matches(gUID)) continue;
            return searchResultMediator;
        }
        return null;
    }

    SearchResultMediator getPanelAtIndex(int n) {
        return entries.get(n);
    }

    List<SearchResultMediator> getResultPanels() {
        return new ArrayList<SearchResultMediator>(entries);
    }

    int getIndexForGUID(GUID gUID) {
        for (int i = 0; i < entries.size(); ++i) {
            SearchResultMediator searchResultMediator = entries.get(i);
            if (!searchResultMediator.matches(gUID)) continue;
            return i;
        }
        return -1;
    }

    int getIndexForPoint(int n, int n2) {
        TabbedPaneUI tabbedPaneUI = this.tabbedPane.getUI();
        return tabbedPaneUI.tabForCoordinate(this.tabbedPane, n, n2);
    }

    void killSearch() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= entries.size()) {
            this.resetTabbedPane();
            n = this.tabbedPane.getSelectedIndex();
        }
        if (n == -1) {
            return;
        }
        this.killSearchAtIndex(n);
    }

    void killSearchAtIndex(int n) {
        SearchResultMediator searchResultMediator = entries.remove(n);
        try {
            this.tabbedPane.removeTabAt(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.resetTabbedPane();
            this.tabbedPane.removeTabAt(n);
        }
        this.fixIcons();
        SearchMediator.searchKilled(searchResultMediator);
        ThemeMediator.removeThemeObserver(searchResultMediator);
        if (entries.size() == 0) {
            try {
                this.promoSlides.setVisible(true);
                this.switcher.first(this.results);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            GUIMediator.instance().setSearching(false);
        } else {
            this.checkToStopLime();
        }
    }

    void checkToStopLime() {
        if (entries == null || entries.size() == 0) {
            GUIMediator.instance().setSearching(false);
            return;
        }
        boolean bl = true;
        if (bl) {
            GUIMediator.instance().setSearching(false);
        }
    }

    void setTabDisplayCount(SearchResultMediator searchResultMediator) {
        int n;
        boolean bl = false;
        for (n = 0; n < entries.size(); ++n) {
            SearchResultMediator searchResultMediator2 = entries.get(n);
            if (searchResultMediator2 != searchResultMediator) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.tabbedPane.setTitleAt(n, this.titleOf(searchResultMediator));
        }
    }

    private void fixIcons() {
        int n = this.tabbedPane.getSelectedIndex();
        for (int i = 0; i < entries.size() && i < this.tabbedPane.getTabCount(); ++i) {
            this.tabbedPane.setIconAt(i, i == n ? CancelSearchIconProxy.createSelected() : CancelSearchIconProxy.createPlain());
        }
    }

    JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    @Override
    public void updateTheme() {
        this.DUMMY.updateTheme();
        CancelSearchIconProxy.updateTheme();
        this.fixIcons();
        for (SearchResultMediator searchResultMediator : entries) {
            searchResultMediator.updateTheme();
        }
    }

    @Override
    public void refresh() {
        this.checkToStopLime();
        if (this.tabbedPane.isVisible() && this.tabbedPane.isShowing()) {
            Rectangle rectangle = this.tabbedPane.getBounds();
            Component component = null;
            try {
                component = this.tabbedPane.getSelectedComponent();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.resetTabbedPane();
                component = this.tabbedPane.getSelectedComponent();
            }
            if (component != null) {
                Rectangle rectangle2 = component.getBounds();
                Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - 1);
                this.tabbedPane.repaint(rectangle3);
            }
        }
    }

    private String titleOf(SearchResultMediator searchResultMediator) {
        int n;
        int n2 = searchResultMediator.filteredResults();
        if (n2 < (n = searchResultMediator.totalResults())) {
            return searchResultMediator.getTitle() + " (" + n2 + "/" + n + ")";
        }
        return searchResultMediator.getTitle() + " (" + n + ")";
    }

    private class PaneListener
    implements MouseListener,
    MouseMotionListener,
    ChangeListener {
        private int lastIdx = -1;

        private PaneListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.tryPopup(mouseEvent)) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                int n;
                int n2 = mouseEvent.getX();
                int n3 = this.shouldKillIndex(n2, n = mouseEvent.getY());
                if (n3 != -1) {
                    this.lastIdx = -1;
                    SearchResultDisplayer.this.killSearchAtIndex(n3);
                }
                if (n3 == -1) {
                    this.stateChanged(null);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = this.shouldKillIndex(n2, n = mouseEvent.getY());
            if (n3 != this.lastIdx && this.lastIdx != -1) {
                this.resetIcon();
            }
            if (n3 != -1) {
                SearchResultDisplayer.this.tabbedPane.setIconAt(n3, CancelSearchIconProxy.createArmed());
                this.lastIdx = n3;
            }
        }

        private int shouldKillIndex(int n, int n2) {
            Icon icon;
            int n3 = SearchResultDisplayer.this.getIndexForPoint(n, n2);
            if (n3 != -1 && (icon = SearchResultDisplayer.this.tabbedPane.getIconAt(n3)) != null && icon instanceof CancelSearchIconProxy && ((CancelSearchIconProxy)icon).shouldKill(n, n2)) {
                return n3;
            }
            return -1;
        }

        private void resetIcon() {
            if (this.lastIdx != -1 && this.lastIdx < SearchResultDisplayer.this.tabbedPane.getTabCount()) {
                if (this.lastIdx == SearchResultDisplayer.this.tabbedPane.getSelectedIndex()) {
                    SearchResultDisplayer.this.tabbedPane.setIconAt(this.lastIdx, CancelSearchIconProxy.createSelected());
                } else {
                    SearchResultDisplayer.this.tabbedPane.setIconAt(this.lastIdx, CancelSearchIconProxy.createPlain());
                }
                this.lastIdx = -1;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.tryPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.tryPopup(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.resetIcon();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        private boolean tryPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n = SearchResultDisplayer.this.getIndexForPoint(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    try {
                        SearchResultDisplayer.this.tabbedPane.setSelectedIndex(n);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        SearchResultDisplayer.this.resetTabbedPane();
                        SearchResultDisplayer.this.tabbedPane.setSelectedIndex(n);
                    }
                }
                SearchResultDisplayer.this.showMenu(mouseEvent);
                return true;
            }
            return false;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SearchResultDisplayer.this._activeSearchListener.stateChanged(changeEvent);
            SearchResultDisplayer.this.fixIcons();
        }
    }
}

