/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.filters.TableLineFilter;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.MulticastTransferHandler;
import com.limegroup.gnutella.gui.search.CompositeFilter;
import com.limegroup.gnutella.gui.search.DateRenderer;
import com.limegroup.gnutella.gui.search.PercentageRenderer;
import com.limegroup.gnutella.gui.search.ResultPanelModel;
import com.limegroup.gnutella.gui.search.ResultPanelTransferHandler;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.ResultSpeedRenderer;
import com.limegroup.gnutella.gui.search.SearchButtons;
import com.limegroup.gnutella.gui.search.SearchColumnPreferenceHandler;
import com.limegroup.gnutella.gui.search.SearchColumnSelectionMenu;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMenu;
import com.limegroup.gnutella.gui.search.SearchResultNameEditor;
import com.limegroup.gnutella.gui.search.SearchResultNameHolder;
import com.limegroup.gnutella.gui.search.SearchResultNameRenderer;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.search.TableRowFilteredModel;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.ActionIconAndNameEditor;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.SkinMenu;
import com.limegroup.gnutella.gui.themes.SkinMenuItem;
import com.limegroup.gnutella.gui.themes.SkinPopupMenu;
import com.limegroup.gnutella.gui.util.PopupUtils;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.OverlayLayout;
import javax.swing.border.AbstractBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.limewire.i18n.I18nMarker;

public class SearchResultMediator
extends AbstractTableMediator<TableRowFilteredModel, SearchResultDataLine, SearchResult> {
    protected static final String SEARCH_TABLE = "SEARCH_TABLE";
    protected static final GUID STOPPED_GUID = new GUID(GUID.makeGuid());
    private static final DateRenderer DATE_RENDERER = new DateRenderer();
    private static final ResultSpeedRenderer RESULT_SPEED_RENDERER = new ResultSpeedRenderer();
    private static final PercentageRenderer PERCENTAGE_RENDERER = new PercentageRenderer();
    private static final SearchResultNameRenderer SEARCH_RESULT_NAME_RENDERER = new SearchResultNameRenderer();
    static final TableSettings SEARCH_SETTINGS = new TableSettings("SEARCH_TABLE");
    private final SearchInformation SEARCH_INFO;
    protected volatile GUID guid;
    CompositeFilter FILTER;
    ActionListener DOWNLOAD_LISTENER;
    MouseAdapter TORRENT_DETAILS_LISTENER;
    private ActionListener COPY_MAGNET_ACTION_LISTENER;
    private ActionListener COPY_HASH_ACTION_LISTENER;
    ActionListener CONFIGURE_SHARING_LISTENER;
    ActionListener DOWNLOAD_PARTIAL_FILES_LISTENER;
    ActionListener STOP_SEARCH_LISTENER;
    protected Box SOUTH_PANEL;
    public AtomicInteger searchCount = new AtomicInteger(0);

    SearchResultMediator(JPanel jPanel) {
        super(SEARCH_TABLE);
        this.setupFakeTable(jPanel);
        this.SEARCH_INFO = SearchInformation.createKeywordSearch("", null, MediaType.getAnyTypeMediaType());
        this.FILTER = null;
        this.guid = STOPPED_GUID;
        this.setButtonEnabled(2, false);
        this.TABLE.setDragEnabled(false);
        this.TABLE.setTransferHandler(null);
        this.SOUTH_PANEL.setVisible(false);
    }

    SearchResultMediator(String string, String string2) {
        super(string2);
        this.SEARCH_INFO = SearchInformation.createKeywordSearch(string, null, MediaType.getAnyTypeMediaType());
        this.guid = STOPPED_GUID;
    }

    SearchResultMediator(GUID gUID, SearchInformation searchInformation) {
        super(SEARCH_TABLE);
        this.SEARCH_INFO = searchInformation;
        this.guid = gUID;
        this.setupRealTable();
        this.resetFilters();
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(ResultSpeed.class, RESULT_SPEED_RENDERER);
        this.TABLE.setDefaultRenderer(Date.class, DATE_RENDERER);
        this.TABLE.setDefaultRenderer(Float.class, PERCENTAGE_RENDERER);
        this.TABLE.setDefaultRenderer(SearchResultNameHolder.class, SEARCH_RESULT_NAME_RENDERER);
    }

    @Override
    protected void updateSplashScreen() {
    }

    protected void setupDataModel() {
        this.DATA_MODEL = new TableRowFilteredModel(this.FILTER);
    }

    @Override
    protected void setupConstants() {
        this.FILTER = new CompositeFilter(4);
        this.MAIN_PANEL = new PaddedPanel();
        this.setupDataModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.BUTTON_ROW = new SearchButtons(this).getComponent();
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new MulticastTransferHandler(new ResultPanelTransferHandler(this), DNDUtils.DEFAULT_TRANSFER_HANDLERS));
    }

    @Override
    protected void buildSettings() {
        this.SETTINGS = SEARCH_SETTINGS;
    }

    @Override
    protected JPopupMenu createColumnSelectionMenu() {
        return new SearchColumnSelectionMenu(this.TABLE).getComponent();
    }

    @Override
    protected ColumnPreferenceHandler createDefaultColumnPreferencesHandler() {
        return new SearchColumnPreferenceHandler(this.TABLE);
    }

    @Override
    protected void addListeners() {
        super.addListeners();
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.DOWNLOAD_LISTENER = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchMediator.doDownload(SearchResultMediator.this);
            }
        };
        this.TORRENT_DETAILS_LISTENER = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SearchResultDataLine[] searchResultDataLineArray;
                if (mouseEvent.getButton() == 1 && (searchResultDataLineArray = SearchResultMediator.this.getAllSelectedLines()).length == 1) {
                    SearchResult searchResult = searchResultDataLineArray[0].getSearchResult();
                    searchResult.showDetails(true);
                }
            }
        };
        this.COPY_MAGNET_ACTION_LISTENER = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultDataLine[] searchResultDataLineArray = SearchResultMediator.this.getAllSelectedLines();
                String string = "";
                for (SearchResultDataLine searchResultDataLine : searchResultDataLineArray) {
                    string = string + TorrentUtil.getMagnet(((SearchResult)searchResultDataLine.getInitializeObject()).getHash());
                    string = string + "\n";
                }
                GUIMediator.setClipboardContent(string);
            }
        };
        this.COPY_HASH_ACTION_LISTENER = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultDataLine[] searchResultDataLineArray = SearchResultMediator.this.getAllSelectedLines();
                String string = "";
                for (SearchResultDataLine searchResultDataLine : searchResultDataLineArray) {
                    string = string + ((SearchResult)searchResultDataLine.getInitializeObject()).getHash();
                    string = string + "\n";
                }
                GUIMediator.setClipboardContent(string);
            }
        };
        this.CONFIGURE_SHARING_LISTENER = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().setOptionsVisible(true, I18n.tr("Options"));
            }
        };
        this.DOWNLOAD_PARTIAL_FILES_LISTENER = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultDataLine[] searchResultDataLineArray = SearchResultMediator.this.getAllSelectedLines();
                if (searchResultDataLineArray.length == 1 && searchResultDataLineArray[0] != null) {
                    GUIMediator.instance().openTorrentSearchResult(((SearchResult)searchResultDataLineArray[0].getInitializeObject()).getWebSearchResult(), true);
                }
            }
        };
        this.STOP_SEARCH_LISTENER = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultMediator.this.guid = STOPPED_GUID;
                SearchMediator.getSearchResultDisplayer().updateSearchIcon(SearchResultMediator.this, false);
                SearchResultMediator.this.setButtonEnabled(3, !SearchResultMediator.this.isStopped());
            }
        };
    }

    @Override
    public JPopupMenu createPopupMenu() {
        return this.createPopupMenu(this.getAllSelectedLines());
    }

    protected JPopupMenu createPopupMenu(SearchResultDataLine[] searchResultDataLineArray) {
        if (!this.isKillable()) {
            return null;
        }
        SkinPopupMenu skinPopupMenu = new SkinPopupMenu();
        if (searchResultDataLineArray.length > 0) {
            boolean bl = true;
            for (int i = 0; i < searchResultDataLineArray.length; ++i) {
                if (searchResultDataLineArray[i].getHash() != null) continue;
                bl = false;
                break;
            }
            PopupUtils.addMenuItem(I18n.tr("Copy Magnet"), this.COPY_MAGNET_ACTION_LISTENER, skinPopupMenu, !this.isStopped() && bl);
            PopupUtils.addMenuItem(I18n.tr("Copy Hash"), this.COPY_HASH_ACTION_LISTENER, skinPopupMenu, !this.isStopped() && bl);
            skinPopupMenu.add(this.createSearchAgainMenu(searchResultDataLineArray[0]));
        } else {
            skinPopupMenu.add(new SkinMenuItem(new RepeatSearchAction()));
        }
        return new SearchResultMenu(this).addToMenu(skinPopupMenu, searchResultDataLineArray);
    }

    protected final JMenu createSearchAgainMenu(SearchResultDataLine searchResultDataLine) {
        SkinMenu skinMenu = new SkinMenu(I18n.tr("Search More"));
        skinMenu.add(new SkinMenuItem(new RepeatSearchAction()));
        if (searchResultDataLine == null) {
            skinMenu.setEnabled(this.isRepeatSearchEnabled());
            return skinMenu;
        }
        skinMenu.addSeparator();
        String string = QueryUtils.createQueryString(searchResultDataLine.getFilename());
        SearchInformation searchInformation = SearchInformation.createKeywordSearch(string, null, MediaType.getAnyTypeMediaType());
        if (SearchMediator.validateInfo(searchInformation) == 0) {
            skinMenu.add(new SkinMenuItem(new SearchAction(searchInformation, I18nMarker.marktr("Search for Keywords: {0}"))));
        }
        return skinMenu;
    }

    @Override
    public void removeSelection() {
    }

    @Override
    public void clearTable() {
        super.clearTable();
    }

    @Override
    public void handleNoSelection() {
        this.setButtonEnabled(1, false);
        this.setButtonEnabled(2, false);
        this.setButtonEnabled(3, !this.isStopped());
    }

    @Override
    public void handleSelection(int n) {
        this.setButtonEnabled(1, true);
        this.setButtonEnabled(3, !this.isStopped());
        SearchResultDataLine[] searchResultDataLineArray = this.getAllSelectedLines();
        this.setButtonEnabled(2, searchResultDataLineArray != null && searchResultDataLineArray.length == 1);
    }

    @Override
    public void handleActionKey() {
        this.DOWNLOAD_LISTENER.actionPerformed(null);
    }

    SearchInformation getSearchInformation() {
        return this.SEARCH_INFO;
    }

    String getQuery() {
        return this.SEARCH_INFO.getQuery();
    }

    String getTitle() {
        return this.SEARCH_INFO.getTitle();
    }

    String getRichQuery() {
        return this.SEARCH_INFO.getXML();
    }

    void showLicense() {
    }

    boolean isStopped() {
        if (this.guid == null || STOPPED_GUID == null) {
            return false;
        }
        return this.guid.equals(STOPPED_GUID);
    }

    boolean isEmpty() {
        return ((TableRowFilteredModel)this.DATA_MODEL).getRowCount() == 0;
    }

    boolean isKillable() {
        return this.FILTER != null;
    }

    boolean filterChanged(TableLineFilter<SearchResultDataLine> tableLineFilter, int n) {
        int n2;
        this.FILTER.setFilter(n, tableLineFilter);
        int[] nArray = this.TABLE.getSelectedRows();
        SearchResultDataLine[] searchResultDataLineArray = new SearchResultDataLine[nArray.length];
        LinkedList<SearchResultDataLine> linkedList = new LinkedList<SearchResultDataLine>();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            SearchResultDataLine searchResultDataLine;
            int n3 = nArray[n2];
            searchResultDataLineArray[n2] = searchResultDataLine = (SearchResultDataLine)((TableRowFilteredModel)this.DATA_MODEL).get(n3);
            if (!this.TABLE.isRowVisible(n3)) continue;
            linkedList.add(searchResultDataLine);
        }
        ((TableRowFilteredModel)this.DATA_MODEL).filtersChanged();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            SearchResultDataLine searchResultDataLine = searchResultDataLineArray[n2];
            int n4 = ((TableRowFilteredModel)this.DATA_MODEL).getRow(searchResultDataLine);
            if (n4 == -1) continue;
            this.TABLE.addRowSelectionInterval(n4, n4);
            if (linkedList == null || !linkedList.contains(searchResultDataLine)) continue;
            this.TABLE.ensureRowVisible(n4);
            linkedList = null;
        }
        SearchMediator.setTabDisplayCount(this);
        return true;
    }

    int totalSources() {
        return ((ResultPanelModel)this.DATA_MODEL).getTotalSources();
    }

    int totalResults() {
        return ((ResultPanelModel)this.DATA_MODEL).getTotalResults();
    }

    int filteredSources() {
        return ((TableRowFilteredModel)this.DATA_MODEL).getFilteredSources();
    }

    int filteredResults() {
        return ((TableRowFilteredModel)this.DATA_MODEL).getFilteredResults();
    }

    boolean isRepeatSearchEnabled() {
        return this.FILTER != null;
    }

    void repeatSearch(boolean bl) {
        if (bl) {
            this.clearTable();
            this.resetFilters();
        }
        SearchMediator.setTabDisplayCount(this);
        SearchMediator.repeatSearch(this, this.SEARCH_INFO, bl);
        this.setButtonEnabled(2, false);
        this.setButtonEnabled(3, !this.isStopped());
    }

    void resetFilters() {
        this.FILTER.reset();
        ((TableRowFilteredModel)this.DATA_MODEL).setJunkFilter(null);
    }

    public List<SearchResultDataLine> getAllData() {
        return ((TableRowFilteredModel)this.DATA_MODEL).getAllData();
    }

    boolean matches(GUID gUID) {
        return this.guid.equals(gUID);
    }

    void setGUID(GUID gUID) {
        this.guid = gUID;
    }

    byte[] getGUID() {
        return this.guid.bytes();
    }

    MediaType getMediaType() {
        return this.SEARCH_INFO.getMediaType();
    }

    SearchResultDataLine[] getAllSelectedLines() {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray == null) {
            return new SearchResultDataLine[0];
        }
        SearchResultDataLine[] searchResultDataLineArray = new SearchResultDataLine[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            searchResultDataLineArray[i] = (SearchResultDataLine)((TableRowFilteredModel)this.DATA_MODEL).get(nArray[i]);
        }
        return searchResultDataLineArray;
    }

    SearchResultDataLine getSelectedLine() {
        int n = this.TABLE.getSelectedRow();
        if (n != -1) {
            return (SearchResultDataLine)((TableRowFilteredModel)this.DATA_MODEL).get(n);
        }
        return null;
    }

    final SearchResultDataLine getLine(int n) {
        return (SearchResultDataLine)((TableRowFilteredModel)this.DATA_MODEL).get(n);
    }

    private void setupRealTable() {
        SearchTableColumns searchTableColumns = ((ResultPanelModel)this.DATA_MODEL).getColumns();
        LimeTableColumn limeTableColumn = searchTableColumns.getColumn(0);
        if (this.SETTINGS.REAL_TIME_SORT.getValue() && this.TABLE.isColumnVisible(limeTableColumn.getId())) {
            ((TableRowFilteredModel)this.DATA_MODEL).sort(0);
            ((TableRowFilteredModel)this.DATA_MODEL).sort(0);
        }
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.isConsumed()) {
                    return;
                }
                mouseEvent.consume();
                SearchMediator.panelSelected(SearchResultMediator.this);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        };
        this.MAIN_PANEL.addMouseListener(mouseListener);
        this.SCROLL_PANE.addMouseListener(mouseListener);
        this.TABLE.addMouseListener(mouseListener);
        this.TABLE.getTableHeader().addMouseListener(mouseListener);
    }

    protected void setupMainPanelBase() {
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.MAIN_PANEL != null) {
            this.MAIN_PANEL.add(this.getScrolledTablePane());
            this.addButtonRow();
            this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
        } else {
            super.setupMainPanel();
        }
    }

    @Override
    protected void setupMainPanel() {
        this.setupMainPanelBase();
    }

    private void setupFakeTable(JPanel jPanel) {
        this.MAIN_PANEL.removeAll();
        JPanel jPanel2 = new JPanel(){
            private static final long serialVersionUID = 8931395134232576566L;

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        jPanel2.setLayout(new OverlayLayout(jPanel2));
        BoxPanel boxPanel = new BoxPanel(1);
        boxPanel.setOpaque(false);
        boxPanel.add(Box.createVerticalStrut(20));
        boxPanel.add(jPanel);
        boxPanel.setMinimumSize(new Dimension(0, 0));
        JComponent jComponent = this.getScrolledTablePane();
        jComponent.setOpaque(false);
        jPanel2.add(boxPanel);
        jPanel2.add(jComponent);
        this.MAIN_PANEL.add(jPanel2);
        this.addButtonRow();
        this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
    }

    private void addButtonRow() {
        if (this.BUTTON_ROW != null) {
            this.SOUTH_PANEL = Box.createVerticalBox();
            this.SOUTH_PANEL.setOpaque(false);
            this.SOUTH_PANEL.add(Box.createVerticalStrut(6));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.BUTTON_ROW, gridBagConstraints);
            jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 64));
            this.SOUTH_PANEL.add(jPanel);
            this.MAIN_PANEL.add(this.SOUTH_PANEL);
        }
    }

    public void cleanup() {
    }

    @Override
    protected void setDefaultEditors() {
        TableColumnModel tableColumnModel = this.TABLE.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setCellEditor(new SearchResultNameEditor());
        tableColumn = tableColumnModel.getColumn(4);
        tableColumn.setCellEditor(new ActionIconAndNameEditor());
    }

    public void incrementSearchCount() {
        SearchMediator.getSearchResultDisplayer().updateSearchIcon(this, this.searchCount.incrementAndGet() > 0);
    }

    public void decrementSearchCount() {
        SearchMediator.getSearchResultDisplayer().updateSearchIcon(this, this.searchCount.decrementAndGet() > 0);
    }

    private final class RepeatSearchAction
    extends AbstractAction {
        private static final long serialVersionUID = -209446182720400951L;

        public RepeatSearchAction() {
            this.putValue("Name", SearchMediator.REPEAT_SEARCH_STRING);
            this.setEnabled(SearchResultMediator.this.isRepeatSearchEnabled());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchResultMediator.this.repeatSearch(true);
        }
    }

    public class WarningBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 1031178095074065273L;
        private Color lineColor;
        private int offset;

        public WarningBorder(Color color, int n) {
            this.lineColor = color;
            this.offset = n;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.lineColor);
            graphics.drawLine(n, n2, n + n3 - 1 - this.offset, n2);
            graphics.drawLine(n, n2, n, n2 + n4);
            graphics.drawLine(n + n3 - 1 - this.offset, n2, n + n3 - 1 - this.offset, n2 + n4);
            if (this.offset > 0) {
                graphics.setColor(component.getParent().getBackground());
                for (int i = 0; i < this.offset; ++i) {
                    graphics.drawLine(n + n3 - 1 - i, n2, n + n3 - 1 - i, n2 + n4);
                }
            }
            graphics.setColor(color);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 0, 1 + this.offset);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

