/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;

public final class SearchResultNameHolder
implements Comparable<SearchResultNameHolder> {
    private final SearchResult sr;
    private final String html;

    public SearchResultNameHolder(SearchResult searchResult) {
        this.sr = searchResult;
        this.html = "<html><div width=\"1000000px\">" + this.simpleHighlighter(searchResult.getQuery(), searchResult.getDisplayName()) + "</div></html>";
    }

    @Override
    public int compareTo(SearchResultNameHolder searchResultNameHolder) {
        return AbstractTableMediator.compare(this.sr.getDisplayName(), searchResultNameHolder.sr.getDisplayName());
    }

    public SearchResult getSearchResult() {
        return this.sr;
    }

    public String getHtml() {
        return this.html;
    }

    public String toString() {
        return this.sr.getDisplayName();
    }

    private String simpleHighlighter(String string, String string2) {
        for (String string3 : string.split("\\s+")) {
            StringBuilder stringBuilder = new StringBuilder(2 * string2.length());
            int n = 0;
            while (n < string2.length()) {
                if (n + string3.length() <= string2.length()) {
                    String string4 = string2.substring(n, string3.length() + n);
                    if (string4.equalsIgnoreCase(string3)) {
                        stringBuilder.append("<b>" + string4 + "</b>");
                        n += string4.length();
                        continue;
                    }
                    stringBuilder.append(string2.charAt(n));
                    ++n;
                    continue;
                }
                stringBuilder.append(string2.charAt(n));
                ++n;
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }
}

