/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.XMLUtils;
import org.limewire.util.StringUtils;

class Selector {
    public static final int SCHEMA = 1;
    public static final int FIELD = 2;
    public static final int PROPERTY = 3;
    private static final String S_SCHEMA = "schema";
    private static final String S_FIELD = "field";
    private static final String S_PROPERTY = "property";
    private final String _SCHEMA;
    private final String _VALUE;
    private final int _TYPE;
    private final PropertyType propertyType;
    private boolean _minimized = false;
    private int cachedHashCode;

    private Selector(String string, String string2, int n) {
        this._SCHEMA = string;
        this._VALUE = string2;
        this._TYPE = n;
        this.propertyType = null;
    }

    private Selector(String string, PropertyType propertyType) {
        this._SCHEMA = string;
        this._VALUE = propertyType.getKey();
        this._TYPE = 3;
        this.propertyType = propertyType;
    }

    public static Selector createSchemaSelector() {
        return new Selector("", "", 1);
    }

    public static Selector createFieldSelector(String string, String string2) {
        return new Selector(string, string2, 2);
    }

    public static Selector createPropertySelector(String string) throws IllegalArgumentException {
        PropertyType propertyType = PropertyType.fromKey(string);
        return new Selector("", propertyType);
    }

    public static Selector createPropertySelector(PropertyType propertyType) {
        return new Selector("", propertyType);
    }

    public static Selector createFromString(String string) {
        String string2;
        Selector selector;
        String string3;
        String string4;
        if (string == null) {
            throw new IllegalArgumentException("null value");
        }
        int n = (string = string.toLowerCase()).indexOf("|");
        if (n == -1 || n == string.length()) {
            string4 = string.trim();
            string3 = "";
        } else {
            string4 = string.substring(0, n).trim();
            string3 = string.substring(n + 1).trim();
        }
        String[] stringArray = StringUtils.split(string4, ",");
        if (stringArray.length == 0) {
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        if (S_SCHEMA.equals(stringArray[0])) {
            selector = Selector.createSchemaSelector();
            if (stringArray.length != 1) {
                throw new IllegalArgumentException(string);
            }
        } else if (S_FIELD.equals(stringArray[0])) {
            if (stringArray.length != 3) {
                throw new IllegalArgumentException(string);
            }
            string2 = stringArray[1];
            String string5 = stringArray[2];
            selector = Selector.createFieldSelector(string2, string5);
        } else if (S_PROPERTY.equals(stringArray[0])) {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException(string);
            }
            string2 = stringArray[1].toUpperCase();
            selector = Selector.createPropertySelector(string2);
        } else {
            throw new IllegalArgumentException(string);
        }
        stringArray = StringUtils.split(string3, ",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        if (stringArray.length > 0) {
            selector.setMinimized(stringArray[0].equals("true"));
        }
        return selector;
    }

    public String toString() {
        String string;
        switch (this._TYPE) {
            case 1: {
                string = S_SCHEMA;
                break;
            }
            case 2: {
                string = "field, " + this._SCHEMA + ", " + this._VALUE;
                break;
            }
            case 3: {
                string = "property, " + this._VALUE;
                break;
            }
            default: {
                throw new IllegalStateException("invalid type: " + this._TYPE);
            }
        }
        return string + " | " + this._minimized;
    }

    public boolean isMinimized() {
        return this._minimized;
    }

    public void setMinimized(boolean bl) {
        this._minimized = bl;
    }

    public String getTitle() {
        switch (this._TYPE) {
            case 1: {
                return I18n.tr("Media");
            }
            case 2: {
                return XMLUtils.getResource(this._VALUE);
            }
            case 3: {
                return this.propertyType.getTitle();
            }
        }
        throw new IllegalArgumentException("invalid type: " + this._TYPE);
    }

    public boolean isSchemaSelector() {
        return this._TYPE == 1;
    }

    public boolean isFieldSelector() {
        return this._TYPE == 2;
    }

    public boolean isPropertySelector() {
        return this._TYPE == 3;
    }

    public int getSelectorType() {
        return this._TYPE;
    }

    public String getSchema() {
        if (this._TYPE != 2) {
            throw new IllegalStateException("invalid type: " + this._TYPE);
        }
        return this._SCHEMA;
    }

    public String getValue() {
        if (this._TYPE != 2 && this._TYPE != 3) {
            throw new IllegalStateException("invalid type: " + this._TYPE);
        }
        return this._VALUE;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Selector) {
            Selector selector = (Selector)object;
            return selector._TYPE == this._TYPE && selector._SCHEMA.equals(this._SCHEMA) && selector._VALUE.equals(this._VALUE);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this._TYPE + 31 * this._SCHEMA.hashCode() + 961 * this._VALUE.hashCode();
        }
        return this.cachedHashCode;
    }

    static enum PropertyType {
        TYPE("RESULT_PANEL_TYPE", I18n.tr("Type")),
        SPEED("RESULT_PANEL_SPEED", I18n.tr("Speed")),
        VENDOR("RESULT_PANEL_VENDOR", I18n.tr("Vendor"));

        private final String key;
        private final String title;

        private PropertyType(String string2, String string3) {
            this.key = string2;
            this.title = string3;
        }

        public String getTitle() {
            return this.title;
        }

        public String getKey() {
            return this.key;
        }

        public static PropertyType fromKey(String string) throws IllegalArgumentException {
            for (PropertyType propertyType : PropertyType.values()) {
                if (!string.equals(propertyType.key)) continue;
                return propertyType;
            }
            throw new IllegalArgumentException("not a key for a type: " + string);
        }
    }
}

