/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.AbstractSearchResult;
import com.limegroup.gnutella.gui.search.BittorrentSearchResult;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.search.db.TorrentDBPojo;
import com.limegroup.gnutella.gui.search.db.TorrentFileDBPojo;
import com.limegroup.gnutella.gui.util.PopupUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JPopupMenu;

public class SmartSearchResult
extends AbstractSearchResult
implements BittorrentSearchResult {
    private WebSearchResult _item;
    private SearchEngine _searchEngine;
    TorrentDBPojo torrent;
    TorrentFileDBPojo file;

    public SmartSearchResult(TorrentDBPojo torrentDBPojo, TorrentFileDBPojo torrentFileDBPojo, String string) {
        super(string);
        this.torrent = torrentDBPojo;
        this._item = new WebSearchResultProxy(this.torrent);
        this.file = torrentFileDBPojo;
        this._searchEngine = SearchEngine.getSearchEngineById(torrentDBPojo.searchEngineID);
    }

    @Override
    public long getCreationTime() {
        return this._item.getCreationTime();
    }

    @Override
    public String getExtension() {
        return this.file.relativePath.substring(this.file.relativePath.lastIndexOf(".") + 1).toLowerCase();
    }

    @Override
    public String getFileName() {
        if (this.file.relativePath.startsWith("/")) {
            this.file.relativePath = this.file.relativePath.substring(1);
        }
        return new File(this.file.relativePath).getName();
    }

    @Override
    public String getDisplayName() {
        if (this.file.relativePath.indexOf("/") != -1) {
            String string = this.file.relativePath.substring(this.file.relativePath.lastIndexOf("/"));
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            return string.substring(0, string.lastIndexOf("."));
        }
        return this.file.relativePath.substring(0, this.file.relativePath.lastIndexOf("."));
    }

    @Override
    public int getQuality() {
        return 0;
    }

    @Override
    public String getHash() {
        return this._item.getHash();
    }

    @Override
    public String getTorrentURI() {
        return this._item.getTorrentURI();
    }

    @Override
    public long getSize() {
        return this.file.size;
    }

    @Override
    public int getSpeed() {
        return 0x7FFFFFFD;
    }

    @Override
    public String getSource() {
        return this._item.getSource();
    }

    @Override
    public boolean isMeasuredSpeed() {
        return false;
    }

    @Override
    public void download(boolean bl) {
        GUIMediator.instance().openTorrentSearchResult(this._item, this.file.relativePath);
        this.showDetails(false);
    }

    @Override
    public JPopupMenu createMenu(JPopupMenu jPopupMenu, SearchResultDataLine[] searchResultDataLineArray, SearchResultMediator searchResultMediator) {
        PopupUtils.addMenuItem(SearchMediator.DOWNLOAD_STRING, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SmartSearchResult.this.download(false);
            }
        }, jPopupMenu, searchResultDataLineArray.length > 0, 1);
        PopupUtils.addMenuItem(SearchMediator.TORRENT_DETAILS_STRING, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SmartSearchResult.this.showDetails(true);
            }
        }, jPopupMenu, searchResultDataLineArray.length == 1, 2);
        return jPopupMenu;
    }

    @Override
    public int getSeeds() {
        return this._item.getSeeds();
    }

    @Override
    public SearchEngine getSearchEngine() {
        return this._searchEngine;
    }

    @Override
    public WebSearchResult getWebSearchResult() {
        return this._item;
    }

    private class WebSearchResultProxy
    implements WebSearchResult {
        private TorrentDBPojo _torrentDBPojo;

        public WebSearchResultProxy(TorrentDBPojo torrentDBPojo) {
            this._torrentDBPojo = torrentDBPojo;
        }

        @Override
        public String getFileName() {
            return this._torrentDBPojo.fileName;
        }

        @Override
        public long getSize() {
            return this._torrentDBPojo.size;
        }

        @Override
        public long getCreationTime() {
            return this._torrentDBPojo.creationTime;
        }

        @Override
        public String getSource() {
            return this._torrentDBPojo.vendor;
        }

        @Override
        public String getHash() {
            return this._torrentDBPojo.hash;
        }

        @Override
        public String getTorrentURI() {
            return this._torrentDBPojo.torrentURI;
        }

        @Override
        public int getSeeds() {
            return this._torrentDBPojo.seeds;
        }

        @Override
        public String getDetailsUrl() {
            return this._torrentDBPojo.torrentDetailsURL;
        }

        @Override
        public String getDisplayName() {
            return null;
        }
    }
}

