/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.bittorrent.websearch.soundcloud.SoundcloudTrackSearchResult;
import com.frostwire.gui.player.StreamAudioSource;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.AbstractSearchResult;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.search.StreamableSearchResult;
import com.limegroup.gnutella.gui.util.PopupUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPopupMenu;

public final class SoundcloudSearchResult
extends AbstractSearchResult
implements StreamableSearchResult {
    private final SoundcloudTrackSearchResult sr;
    private final SearchEngine searchEngine;

    public SoundcloudSearchResult(SoundcloudTrackSearchResult soundcloudTrackSearchResult, SearchEngine searchEngine, String string) {
        super(string);
        this.sr = soundcloudTrackSearchResult;
        this.searchEngine = searchEngine;
    }

    @Override
    public String getFileName() {
        return this.sr.getFileName();
    }

    @Override
    public String getDisplayName() {
        return this.sr.getDisplayName();
    }

    @Override
    public long getSize() {
        return this.sr.getSize();
    }

    @Override
    public long getCreationTime() {
        return this.sr.getCreationTime();
    }

    @Override
    public String getSource() {
        return this.sr.getSource();
    }

    @Override
    public int getSpeed() {
        return 0x7FFFFFFD;
    }

    @Override
    public boolean isMeasuredSpeed() {
        return false;
    }

    @Override
    public int getQuality() {
        return 0;
    }

    @Override
    public void download(boolean bl) {
        GUIMediator.instance().openSoundcloudTrackUrl(this.sr.getTorrentURI(), this.sr.getDisplayName());
        this.showDetails(false);
    }

    @Override
    public JPopupMenu createMenu(JPopupMenu jPopupMenu, SearchResultDataLine[] searchResultDataLineArray, SearchResultMediator searchResultMediator) {
        PopupUtils.addMenuItem(SearchMediator.DOWNLOAD_STRING, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SoundcloudSearchResult.this.download(false);
            }
        }, jPopupMenu, searchResultDataLineArray.length > 0, 1);
        PopupUtils.addMenuItem(SearchMediator.SOUNDCLOUD_DETAILS_STRING, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SoundcloudSearchResult.this.showDetails(true);
            }
        }, jPopupMenu, searchResultDataLineArray.length == 1, 2);
        return jPopupMenu;
    }

    @Override
    public String getHash() {
        return this.sr.getHash();
    }

    @Override
    public String getTorrentURI() {
        return this.sr.getTorrentURI();
    }

    @Override
    public int getSeeds() {
        return this.sr.getSeeds();
    }

    @Override
    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    @Override
    public WebSearchResult getWebSearchResult() {
        return this.sr;
    }

    @Override
    public void play() {
        GUIMediator.instance().launchAudio(new StreamAudioSource(this.sr.getStreamUrl(), "Soundcloud: " + this.sr.getDisplayName(), this.sr.getDetailsUrl()));
    }

    @Override
    public String getStreamUrl() {
        return this.sr.getStreamUrl();
    }
}

