/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.filters.TableLineFilter;
import com.limegroup.gnutella.gui.search.AllowFilter;
import com.limegroup.gnutella.gui.search.ResultPanelModel;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.settings.SearchSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableRowFilteredModel
extends ResultPanelModel {
    private static final long serialVersionUID = -7810977044778830969L;
    private final TableLineFilter<SearchResultDataLine> FILTER;
    private TableLineFilter<SearchResultDataLine> junkFilter = AllowFilter.instance();
    protected final List<SearchResultDataLine> HIDDEN;
    private int _numSources;
    private int _numResults;

    public TableRowFilteredModel(TableLineFilter<SearchResultDataLine> tableLineFilter) {
        if (tableLineFilter == null) {
            throw new NullPointerException("null filter");
        }
        this.FILTER = tableLineFilter;
        this.HIDDEN = new ArrayList<SearchResultDataLine>();
        this._numSources = 0;
        this._numResults = 0;
    }

    @Override
    public boolean isSorted() {
        return super.isSorted() || SearchSettings.moveJunkToBottom();
    }

    public int getFilteredSources() {
        return super.getTotalSources();
    }

    @Override
    public int getTotalSources() {
        return this.getFilteredSources() + this._numSources;
    }

    @Override
    public int add(SearchResultDataLine searchResultDataLine, int n) {
        boolean bl = this.junkFilter.allow(searchResultDataLine);
        boolean bl2 = this.allow(searchResultDataLine);
        if (bl || !SearchSettings.hideJunk()) {
            if (bl2) {
                return super.add(searchResultDataLine, n);
            }
            this.HIDDEN.add(searchResultDataLine);
            this._numSources += searchResultDataLine.getSeeds();
            ++this._numResults;
        } else {
            this._numSources += searchResultDataLine.getSeeds();
            ++this._numResults;
        }
        return -1;
    }

    @Override
    protected void simpleClear() {
        this._numSources = 0;
        this._numResults = 0;
        this.HIDDEN.clear();
        super.simpleClear();
    }

    void filtersChanged() {
        this.rebuild();
        this.fireTableDataChanged();
    }

    void setJunkFilter(TableLineFilter<SearchResultDataLine> tableLineFilter) {
        this.junkFilter = tableLineFilter != null ? tableLineFilter : AllowFilter.instance();
    }

    private boolean allow(SearchResultDataLine searchResultDataLine) {
        return this.FILTER.allow(searchResultDataLine);
    }

    private void rebuild() {
        int n;
        ArrayList arrayList = new ArrayList(this._list);
        ArrayList<SearchResultDataLine> arrayList2 = new ArrayList<SearchResultDataLine>(this.HIDDEN);
        this.simpleClear();
        if (this.isSorted()) {
            for (n = 0; n < arrayList.size(); ++n) {
                this.addSorted((DataLine)arrayList.get(n));
            }
        } else {
            for (n = 0; n < arrayList.size(); ++n) {
                this.add((SearchResultDataLine)arrayList.get(n));
            }
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SearchResultDataLine searchResultDataLine = (SearchResultDataLine)arrayList2.get(i);
            if (this.isSorted()) {
                this.addSorted(searchResultDataLine);
                continue;
            }
            this.add(searchResultDataLine);
        }
        if (this.isSorted()) {
            for (SearchResultDataLine searchResultDataLine : hashMap.values()) {
                this.addSorted(searchResultDataLine);
            }
        } else {
            for (SearchResultDataLine searchResultDataLine : hashMap.values()) {
                this.add(searchResultDataLine);
            }
        }
    }

    public int getFilteredResults() {
        return super.getTotalResults();
    }

    @Override
    public int getTotalResults() {
        return this.getFilteredResults() + this._numResults;
    }

    public List<SearchResultDataLine> getAllData() {
        ArrayList<SearchResultDataLine> arrayList = new ArrayList<SearchResultDataLine>(this.HIDDEN);
        arrayList.addAll(this._list);
        return arrayList;
    }
}

