/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.websearch.youtube.YouTubeSearchResult;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.AbstractSearchResult;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.util.PopupUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPopupMenu;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.limewire.util.FilenameUtils;

public final class YouTubePackageItemSearchResult
extends AbstractSearchResult {
    private static final String AAC_LOW_QUALITY = "(AAC)";
    static final String AAC_HIGH_QUALITY = "(AAC-High Quality)";
    private final YouTubeSearchResult sr;
    private final FilePackage filePackage;
    private final SearchEngine searchEngine;
    private final String filename;
    private final long size;

    public YouTubePackageItemSearchResult(YouTubeSearchResult youTubeSearchResult, FilePackage filePackage, SearchEngine searchEngine, String string) {
        super(string);
        this.sr = youTubeSearchResult;
        this.filePackage = filePackage;
        this.searchEngine = searchEngine;
        this.filename = this.readFilename(filePackage);
        this.size = filePackage.getChildren().get(0).getLongProperty("size", -1L);
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public String getDisplayName() {
        String string = FilenameUtils.getBaseName(this.filename);
        if (string.indexOf(AAC_HIGH_QUALITY) > 0) {
            return "(AAC-High Quality) " + string.replace(AAC_HIGH_QUALITY, "");
        }
        if (string.indexOf(AAC_LOW_QUALITY) > 0) {
            return "(AAC) " + string.replace(AAC_LOW_QUALITY, "");
        }
        return string;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.sr.getCreationTime();
    }

    @Override
    public String getSource() {
        return this.sr.getSource();
    }

    @Override
    public int getSpeed() {
        return 0x7FFFFFFD;
    }

    @Override
    public boolean isMeasuredSpeed() {
        return false;
    }

    @Override
    public int getQuality() {
        return 0;
    }

    @Override
    public void download(boolean bl) {
        GUIMediator.instance().openYouTubeItem(this.filePackage);
        this.showDetails(false);
    }

    @Override
    public JPopupMenu createMenu(JPopupMenu jPopupMenu, SearchResultDataLine[] searchResultDataLineArray, SearchResultMediator searchResultMediator) {
        PopupUtils.addMenuItem(SearchMediator.DOWNLOAD_STRING, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                YouTubePackageItemSearchResult.this.download(false);
            }
        }, jPopupMenu, searchResultDataLineArray.length > 0, 1);
        PopupUtils.addMenuItem(SearchMediator.YOUTUBE_DETAILS_STRING, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                YouTubePackageItemSearchResult.this.showDetails(true);
            }
        }, jPopupMenu, searchResultDataLineArray.length == 1, 2);
        return jPopupMenu;
    }

    @Override
    public String getHash() {
        return this.sr.getHash();
    }

    @Override
    public String getTorrentURI() {
        return this.sr.getTorrentURI();
    }

    @Override
    public int getSeeds() {
        return this.sr.getSeeds();
    }

    @Override
    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    @Override
    public WebSearchResult getWebSearchResult() {
        return this.sr;
    }

    private String readFilename(FilePackage filePackage) {
        DownloadLink downloadLink = filePackage.getChildren().get(0);
        if (downloadLink.getStringProperty("convertto", "").equals("AUDIOMP3")) {
            return FilenameUtils.getBaseName(downloadLink.getName()) + ".mp3";
        }
        return downloadLink.getName();
    }
}

