/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.websearch.youtube.YouTubeSearchResult;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.AbstractSearchResult;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.util.PopupUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPopupMenu;

public final class YouTubePackageSearchResult
extends AbstractSearchResult {
    private final YouTubeSearchResult sr;
    private final SearchEngine searchEngine;

    public YouTubePackageSearchResult(YouTubeSearchResult youTubeSearchResult, SearchEngine searchEngine, String string) {
        super(string);
        this.sr = youTubeSearchResult;
        this.searchEngine = searchEngine;
    }

    @Override
    public String getFileName() {
        return this.sr.getFileName();
    }

    @Override
    public String getDisplayName() {
        return this.sr.getDisplayName();
    }

    @Override
    public long getSize() {
        return this.sr.getSize();
    }

    @Override
    public long getCreationTime() {
        return this.sr.getCreationTime();
    }

    @Override
    public String getSource() {
        return this.sr.getSource();
    }

    @Override
    public int getSpeed() {
        return 0x7FFFFFFD;
    }

    @Override
    public boolean isMeasuredSpeed() {
        return false;
    }

    @Override
    public int getQuality() {
        return 0;
    }

    @Override
    public void download(boolean bl) {
        GUIMediator.instance().openYouTubeVideoUrl(this.sr.getTorrentURI());
        this.showDetails(false);
    }

    @Override
    public JPopupMenu createMenu(JPopupMenu jPopupMenu, SearchResultDataLine[] searchResultDataLineArray, SearchResultMediator searchResultMediator) {
        PopupUtils.addMenuItem(SearchMediator.DOWNLOAD_STRING, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                YouTubePackageSearchResult.this.download(false);
            }
        }, jPopupMenu, searchResultDataLineArray.length > 0, 1);
        PopupUtils.addMenuItem(SearchMediator.YOUTUBE_DETAILS_STRING, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                YouTubePackageSearchResult.this.showDetails(true);
            }
        }, jPopupMenu, searchResultDataLineArray.length == 1, 2);
        return jPopupMenu;
    }

    @Override
    public String getHash() {
        return this.sr.getHash();
    }

    @Override
    public String getTorrentURI() {
        return this.sr.getTorrentURI();
    }

    @Override
    public int getSeeds() {
        return this.sr.getSeeds();
    }

    @Override
    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    @Override
    public WebSearchResult getWebSearchResult() {
        return this.sr;
    }

    @Override
    public boolean allowDeepSearch() {
        return true;
    }
}

