/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.FileUtils;

public class SmartSearchDB {
    private static final Log LOG = LogFactory.getLog(SmartSearchDB.class);
    public static final int OBJECT_NOT_SAVED_ID = -1;
    public static final int OBJECT_INVALID_ID = -2;
    public static final int SMART_SEARCH_DATABASE_VERSION = 6;
    private final File _databaseFile;
    private final String _name;
    private Connection _connection;
    private final AtomicBoolean closed = new AtomicBoolean(true);

    public SmartSearchDB(File file) {
        this._databaseFile = file;
        File file2 = file;
        this._name = file.getName();
        this._connection = this.openOrCreateDatabase(file2, this._name);
    }

    public File getDatabaseFile() {
        return this._databaseFile;
    }

    public String getName() {
        return this._name;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<List<Object>> query(String string, Object ... objectArray) {
        if (this.isClosed()) {
            return new ArrayList<List<Object>>();
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = this._connection;
        synchronized (connection) {
            statement = this._connection.prepareStatement(string);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    statement.setObject(i + 1, objectArray[i]);
                }
            }
            resultSet = statement.executeQuery();
            List<List<Object>> list = this.convertResultSetToList(resultSet);
            return list;
        }
        {
            catch (Throwable throwable) {
                LOG.error("Error performing SQL statement", throwable);
                return new ArrayList<List<Object>>();
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(String string, Object ... objectArray) {
        if (this.isClosed()) {
            return -2;
        }
        if (!string.toUpperCase().startsWith("INSERT")) {
            return -2;
        }
        Connection connection = this._connection;
        synchronized (connection) {
            if (this.update(this._connection, string, objectArray) > 0) {
                return SmartSearchDB.getIdentity(this._connection);
            }
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String string, Object ... objectArray) {
        if (this.isClosed()) {
            return -2;
        }
        Connection connection = this._connection;
        synchronized (connection) {
            if (this.update(this._connection, string, objectArray) > 0) {
                return SmartSearchDB.getIdentity(this._connection);
            }
        }
        return -2;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                Statement statement = this._connection.createStatement();
                statement.execute("SHUTDOWN");
                this._connection.close();
            }
            catch (Throwable throwable) {
                LOG.error("Error closing the smart search database", throwable);
            }
        }
    }

    public synchronized Connection reset() {
        try {
            this.close();
            FileUtils.deleteRecursive(this._databaseFile);
            this._connection = this.createDatabase(this._databaseFile, this._name);
            return this._connection;
        }
        catch (Throwable throwable) {
            LOG.error("Error reseting smart search database", throwable);
            return null;
        }
    }

    protected Connection onUpdateDatabase() {
        return this.reset();
    }

    private Connection openConnection(File file, String string, boolean bl) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("jdbc:h2:");
            stringBuilder.append(new File(file, string).getAbsolutePath());
            if (!bl) {
                stringBuilder.append(";ifexists=true");
            }
            this.closed.set(false);
            return DriverManager.getConnection(stringBuilder.toString(), "SA", "");
        }
        catch (Throwable throwable) {
            if (bl) {
                LOG.error("Error opening the database", throwable);
            }
            this.closed.set(true);
            return null;
        }
    }

    private Connection createDatabase(File file, String string) {
        Connection connection = this.openConnection(file, string, true);
        this.update(connection, "SET IGNORECASE TRUE", new Object[0]);
        this.update(connection, "CREATE TABLE TORRENTS (torrentId INTEGER IDENTITY, infoHash VARCHAR(60), timestamp BIGINT, torrentName VARCHAR(10000), seeds INTEGER, indexed BOOLEAN, json VARCHAR(131072))", new Object[0]);
        this.update(connection, "CREATE INDEX idxTorrents ON TORRENTS (infoHash)", new Object[0]);
        this.update(connection, "CREATE INDEX idxSeeds ON TORRENTS(seeds)", new Object[0]);
        this.update(connection, "CREATE ALIAS IF NOT EXISTS FTL_INIT FOR \"org.h2.fulltext.FullTextLucene2.init\"", new Object[0]);
        this.update(connection, "CALL FTL_INIT()", new Object[0]);
        this.update(connection, "CREATE TABLE FILES (fileId INTEGER IDENTITY, torrentId INTEGER, fileName VARCHAR(10000), json VARCHAR(131072), keywords VARCHAR(131072))", new Object[0]);
        this.update(connection, "CALL FTL_CREATE_INDEX('PUBLIC', 'FILES', 'FILENAME, KEYWORDS')", new Object[0]);
        this.update(connection, "CREATE INDEX idxTorrentId ON FILES (torrentId)", new Object[0]);
        this.update(connection, "CREATE TABLE Snapshots (snapshotId INTEGER IDENTITY, timestamp BIGINT)", new Object[0]);
        this.update(connection, "CREATE TABLE SmartSearchMetaData (smartSearchId INTEGER IDENTITY, name VARCHAR(500), version INTEGER)", new Object[0]);
        this.update(connection, "INSERT INTO SmartSearchMetaData (name , version) VALUES (?, ?)", string, 6);
        return connection;
    }

    private Connection openOrCreateDatabase(File file, String string) {
        Connection connection = this.openConnection(file, string, false);
        if (connection == null) {
            return this.createDatabase(file, string);
        }
        this._connection = connection;
        int n = this.getDatabaseVersion();
        if (n < 6) {
            return this.onUpdateDatabase();
        }
        return connection;
    }

    private List<List<Object>> convertResultSetToList(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        LinkedList<List<Object>> linkedList = new LinkedList<List<Object>>();
        while (resultSet.next()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            for (int i = 1; i <= n; ++i) {
                arrayList.add(resultSet.getObject(i));
            }
            linkedList.add(arrayList);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getIdentity(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("CALL IDENTITY()");
            resultSet.next();
            int n = resultSet.getInt(1);
            return n;
        }
        catch (Throwable throwable) {
            LOG.error("Error performing SQL statement", throwable);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int update(Connection connection, String string, Object ... objectArray) {
        PreparedStatement preparedStatement = null;
        try {
            int n;
            preparedStatement = connection.prepareStatement(string);
            if (objectArray != null) {
                for (n = 0; n < objectArray.length; ++n) {
                    preparedStatement.setObject(n + 1, objectArray[n]);
                }
            }
            n = preparedStatement.executeUpdate();
            return n;
        }
        catch (Throwable throwable) {
            LOG.error("Error performing SQL statement: ", throwable);
            LOG.error("SQL: " + string);
            LOG.error("Arguments: " + Arrays.asList(objectArray));
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return -1;
    }

    private int getDatabaseVersion() {
        List<List<Object>> list = this.query("SELECT version FROM SmartSearchMetaData", new Object[0]);
        return (Integer)list.get(0).get(0);
    }

    static {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }
}

