/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.tables.ActionIconAndNameHolder;
import com.limegroup.gnutella.gui.tables.ActionIconAndNameRenderer;
import com.limegroup.gnutella.gui.tables.CenteredHolder;
import com.limegroup.gnutella.gui.tables.CenteredRenderer;
import com.limegroup.gnutella.gui.tables.ChatHolder;
import com.limegroup.gnutella.gui.tables.ChatRenderer;
import com.limegroup.gnutella.gui.tables.ColorRenderer;
import com.limegroup.gnutella.gui.tables.ColoredCell;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.ColumnSelectionMenu;
import com.limegroup.gnutella.gui.tables.ComponentMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.DateRenderer;
import com.limegroup.gnutella.gui.tables.DefaultColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.FlexibleColumnResizeAdapter;
import com.limegroup.gnutella.gui.tables.HeaderMouseListener;
import com.limegroup.gnutella.gui.tables.HeaderMouseObserver;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.IconAndNameRenderer;
import com.limegroup.gnutella.gui.tables.IconRenderer;
import com.limegroup.gnutella.gui.tables.KeyTypedMover;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.ProgressBarHolder;
import com.limegroup.gnutella.gui.tables.ProgressBarRenderer;
import com.limegroup.gnutella.gui.tables.RemoveListener;
import com.limegroup.gnutella.gui.tables.SelectionListener;
import com.limegroup.gnutella.gui.tables.SpeedRenderer;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.limewire.util.StringUtils;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;

public abstract class AbstractTableMediator<T extends DataLineModel<E, I>, E extends DataLine<I>, I>
implements ComponentMediator<I>,
HeaderMouseObserver,
ThemeObserver {
    protected final String ID;
    protected PaddedPanel MAIN_PANEL;
    protected T DATA_MODEL;
    protected LimeJTable TABLE;
    protected ButtonRow BUTTON_ROW;
    public ActionListener REMOVE_LISTENER;
    public MouseListener DEFAULT_LISTENER;
    public MouseInputListener HEADER_LISTENER;
    public ListSelectionListener SELECTION_LISTENER;
    public KeyListener AUTO_NAVIGATION_KEY_LISTENER;
    public TableSettings SETTINGS;
    private static TableCellRenderer SPEED_RENDERER;
    private static TableCellRenderer PROGRESS_BAR_RENDERER;
    private static TableCellRenderer CHAT_RENDERER;
    private static TableCellRenderer COLOR_RENDERER;
    private static TableCellRenderer ICON_RENDERER;
    private static TableCellRenderer ICON_AND_NAME_RENDERER;
    private static TableCellRenderer ACTION_ICON_AND_NAME_RENDERER;
    private static TableCellRenderer DEFAULT_RENDERER;
    private static TableCellRenderer CENTER_RENDERER;
    private static TableCellRenderer DATE_RENDERER;
    protected static final Dimension ZERO_DIMENSION;
    protected Resorter RESORTER = new Resorter();
    protected JComponent TABLE_PANE;
    protected JScrollPane SCROLL_PANE;
    protected boolean isResorting = false;

    protected AbstractTableMediator(String string) {
        this.ID = string;
        this.updateSplashScreen();
        this.buildSettings();
        this.buildListeners();
        this.setupConstants();
        assert (this.DATA_MODEL != null) : "DATA_MODEL not set.";
        assert (this.TABLE != null) : "TABLE not set.";
        this.setupTable();
        this.setupDragAndDrop();
        this.addActions();
        this.addListeners();
        this.setDefaultRenderers();
        this.setDefaultEditors();
        this.setupMainPanel();
        this.setupTableHeaders();
        this.handleNoSelection();
    }

    protected void setupDragAndDrop() {
    }

    protected abstract void updateSplashScreen();

    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID);
    }

    protected abstract void setupConstants();

    protected void buildListeners() {
        this.DEFAULT_LISTENER = new DefaultMouseListener(this);
        this.SELECTION_LISTENER = new SelectionListener(this);
        this.HEADER_LISTENER = new HeaderMouseListener(this);
        this.REMOVE_LISTENER = new RemoveListener(this);
        this.AUTO_NAVIGATION_KEY_LISTENER = new KeyTypedMover();
    }

    protected void addListeners() {
        this.TABLE.addMouseListener(this.DEFAULT_LISTENER);
        this.TABLE.getSelectionModel().addListSelectionListener(this.SELECTION_LISTENER);
        this.TABLE.getTableHeader().addMouseListener(this.HEADER_LISTENER);
        this.TABLE.getTableHeader().addMouseMotionListener(this.HEADER_LISTENER);
        this.TABLE.addKeyListener(this.AUTO_NAVIGATION_KEY_LISTENER);
    }

    protected void setupTable() {
        this.TABLE.setRowHeight(this.TABLE.getRowHeight() + 1);
        this.TABLE.setShowGrid(false);
        this.TABLE.setIntercellSpacing(ZERO_DIMENSION);
        this.TABLE.setColumnSelectionAllowed(false);
        this.TABLE.setTableSettings(this.SETTINGS);
        this.TABLE.getTableHeader().addMouseListener(new FlexibleColumnResizeAdapter());
    }

    protected void addActions() {
        InputMap inputMap = this.TABLE.getInputMap(1);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 5177362850526818763L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTableMediator.this.handleActionKey();
            }
        };
        this.installAction(inputMap, abstractAction, 10, "limewire.action");
        AbstractAction abstractAction2 = new AbstractAction(){
            private static final long serialVersionUID = 6973509148820061808L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AbstractTableMediator.this.TABLE.isEditing()) {
                    AbstractTableMediator.this.removeSelection();
                }
            }
        };
        this.installAction(inputMap, abstractAction2, 8, "limewire.delete");
        this.installAction(inputMap, abstractAction2, 127, "limewire.delete");
    }

    private void installAction(InputMap inputMap, Action action, int n, String string) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, 0);
        Object object = inputMap.get(keyStroke);
        if (object != null) {
            this.TABLE.getActionMap().put(object, action);
        } else {
            inputMap.put(keyStroke, string);
            this.TABLE.getActionMap().put(string, action);
        }
    }

    protected void setDefaultRenderers() {
        this.TABLE.setDefaultRenderer(ProgressBarHolder.class, this.getProgressBarRenderer());
        this.TABLE.setDefaultRenderer(ChatHolder.class, this.getChatRenderer());
        this.TABLE.setDefaultRenderer(ColoredCell.class, this.getColorRenderer());
        this.TABLE.setDefaultRenderer(Icon.class, this.getIconRenderer());
        this.TABLE.setDefaultRenderer(IconAndNameHolder.class, this.getIconAndNameRenderer());
        this.TABLE.setDefaultRenderer(ActionIconAndNameHolder.class, this.getActionIconAndNameRenderer());
        this.TABLE.setDefaultRenderer(Object.class, this.getDefaultRenderer());
        this.TABLE.setDefaultRenderer(CenteredHolder.class, this.getCenterRenderer());
        this.TABLE.setDefaultRenderer(SpeedRenderer.class, this.getSpeedRenderer());
        this.TABLE.setDefaultRenderer(Date.class, this.getDateRenderer());
    }

    protected void setDefaultEditors() {
    }

    protected void setupMainPanel() {
        if (this.MAIN_PANEL != null) {
            this.MAIN_PANEL.add(this.getScrolledTablePane());
            if (this.BUTTON_ROW != null) {
                this.MAIN_PANEL.add(Box.createVerticalStrut(6));
                this.MAIN_PANEL.add(this.BUTTON_ROW);
            }
            this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
        }
    }

    protected void setupTableHeaders() {
        ColumnPreferenceHandler columnPreferenceHandler = this.createDefaultColumnPreferencesHandler();
        columnPreferenceHandler.setWidths();
        columnPreferenceHandler.setOrder();
        columnPreferenceHandler.setVisibility();
        this.TABLE.setColumnPreferenceHandler(columnPreferenceHandler);
    }

    protected ColumnPreferenceHandler createDefaultColumnPreferencesHandler() {
        return new DefaultColumnPreferenceHandler(this.TABLE);
    }

    protected JComponent getScrolledTablePane() {
        if (this.TABLE_PANE != null) {
            return this.TABLE_PANE;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.SCROLL_PANE = new JScrollPane(this.TABLE);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(this.TABLE.getTableHeader().getBackground());
        jPanel2.setBorder(BorderFactory.createBevelBorder(0));
        this.SCROLL_PANE.setCorner("UPPER_RIGHT_CORNER", jPanel2);
        jPanel.add(this.SCROLL_PANE);
        this.TABLE_PANE = jPanel;
        return jPanel;
    }

    @Override
    public void updateTheme() {
    }

    @Override
    public void add(I i) {
        this.add(i, -1);
    }

    public void add(I i, int n) {
        if (this.TABLE.isEditing()) {
            TableCellEditor tableCellEditor = this.TABLE.getCellEditor();
            tableCellEditor.cancelCellEditing();
        }
        boolean bl = this.TABLE.isSelectionVisible();
        int n2 = this.SETTINGS.REAL_TIME_SORT.getValue() && this.DATA_MODEL.isSorted() ? this.DATA_MODEL.addSorted(i) : (n >= 0 && n <= this.DATA_MODEL.getRowCount() ? this.DATA_MODEL.add(i, n) : this.DATA_MODEL.add(i));
        this.fixSelection(n2, bl);
    }

    public void addUnsorted(I i) {
        if (this.TABLE.isEditing()) {
            TableCellEditor tableCellEditor = this.TABLE.getCellEditor();
            tableCellEditor.cancelCellEditing();
        }
        boolean bl = this.TABLE.isSelectionVisible();
        int n = this.DATA_MODEL.add(i);
        this.fixSelection(n, bl);
    }

    protected void fixSelection(int n, boolean bl) {
        if (n >= 0 && n < this.DATA_MODEL.getRowCount()) {
            this.TABLE.removeRowSelectionInterval(n, n);
            int n2 = this.TABLE.getSelectedRow();
            if (n2 >= 0 && n2 < this.DATA_MODEL.getRowCount()) {
                this.TABLE.addRowSelectionInterval(n2, n2);
                if (bl) {
                    this.TABLE.ensureRowVisible(n2);
                }
            }
        }
    }

    @Override
    public void remove(I i) {
        int n = this.DATA_MODEL.getRow(i);
        if (n != -1) {
            this.removeRow(n);
        }
    }

    public void removeRow(int n) {
        this.DATA_MODEL.remove(n);
    }

    public void moveRow(int n, int n2) {
        if (n < 0 || n >= this.DATA_MODEL.getRowCount()) {
            throw new IllegalArgumentException("index " + n + " must be >= 0 and < TABLE.getRowCount()");
        }
        if (n2 < 0 || n2 >= this.DATA_MODEL.getRowCount()) {
            throw new IllegalArgumentException("add index " + n2 + " must be >= 0 and < TABLE.getRowCount()");
        }
        Object t = this.DATA_MODEL.get((int)n);
        this.DATA_MODEL.remove(n);
        this.DATA_MODEL.add(t, n2);
    }

    @Override
    public void refresh() {
        if (this.TABLE.isShowing()) {
            this.doRefresh();
            this.resort();
        }
    }

    protected void doRefresh() {
        this.DATA_MODEL.refresh();
    }

    @Override
    public void update(I i) {
        this.DATA_MODEL.update(i);
        this.resort();
    }

    public void resort() {
        this.RESORTER.doResort(false);
    }

    public void forceResort() {
        this.RESORTER.doResort(true);
    }

    @Override
    public JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    @Override
    public void removeSelection() {
        Object object;
        if (this.TABLE.isEditing()) {
            object = this.TABLE.getCellEditor();
            object.cancelCellEditing();
        }
        object = this.TABLE.getSelectedRows();
        Arrays.sort((int[])object);
        for (int i = ((Object)object).length - 1; i >= 0; --i) {
            Object object2 = object[i];
            this.DATA_MODEL.remove((int)object2);
        }
        this.clearSelection();
    }

    protected JPopupMenu createColumnSelectionMenu() {
        return new ColumnSelectionMenu(this.TABLE).getComponent();
    }

    @Override
    public void handleMouseClick(MouseEvent mouseEvent) {
    }

    @Override
    public void handleMouseDoubleClick(MouseEvent mouseEvent) {
        this.handleActionKey();
    }

    @Override
    public void handleRightMouseClick(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.TABLE.rowAtPoint(point);
        if (n < 0) {
            return;
        }
        if (!this.TABLE.getSelectionModel().isSelectedIndex(n)) {
            this.TABLE.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    @Override
    public void handlePopupMenu(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.handleRightMouseClick(mouseEvent);
        JPopupMenu jPopupMenu = this.createPopupMenu();
        if (jPopupMenu != null) {
            try {
                jPopupMenu.show(this.TABLE, point.x + 1, point.y - 6);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handleHeaderColumnLeftClick(Point point) {
        JTableHeader jTableHeader = this.TABLE.getTableHeader();
        int n = jTableHeader.columnAtPoint(point);
        int n2 = this.TABLE.convertColumnIndexToModel(n);
        int n3 = this.DATA_MODEL.getSortColumn();
        if (n2 != -1) {
            this.sortAndMaintainSelection(n2);
            jTableHeader.repaint(jTableHeader.getHeaderRect(n));
            if (n3 != -1 && n3 != n2) {
                int n4 = this.TABLE.convertColumnIndexToView(n3);
                jTableHeader.repaint(jTableHeader.getHeaderRect(n4));
            }
        }
    }

    @Override
    public void handleHeaderPopupMenu(Point point) {
        this.createColumnSelectionMenu().show(this.TABLE.getTableHeader(), point.x + 1, point.y - 6);
    }

    @Override
    public void handleHeaderColumnPressed(Point point) {
        JTableHeader jTableHeader = this.TABLE.getTableHeader();
        int n = jTableHeader.columnAtPoint(point);
        int n2 = this.TABLE.convertColumnIndexToModel(n);
        if (n2 != -1) {
            this.TABLE.setPressedColumnIndex(n2);
            jTableHeader.repaint(jTableHeader.getHeaderRect(n));
        }
    }

    @Override
    public void handleHeaderColumnReleased(Point point) {
        this.TABLE.setPressedColumnIndex(-1);
        JTableHeader jTableHeader = this.TABLE.getTableHeader();
        int n = jTableHeader.columnAtPoint(point);
        if (n != -1) {
            jTableHeader.repaint(jTableHeader.getHeaderRect(n));
        }
    }

    @Override
    public void setButtonEnabled(int n, boolean bl) {
        if (this.BUTTON_ROW != null) {
            this.BUTTON_ROW.setButtonEnabled(n, bl);
        }
    }

    public int getSize() {
        return this.DATA_MODEL.getRowCount();
    }

    public void clearTable() {
        this.DATA_MODEL.clear();
        this.handleNoSelection();
    }

    protected void clearSelection() {
        this.TABLE.clearSelection();
        this.handleNoSelection();
    }

    protected void sortAndMaintainSelection(int n) {
        int n2;
        int[] nArray = this.TABLE.getSelectedRows();
        DataLine[] dataLineArray = new DataLine[nArray.length];
        DataLine dataLine = null;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            dataLineArray[n2] = this.DATA_MODEL.get((int)nArray[n2]);
            if (dataLine != null || !this.TABLE.isRowVisible(nArray[n2])) continue;
            dataLine = dataLineArray[n2];
        }
        if (n == -1) {
            this.DATA_MODEL.resort();
        } else {
            this.DATA_MODEL.sort(n);
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n3 = this.DATA_MODEL.getRow((DataLine)dataLineArray[n2]);
            this.TABLE.addRowSelectionInterval(n3, n3);
            if (dataLine != dataLineArray[n2]) continue;
            this.TABLE.ensureRowVisible(n3);
            dataLine = null;
        }
    }

    protected abstract JPopupMenu createPopupMenu();

    public static int compare(Object object, Object object2) {
        int n = object == null && object2 == null ? 0 : (object == null ? -1 : (object2 == null ? 1 : (object.getClass() == String.class ? StringUtils.compareFullPrimary((String)object, (String)object2) : (object instanceof Comparable ? ((Comparable)object).compareTo(object2) : 0))));
        return n;
    }

    boolean isResorting() {
        return this.isResorting;
    }

    protected TableCellRenderer getProgressBarRenderer() {
        if (PROGRESS_BAR_RENDERER == null) {
            PROGRESS_BAR_RENDERER = new ProgressBarRenderer();
        }
        return PROGRESS_BAR_RENDERER;
    }

    protected TableCellRenderer getChatRenderer() {
        if (CHAT_RENDERER == null) {
            CHAT_RENDERER = new ChatRenderer();
        }
        return CHAT_RENDERER;
    }

    protected TableCellRenderer getSpeedRenderer() {
        if (SPEED_RENDERER == null) {
            SPEED_RENDERER = new SpeedRenderer();
        }
        return SPEED_RENDERER;
    }

    protected TableCellRenderer getColorRenderer() {
        if (COLOR_RENDERER == null) {
            COLOR_RENDERER = new ColorRenderer();
        }
        return COLOR_RENDERER;
    }

    protected TableCellRenderer getIconRenderer() {
        if (ICON_RENDERER == null) {
            ICON_RENDERER = new IconRenderer();
        }
        return ICON_RENDERER;
    }

    protected TableCellRenderer getIconAndNameRenderer() {
        if (ICON_AND_NAME_RENDERER == null) {
            ICON_AND_NAME_RENDERER = new IconAndNameRenderer();
        }
        return ICON_AND_NAME_RENDERER;
    }

    protected TableCellRenderer getActionIconAndNameRenderer() {
        if (ACTION_ICON_AND_NAME_RENDERER == null) {
            ACTION_ICON_AND_NAME_RENDERER = new ActionIconAndNameRenderer();
        }
        return ACTION_ICON_AND_NAME_RENDERER;
    }

    protected TableCellRenderer getDefaultRenderer() {
        if (DEFAULT_RENDERER == null) {
            DEFAULT_RENDERER = new SubstanceDefaultTableCellRenderer();
        }
        return DEFAULT_RENDERER;
    }

    protected TableCellRenderer getCenterRenderer() {
        if (CENTER_RENDERER == null) {
            CENTER_RENDERER = new CenteredRenderer();
        }
        return CENTER_RENDERER;
    }

    protected TableCellRenderer getDateRenderer() {
        if (DATE_RENDERER == null) {
            DATE_RENDERER = new DateRenderer();
        }
        return DATE_RENDERER;
    }

    static {
        ZERO_DIMENSION = new Dimension(0, 0);
    }

    protected final class Resorter
    implements Runnable {
        private boolean active = false;
        private boolean force = false;

        protected Resorter() {
        }

        public void doResort(boolean bl) {
            if (!this.active && AbstractTableMediator.this.SETTINGS.REAL_TIME_SORT.getValue() && AbstractTableMediator.this.TABLE.isShowing()) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
            this.force |= bl;
        }

        @Override
        public void run() {
            try {
                if (!AbstractTableMediator.this.TABLE.isEditing() && (this.force || AbstractTableMediator.this.DATA_MODEL.needsResort())) {
                    AbstractTableMediator.this.isResorting = true;
                    AbstractTableMediator.this.sortAndMaintainSelection(-1);
                    AbstractTableMediator.this.isResorting = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.active = false;
            this.force = false;
        }
    }
}

