/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.ColoredCell;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;

class ColorRenderer
extends SubstanceDefaultTableCellRenderer
implements ThemeObserver {
    private static final long serialVersionUID = 653501867944836138L;
    private static final Map<TableCellRenderer, TableCellRenderer> otherRenderers = new HashMap<TableCellRenderer, TableCellRenderer>();

    public ColorRenderer() {
        ThemeMediator.addThemeObserver(this);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Class clazz;
        Object object2;
        Color color;
        ColoredCell coloredCell = (ColoredCell)object;
        if (coloredCell != null) {
            color = coloredCell.getColor();
            object2 = coloredCell.getValue();
            clazz = coloredCell.getCellClass();
        } else {
            color = null;
            object2 = "";
            clazz = String.class;
        }
        TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(clazz);
        tableCellRenderer = this.getCachedOrNewRenderer(tableCellRenderer);
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
        if (!bl && !bl2) {
            component.setForeground(color);
        }
        return component;
    }

    @Override
    public void updateTheme() {
        for (TableCellRenderer tableCellRenderer : otherRenderers.values()) {
            if (!(tableCellRenderer instanceof ThemeObserver)) continue;
            ((ThemeObserver)((Object)tableCellRenderer)).updateTheme();
        }
    }

    @Override
    public void updateUI() {
        for (TableCellRenderer tableCellRenderer : otherRenderers.values()) {
            if (!(tableCellRenderer instanceof JComponent)) continue;
            ((JComponent)((Object)tableCellRenderer)).updateUI();
        }
    }

    private TableCellRenderer getCachedOrNewRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = otherRenderers.get(tableCellRenderer);
        if (tableCellRenderer2 == null) {
            Class<?> clazz = tableCellRenderer.getClass();
            try {
                tableCellRenderer2 = (TableCellRenderer)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (ClassCastException classCastException) {
                throw new RuntimeException(classCastException);
            }
            otherRenderers.put(tableCellRenderer, tableCellRenderer2);
        }
        return tableCellRenderer2;
    }
}

