/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.SkinCheckBoxMenuItem;
import com.limegroup.gnutella.gui.themes.SkinMenu;
import com.limegroup.gnutella.gui.themes.SkinMenuItem;
import com.limegroup.gnutella.gui.themes.SkinPopupMenu;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.limewire.setting.BooleanSetting;

public class ColumnSelectionMenu {
    protected static final String COLUMN_ID = "columnId";
    protected static final String SETTING = "setting";
    protected static final ActionListener SETTING_LISTENER = new SettingListener();
    private static final String REVERT_DEFAULT = I18n.tr("Revert To Default");
    public static final String MORE_OPTIONS = I18n.tr("More Options");
    public static final String ROWSTRIPE = I18n.tr("Stripe Rows");
    public static final String SORTING = I18n.tr("Sort Automatically");
    public static final String TOOLTIPS = I18n.tr("Extended Tooltips");
    protected final JPopupMenu _menu = new SkinPopupMenu();
    private final LimeJTable _table;

    public ColumnSelectionMenu(LimeJTable limeJTable) {
        this._table = limeJTable;
        DataLineModel dataLineModel = (DataLineModel)this._table.getModel();
        ReverterListener reverterListener = new ReverterListener();
        SkinMenuItem skinMenuItem = new SkinMenuItem(REVERT_DEFAULT);
        ColumnPreferenceHandler columnPreferenceHandler = this._table.getColumnPreferenceHandler();
        TableSettings tableSettings = this._table.getTableSettings();
        if ((columnPreferenceHandler == null || columnPreferenceHandler.isDefault()) && (tableSettings == null || tableSettings.isDefault())) {
            skinMenuItem.setEnabled(false);
        } else {
            skinMenuItem.addActionListener(reverterListener);
        }
        this._menu.add(skinMenuItem);
        if (tableSettings != null) {
            JMenu jMenu = ColumnSelectionMenu.createMoreOptions(tableSettings);
            this._menu.add(jMenu);
        }
        this._menu.addSeparator();
        this.addTableColumnChoices(new SelectionActionListener(), dataLineModel, limeJTable);
    }

    protected void addTableColumnChoices(ActionListener actionListener2, DataLineModel<?, ?> dataLineModel, LimeJTable limeJTable) {
        for (int i = 0; i < dataLineModel.getColumnCount(); ++i) {
            JMenuItem jMenuItem = this.createColumnMenuItem(actionListener2, dataLineModel, limeJTable, i);
            this._menu.add(jMenuItem);
        }
    }

    protected JMenuItem createColumnMenuItem(ActionListener actionListener2, DataLineModel<?, ?> dataLineModel, LimeJTable limeJTable, int n) {
        Object object = dataLineModel.getColumnId(n);
        String string = dataLineModel.getColumnName(n);
        SkinCheckBoxMenuItem skinCheckBoxMenuItem = new SkinCheckBoxMenuItem(string, limeJTable.isColumnVisible(object));
        skinCheckBoxMenuItem.putClientProperty(COLUMN_ID, object);
        skinCheckBoxMenuItem.addActionListener(actionListener2);
        return skinCheckBoxMenuItem;
    }

    public static JMenu createMoreOptions(TableSettings tableSettings) {
        SkinMenu skinMenu = new SkinMenu(MORE_OPTIONS);
        ColumnSelectionMenu.addSetting(skinMenu, SORTING, tableSettings.REAL_TIME_SORT);
        ColumnSelectionMenu.addSetting(skinMenu, TOOLTIPS, tableSettings.DISPLAY_TOOLTIPS);
        return skinMenu;
    }

    public static JMenuItem addSetting(JMenu jMenu, String string, BooleanSetting booleanSetting) {
        SkinCheckBoxMenuItem skinCheckBoxMenuItem = new SkinCheckBoxMenuItem(string, booleanSetting.getValue());
        skinCheckBoxMenuItem.putClientProperty(SETTING, booleanSetting);
        skinCheckBoxMenuItem.addActionListener(SETTING_LISTENER);
        jMenu.add(skinCheckBoxMenuItem);
        return skinCheckBoxMenuItem;
    }

    public JPopupMenu getComponent() {
        return this._menu;
    }

    protected static class SettingListener
    implements ActionListener {
        protected SettingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            BooleanSetting booleanSetting = (BooleanSetting)jCheckBoxMenuItem.getClientProperty(ColumnSelectionMenu.SETTING);
            booleanSetting.setValue(jCheckBoxMenuItem.getState());
        }
    }

    protected class ReverterListener
    implements ActionListener {
        protected ReverterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnSelectionMenu.this._table.getColumnPreferenceHandler().revertToDefault();
            ColumnSelectionMenu.this._table.getTableSettings().revertToDefault();
        }
    }

    protected class SelectionActionListener
    implements ActionListener {
        protected SelectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            try {
                ColumnSelectionMenu.this._table.setColumnVisible(jCheckBoxMenuItem.getClientProperty(ColumnSelectionMenu.COLUMN_ID), jCheckBoxMenuItem.getState());
                ColumnSelectionMenu.this._table.getTableHeader().setDraggedColumn(null);
            }
            catch (LastColumnException lastColumnException) {
                GUIMediator.showError(I18n.tr("You cannot turn off all columns."), QuestionsHandler.REMOVE_LAST_COLUMN);
            }
        }
    }
}

