/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.MouseObserver;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;

public final class DefaultMouseListener
implements MouseListener {
    private MouseObserver cm;

    public DefaultMouseListener(MouseObserver mouseObserver) {
        this.cm = mouseObserver;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.tryPopup(mouseEvent)) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.cm.handleRightMouseClick(mouseEvent);
        } else if (mouseEvent.getClickCount() >= 2) {
            this.cm.handleMouseDoubleClick(mouseEvent);
        } else {
            this.cm.handleMouseClick(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.tryPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.tryPopup(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public boolean tryPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.cm.handlePopupMenu(mouseEvent);
            return true;
        }
        return false;
    }
}

