/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import com.limegroup.gnutella.gui.tables.DataLine;
import java.util.HashMap;

public class HashBasedDataLineModel<T extends DataLine<E>, E>
extends BasicDataLineModel<T, E> {
    private static final long serialVersionUID = -4697217283217173076L;
    protected HashMap<E, Integer> _indexes = new HashMap();

    public HashBasedDataLineModel(Class<? extends T> clazz) {
        super(clazz);
    }

    protected int forceAdd(T t, int n) {
        this._indexes.put(t.getInitializeObject(), new Integer(n));
        int n2 = super.add(t, n);
        this.remapIndexes(n2 + 1);
        return n2;
    }

    @Override
    public int add(T t, int n) {
        Object e = t.getInitializeObject();
        if (this._indexes.containsKey(e)) {
            return -1;
        }
        this._indexes.put(e, new Integer(n));
        int n2 = super.add(t, n);
        this.remapIndexes(n2 + 1);
        return n2;
    }

    @Override
    public void remove(int n) {
        Object e = this.get(n).getInitializeObject();
        this._indexes.remove(e);
        super.remove(n);
        this.remapIndexes(n);
    }

    @Override
    public int getRow(E e) {
        Integer n = this._indexes.get(e);
        if (n == null) {
            return -1;
        }
        return n;
    }

    @Override
    public void doResort() {
        super.doResort();
        this._indexes.clear();
        this.remapIndexes(0);
    }

    @Override
    public boolean contains(Object object) {
        return this._indexes.containsKey(object);
    }

    @Override
    public void clear() {
        this._indexes.clear();
        super.clear();
    }

    public void remapIndexes(int n) {
        int n2 = this.getRowCount();
        for (int i = n; i < n2; ++i) {
            this._indexes.put(this.get(i).getInitializeObject(), new Integer(i));
        }
    }

    public void initializeObjectChanged(E e, E e2) {
        Integer n = this._indexes.remove(e);
        this._indexes.put(e2, n);
    }
}

