/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.LimeJProgressBar;
import com.limegroup.gnutella.gui.themes.SkinTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.ui.SubstanceTableUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceStripingUtils;
import org.pushingpixels.substance.internal.utils.UpdateOptimizationInfo;
import org.pushingpixels.substance.internal.utils.border.SubstanceTableCellBorder;

public class ProgressBarRenderer
extends LimeJProgressBar
implements TableCellRenderer,
SkinTableCellRenderer {
    private static final long serialVersionUID = 4078901049982402262L;
    private Border _selectedBorder;
    private Border _unselectedBorder;
    private Map<Color, Border> borders = new HashMap<Color, Border>();

    public ProgressBarRenderer() {
        this.setStringPainted(true);
        Font font = this.getFont();
        Font font2 = font == null || font.getName() == null ? new Font("Dialog", 1, 9) : new Font(font.getName(), 1, 9);
        this.setFont(font2);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this._unselectedBorder = this.getCachedOrNewBorder(color);
        if (this._unselectedBorder != null) {
            this.setBorder(this._unselectedBorder);
        }
    }

    public Border getCachedOrNewBorder(Color color) {
        if (color == null) {
            return null;
        }
        if (this.borders == null) {
            return null;
        }
        Border border = this.borders.get(color);
        if (border == null) {
            border = BorderFactory.createMatteBorder(2, 5, 2, 5, color);
            this.borders.put(color, border);
        }
        return border;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return this.getTableCellRendererComponentWithSubstance(jTable, object, bl, bl2, n, n2);
        }
        this.setValue(Math.min(100, this.getBarStatus(object)));
        this.setString(this.getDescription(object));
        Color color = this.getBackgroundForRow(jTable, n);
        if (this._selectedBorder == null && this._unselectedBorder == null) {
            Color color2 = jTable.getSelectionBackground();
            this._selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, color2);
            this._unselectedBorder = this.getCachedOrNewBorder(color);
        }
        this._unselectedBorder = this.getCachedOrNewBorder(color);
        if (bl) {
            this.setBorder(this._selectedBorder);
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBorder(this._unselectedBorder);
        }
        return this;
    }

    protected String getDescription(Object object) {
        return Integer.toString(this.getBarStatus(object)) + " %";
    }

    protected int getBarStatus(Object object) {
        return object == null ? 0 : (Integer)object;
    }

    @Override
    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        JComponent jComponent = (JComponent)container;
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && jComponent.isOpaque();
        return !bl && super.isOpaque();
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public Component getTableCellRendererComponentWithSubstance(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        Object object3;
        boolean bl3;
        TableUI tableUI = jTable.getUI();
        SubstanceTableUI substanceTableUI = (SubstanceTableUI)tableUI;
        bl2 = substanceTableUI.isFocusedCell(n, n2);
        SubstanceTableUI.TableCellId tableCellId = new SubstanceTableUI.TableCellId(n, n2);
        StateTransitionTracker.ModelStateInfo modelStateInfo = substanceTableUI.getModelStateInfo(tableCellId);
        ComponentState componentState = substanceTableUI.getCellState(tableCellId);
        JTable.DropLocation dropLocation = jTable.getDropLocation();
        boolean bl4 = bl3 = dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == n && dropLocation.getColumn() == n2;
        if (!bl3 && modelStateInfo != null) {
            if (substanceTableUI.hasRolloverAnimations() || substanceTableUI.hasSelectionAnimations()) {
                object3 = modelStateInfo.getStateContributionMap();
                object2 = this.getColorSchemeForState(jTable, substanceTableUI, componentState);
                if (componentState.isDisabled() || object3 == null || object3.size() == 1) {
                    super.setForeground(new ColorUIResource(object2.getForegroundColor()));
                } else {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : modelStateInfo.getStateContributionMap().entrySet()) {
                        ComponentState componentState2 = entry.getKey();
                        SubstanceColorScheme substanceColorScheme = this.getColorSchemeForState(jTable, substanceTableUI, componentState2);
                        Color color = substanceColorScheme.getForegroundColor();
                        float f4 = entry.getValue().getContribution();
                        f += (float)color.getRed() * f4;
                        f2 += (float)color.getGreen() * f4;
                        f3 += (float)color.getBlue() * f4;
                    }
                    super.setForeground(new ColorUIResource(new Color((int)f, (int)f2, (int)f3)));
                }
            } else {
                object3 = this.getColorSchemeForState(jTable, substanceTableUI, componentState);
                super.setForeground(new ColorUIResource(object3.getForegroundColor()));
            }
        } else {
            object3 = this.getColorSchemeForState(jTable, substanceTableUI, componentState);
            if (bl3) {
                object3 = SubstanceColorSchemeUtilities.getColorScheme(jTable, ColorSchemeAssociationKind.TEXT_HIGHLIGHT, componentState);
            }
            super.setForeground(new ColorUIResource(object3.getForegroundColor()));
        }
        SubstanceStripingUtils.applyStripedBackground(jTable, n, this);
        this.setFont(jTable.getFont());
        object3 = new SubstanceTableUI.TableCellId(n, n2);
        object2 = substanceTableUI.getStateTransitionTracker((SubstanceTableUI.TableCellId)object3);
        Insets insets = substanceTableUI.getCellRendererInsets();
        if (bl2 || object2 != null) {
            SubstanceTableCellBorder substanceTableCellBorder = new SubstanceTableCellBorder(insets, substanceTableUI, (SubstanceTableUI.TableCellId)object3);
            if (object2 != null) {
                substanceTableCellBorder.setAlpha(((StateTransitionTracker)object2).getFocusStrength(bl2));
            }
            if (!jTable.getShowHorizontalLines() && !jTable.getShowVerticalLines()) {
                this.setBorder(new CompoundBorder(new EmptyBorder(jTable.getRowMargin() / 2, 0, jTable.getRowMargin() / 2, 0), substanceTableCellBorder));
            } else {
                this.setBorder(substanceTableCellBorder);
            }
        } else {
            this.setBorder(new EmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        }
        this.setValue(Math.min(100, this.getBarStatus(object)));
        this.setString(this.getDescription(object));
        this.setOpaque(false);
        this.setEnabled(jTable.isEnabled());
        return this;
    }

    private SubstanceColorScheme getColorSchemeForState(JTable jTable, SubstanceTableUI substanceTableUI, ComponentState componentState) {
        UpdateOptimizationInfo updateOptimizationInfo = substanceTableUI.getUpdateOptimizationInfo();
        if (componentState == ComponentState.ENABLED) {
            if (updateOptimizationInfo == null) {
                return SubstanceColorSchemeUtilities.getColorScheme(jTable, componentState);
            }
            return updateOptimizationInfo.getDefaultScheme();
        }
        if (updateOptimizationInfo == null) {
            return SubstanceColorSchemeUtilities.getColorScheme(jTable, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
        }
        return updateOptimizationInfo.getHighlightColorScheme(componentState);
    }

    public Color getBackgroundForRow(JTable jTable, int n) {
        if (n % 2 == 0) {
            return jTable.getBackground();
        }
        return Color.GRAY;
    }
}

