/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.gui.themes.ShellFolder;
import java.io.File;
import java.io.ObjectStreamException;

class DefaultShellFolder
extends ShellFolder {
    DefaultShellFolder(ShellFolder shellFolder, File file) {
        super(shellFolder, file.getAbsolutePath());
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        return new File(this.getPath());
    }

    @Override
    public File[] listFiles() {
        File[] fileArray = super.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i] = new DefaultShellFolder((ShellFolder)this, fileArray[i]);
            }
        }
        return fileArray;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public boolean isHidden() {
        String string = this.getName();
        if (string.length() > 0) {
            return string.charAt(0) == '.';
        }
        return false;
    }

    @Override
    public ShellFolder getLinkLocation() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getFolderType() {
        if (this.isDirectory()) {
            return "File Folder";
        }
        return "File";
    }

    @Override
    public String getExecutableType() {
        return null;
    }
}

