/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.gui.themes.FilePane;
import com.limegroup.gnutella.gui.themes.SkinMenu;
import com.limegroup.gnutella.gui.themes.SkinPopupMenu;
import com.limegroup.gnutella.gui.themes.SkinRadioButtonMenuItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class FilePaneEx
extends FilePane {
    private static final long serialVersionUID = 153183794490651820L;
    private SkinPopupMenu contextMenu;
    private SkinMenu viewMenu;
    private String viewMenuLabelText;
    private boolean listViewWindowsStyle;
    private static final int VIEWTYPE_COUNT = 2;
    private String[] viewTypeActionNames;

    public FilePaneEx(FilePane.FileChooserUIAccessor fileChooserUIAccessor) {
        super(fileChooserUIAccessor);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Locale locale = this.getFileChooser().getLocale();
        this.listViewWindowsStyle = UIManager.getBoolean("FileChooser.listViewWindowsStyle");
        this.viewMenuLabelText = UIManager.getString((Object)"FileChooser.viewMenuLabelText", locale);
        this.viewTypeActionNames = new String[2];
        this.viewTypeActionNames[0] = UIManager.getString((Object)"FileChooser.listViewActionLabelText", locale);
        this.viewTypeActionNames[1] = UIManager.getString((Object)"FileChooser.detailsViewActionLabelText", locale);
    }

    @Override
    public JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new SkinMenu(this.viewMenuLabelText);
            ButtonGroup buttonGroup = new ButtonGroup();
            for (int i = 0; i < 2; ++i) {
                SkinRadioButtonMenuItem skinRadioButtonMenuItem = new SkinRadioButtonMenuItem(new ViewTypeAction(i));
                buttonGroup.add(skinRadioButtonMenuItem);
                this.viewMenu.add(skinRadioButtonMenuItem);
            }
            this.updateViewMenu();
        }
        return this.viewMenu;
    }

    private void updateViewMenu() {
        if (this.viewMenu != null) {
            Component[] componentArray = this.viewMenu.getMenuComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                SkinRadioButtonMenuItem skinRadioButtonMenuItem;
                if (!(componentArray[i] instanceof SkinRadioButtonMenuItem) || ((ViewTypeAction)(skinRadioButtonMenuItem = (SkinRadioButtonMenuItem)componentArray[i]).getAction()).viewType != this.getViewType()) continue;
                skinRadioButtonMenuItem.setSelected(true);
            }
        }
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        SkinMenu skinMenu = (SkinMenu)this.getViewMenu();
        if (this.contextMenu == null) {
            this.contextMenu = new SkinPopupMenu();
            if (skinMenu != null) {
                this.contextMenu.add(skinMenu);
                if (this.listViewWindowsStyle) {
                    this.contextMenu.addSeparator();
                }
            }
            ActionMap actionMap = this.getActionMap();
            Action action = actionMap.get("refresh");
            Action action2 = actionMap.get("New Folder");
            if (action != null) {
                this.contextMenu.add(action);
                if (this.listViewWindowsStyle && action2 != null) {
                    this.contextMenu.addSeparator();
                }
            }
            if (action2 != null) {
                this.contextMenu.add(action2);
            }
        }
        if (skinMenu != null) {
            skinMenu.getPopupMenu().setInvoker(skinMenu);
        }
        return this.contextMenu;
    }

    class ViewTypeAction
    extends AbstractAction {
        private static final long serialVersionUID = 3795594739034737323L;
        private int viewType;

        ViewTypeAction(int n) {
            String string;
            super(FilePaneEx.this.viewTypeActionNames[n]);
            this.viewType = n;
            switch (n) {
                case 0: {
                    string = "viewTypeList";
                    break;
                }
                case 1: {
                    string = "viewTypeDetails";
                    break;
                }
                default: {
                    string = (String)this.getValue("Name");
                }
            }
            this.putValue("ActionCommandKey", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FilePaneEx.this.setViewType(this.viewType);
        }
    }
}

