/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.gui.themes.DefaultShellFolder;
import com.limegroup.gnutella.gui.themes.ShellFolder;
import com.limegroup.gnutella.gui.themes.ShellFolderColumnInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

class ShellFolderManager {
    private static final String COLUMN_NAME = "FileChooser.fileNameHeaderText";
    private static final String COLUMN_SIZE = "FileChooser.fileSizeHeaderText";
    private static final String COLUMN_DATE = "FileChooser.fileDateHeaderText";
    private Comparator<Object> fileComparator = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            return this.compare((File)object, (File)object2);
        }

        @Override
        public int compare(File file, File file2) {
            ShellFolder shellFolder = null;
            ShellFolder shellFolder2 = null;
            if (file instanceof ShellFolder && (shellFolder = (ShellFolder)file).isFileSystem()) {
                shellFolder = null;
            }
            if (file2 instanceof ShellFolder && (shellFolder2 = (ShellFolder)file2).isFileSystem()) {
                shellFolder2 = null;
            }
            if (shellFolder != null && shellFolder2 != null) {
                return shellFolder.compareTo(shellFolder2);
            }
            if (shellFolder != null) {
                return -1;
            }
            if (shellFolder2 != null) {
                return 1;
            }
            String string = file.getName();
            String string2 = file2.getName();
            int n = string.toLowerCase().compareTo(string2.toLowerCase());
            if (n != 0) {
                return n;
            }
            return string.compareTo(string2);
        }
    };

    ShellFolderManager() {
    }

    public ShellFolder createShellFolder(File file) throws FileNotFoundException {
        return new DefaultShellFolder(null, file);
    }

    public Object get(String string) {
        if (string.equals("fileChooserDefaultFolder")) {
            File file = new File(System.getProperty("user.home"));
            try {
                return this.createShellFolder(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return file;
            }
        }
        if (string.equals("roots")) {
            return File.listRoots();
        }
        if (string.equals("fileChooserComboBoxFolders")) {
            return this.get("roots");
        }
        if (string.equals("fileChooserShortcutPanelFolders")) {
            return new File[]{(File)this.get("fileChooserDefaultFolder")};
        }
        return null;
    }

    public boolean isComputerNode(File file) {
        return false;
    }

    public boolean isFileSystemRoot(File file) {
        if (file instanceof ShellFolder && !((ShellFolder)file).isFileSystem()) {
            return false;
        }
        return file.getParentFile() == null;
    }

    public void sortFiles(List<Object> list) {
        Collections.sort(list, this.fileComparator);
    }

    public ShellFolderColumnInfo[] getFolderColumns(File file) {
        ShellFolderColumnInfo[] shellFolderColumnInfoArray = null;
        if (file instanceof ShellFolder) {
            shellFolderColumnInfoArray = ((ShellFolder)file).getFolderColumns();
        }
        if (shellFolderColumnInfoArray == null) {
            shellFolderColumnInfoArray = new ShellFolderColumnInfo[]{new ShellFolderColumnInfo(COLUMN_NAME, 150, 10, true, null, this.fileComparator), new ShellFolderColumnInfo(COLUMN_SIZE, 75, 4, true, null, ComparableComparator.getInstance(), true), new ShellFolderColumnInfo(COLUMN_DATE, 130, 10, true, null, ComparableComparator.getInstance(), true)};
        }
        return shellFolderColumnInfoArray;
    }

    public Object getFolderColumnValue(File file, int n) {
        Object object;
        if (file instanceof ShellFolder && (object = ((ShellFolder)file).getFolderColumnValue(n)) != null) {
            return object;
        }
        if (file == null || !file.exists()) {
            return null;
        }
        switch (n) {
            case 0: {
                return file;
            }
            case 1: {
                return file.isDirectory() ? null : new Long(file.length());
            }
            case 2: {
                if (this.isFileSystemRoot(file)) {
                    return null;
                }
                long l = file.lastModified();
                return l == 0L ? null : new Date(l);
            }
        }
        return null;
    }

    private static class ComparableComparator
    implements Comparator<Object> {
        private static Comparator<Object> instance;

        private ComparableComparator() {
        }

        public static Comparator<Object> getInstance() {
            if (instance == null) {
                instance = new ComparableComparator();
            }
            return instance;
        }

        @Override
        public int compare(Object object, Object object2) {
            int n = object == null && object2 == null ? 0 : (object != null && object2 == null ? 1 : (object == null && object2 != null ? -1 : (object instanceof Comparable ? ((Comparable)object).compareTo(object2) : 0)));
            return n;
        }
    }
}

