/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.gui.themes.SkinComboPopup;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultComboBoxRenderer;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.RolloverTextControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceDropDownButton;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceTextComponentBorder;
import org.pushingpixels.substance.internal.utils.combo.ComboBoxBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.combo.SubstanceComboBoxEditor;
import org.pushingpixels.substance.internal.utils.combo.SubstanceComboPopup;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

public class SkinComboBoxUI
extends BasicComboBoxUI
implements TransitionAwareUI {
    protected ComboBoxPropertyChangeHandler substanceChangeHandler;
    protected StateTransitionTracker stateTransitionTracker;
    private ButtonModel transitionModel;
    private RolloverTextControlListener substanceRolloverListener;
    private ComboBoxBackgroundDelegate delegate;
    private Icon uneditableArrowIcon;
    private Insets layoutInsets;

    public static ComponentUI createUI(JComponent jComponent) {
        return ThemeMediator.CURRENT_THEME.createComboBoxUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.putClientProperty("substancelaf.internal.textComponentAware", new SubstanceCoreUtilities.TextComponentAware<JComboBox>(){

            @Override
            public JTextComponent getTextComponent(JComboBox jComboBox) {
                Component component;
                if (jComboBox.isEditable() && (component = jComboBox.getEditor().getEditorComponent()) instanceof JTextComponent) {
                    return (JTextComponent)component;
                }
                return null;
            }
        });
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.putClientProperty("substancelaf.internal.textComponentAware", null);
        super.uninstallUI(jComponent);
    }

    public SkinComboBoxUI(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        this.comboBox.setOpaque(false);
        this.transitionModel = new DefaultButtonModel();
        this.transitionModel.setArmed(false);
        this.transitionModel.setSelected(false);
        this.transitionModel.setPressed(false);
        this.transitionModel.setRollover(false);
        this.transitionModel.setEnabled(jComboBox.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(this.comboBox, this.transitionModel);
        this.delegate = new ComboBoxBackgroundDelegate();
    }

    @Override
    protected JButton createArrowButton() {
        SubstanceDropDownButton substanceDropDownButton = new SubstanceDropDownButton(this.comboBox);
        substanceDropDownButton.setFont(this.comboBox.getFont());
        substanceDropDownButton.setIcon(this.getCurrentIcon(substanceDropDownButton));
        return substanceDropDownButton;
    }

    private Icon getCurrentIcon(JButton jButton) {
        Icon icon = SubstanceCoreUtilities.getArrowIcon(jButton, SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox));
        return icon;
    }

    protected ListCellRenderer createRenderer() {
        return new SubstanceDefaultComboBoxRenderer.SubstanceUIResource(this.comboBox);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceChangeHandler = new ComboBoxPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.substanceChangeHandler);
        this.substanceRolloverListener = new RolloverTextControlListener(this.comboBox, this, this.transitionModel);
        this.substanceRolloverListener.registerListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
    }

    @Override
    protected void uninstallListeners() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.comboBox.removePropertyChangeListener(this.substanceChangeHandler);
        this.substanceChangeHandler = null;
        this.substanceRolloverListener.unregisterListeners();
        this.substanceRolloverListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.uneditableArrowIcon = SubstanceCoreUtilities.getArrowIcon(this.comboBox, new TransitionAwareIcon.TransitionAwareUIDelegate(){

            @Override
            public TransitionAwareUI getTransitionAwareUI() {
                return (TransitionAwareUI)((Object)SkinComboBoxUI.this.comboBox.getUI());
            }
        }, SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox));
        this.updateComboBoxBorder();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new SubstanceComboBoxLayoutManager();
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.layoutInsets;
        int n3 = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(this.comboBox));
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, n - insets.left - insets.right - n3, n2 - insets.top - insets.bottom);
        }
        int n4 = insets.left + n3;
        return new Rectangle(n4, insets.top, n - n4 - insets.right, n2 - insets.top - insets.bottom);
    }

    @Override
    protected Dimension getDefaultSize() {
        Component component = new SubstanceDefaultComboBoxRenderer(this.comboBox).getListCellRendererComponent(this.listBox, (Object)" ", -1, false, false);
        component.setFont(this.comboBox.getFont());
        return component.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        SubstanceDropDownButton substanceDropDownButton = (SubstanceDropDownButton)this.arrowButton;
        Insets insets = substanceDropDownButton.getInsets();
        Insets insets2 = this.comboBox.getInsets();
        Dimension dimension = this.getDisplaySize();
        dimension.width += insets2.left + insets2.right;
        dimension.width += insets.left + insets.right;
        dimension.width = (int)((double)dimension.width + substanceDropDownButton.getMinimumSize().getWidth());
        dimension.height += insets2.top + insets2.bottom;
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    @Override
    protected ComboPopup createPopup() {
        final SkinComboPopup skinComboPopup = new SkinComboPopup(this.comboBox);
        final ComponentOrientation componentOrientation = this.comboBox.getComponentOrientation();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComboBoxEditor comboBoxEditor;
                Object object;
                if (SkinComboBoxUI.this.comboBox == null) {
                    return;
                }
                if (skinComboPopup instanceof Component) {
                    object = (Component)((Object)skinComboPopup);
                    ((Component)object).applyComponentOrientation(componentOrientation);
                    ((Component)object).doLayout();
                }
                if ((object = SkinComboBoxUI.this.comboBox.getRenderer()) instanceof Component) {
                    ((Component)object).applyComponentOrientation(componentOrientation);
                }
                if ((comboBoxEditor = SkinComboBoxUI.this.comboBox.getEditor()) != null && comboBoxEditor.getEditorComponent() != null) {
                    comboBoxEditor.getEditorComponent().applyComponentOrientation(componentOrientation);
                }
                SkinComboBoxUI.this.comboBox.repaint();
            }
        });
        return skinComboPopup;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n2 = this.comboBox.getWidth();
        int n3 = this.comboBox.getHeight();
        Insets insets = this.comboBox.getInsets();
        int n4 = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
        if (this.comboBox.isEditable()) {
            int n5 = (int)Math.floor(SubstanceSizeUtils.getBorderStrokeWidth(n4));
            object = SubstanceOutlineUtilities.getBaseOutline(n2, n3, Math.max(0.0f, 2.0f * SubstanceSizeUtils.getClassicButtonCornerRadius(n4) - (float)n5), null, n5);
            graphics2D.setColor(SubstanceTextUtilities.getTextBackgroundFillColor(this.comboBox));
            graphics2D.fill((Shape)object);
        } else {
            this.delegate.updateBackground(graphics2D, this.comboBox, this.transitionModel);
            Icon icon = this.uneditableArrowIcon;
            int n6 = icon.getIconWidth();
            int n7 = icon.getIconHeight();
            n = SubstanceSizeUtils.getScrollBarWidth(n4);
            if (this.comboBox.getComponentOrientation().isLeftToRight()) {
                int n8 = n2 - n - insets.right / 2 + (n - n6) / 2;
                int n9 = insets.top + (n3 - insets.top - insets.bottom - n7) / 2;
                icon.paintIcon(this.comboBox, graphics2D, n8, n9);
            } else {
                int n10 = insets.left / 2 + (n - n6) / 2;
                int n11 = insets.top + (n3 - insets.top - insets.bottom - n7) / 2;
                icon.paintIcon(this.comboBox, graphics2D, n10, n11);
            }
        }
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            object = this.comboBox.getRenderer();
            Component component = this.hasFocus ? object.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, this.hasFocus) : object.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, this.hasFocus);
            component.setFont(this.comboBox.getFont());
            n = 0;
            if (component instanceof JPanel) {
                n = 1;
            }
            if (this.comboBox.getComponentOrientation().isLeftToRight()) {
                this.currentValuePane.paintComponent(graphics2D, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n != 0);
            } else {
                this.currentValuePane.paintComponent(graphics2D, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n != 0);
            }
        }
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = new Rectangle(insets.left, this.layoutInsets.top, n2 - insets.left - insets.right, n3 - this.layoutInsets.top - this.layoutInsets.bottom);
            this.paintFocus(graphics2D, rectangle);
        }
        graphics2D.dispose();
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle) {
        int n = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
        int n2 = SubstanceSizeUtils.getFocusRingPadding(n) / 2;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(n3, n4);
        SubstanceCoreUtilities.paintFocus(graphics2D, this.comboBox, this.comboBox, this, SubstanceOutlineUtilities.getBaseOutline(rectangle.width, rectangle.height, SubstanceSizeUtils.getClassicButtonCornerRadius(n), null, 0), rectangle, 1.0f, n2);
        graphics2D.dispose();
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    @Override
    public void configureArrowButton() {
        super.configureArrowButton();
        this.arrowButton.setFocusable(false);
        this.configureArrowButtonStraightSide();
    }

    protected void configureArrowButtonStraightSide() {
        this.arrowButton.putClientProperty("substancelaf.buttonside", (Object)(this.comboBox.getComponentOrientation().isLeftToRight() ? SubstanceConstants.Side.LEFT : SubstanceConstants.Side.RIGHT));
    }

    @Override
    public void unconfigureArrowButton() {
        super.unconfigureArrowButton();
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        if (this.editor instanceof JComponent) {
            Insets insets = SubstanceSizeUtils.getComboTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.editor));
            ((JComponent)this.editor).setBorder(new EmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
            this.editor.setBackground(this.comboBox.getBackground());
        }
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new SubstanceComboBoxEditor.UIResource();
    }

    private void updateComboBoxBorder() {
        Border border = this.comboBox.getBorder();
        if (border == null || border instanceof UIResource) {
            int n = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
            Insets insets = SubstanceSizeUtils.getComboBorderInsets(n);
            if (this.comboBox.isEditable()) {
                this.comboBox.setBorder(new SubstanceTextComponentBorder(insets));
            } else {
                this.comboBox.setBorder(new BorderUIResource.EmptyBorderUIResource(insets));
                this.comboBox.setPrototypeDisplayValue(this.comboBox.getPrototypeDisplayValue());
            }
            this.layoutInsets = SubstanceSizeUtils.getComboLayoutInsets(n);
        } else {
            this.layoutInsets = new Insets(0, 0, 0, 0);
        }
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return false;
        }
        ClassicButtonShaper classicButtonShaper = ClassicButtonShaper.INSTANCE;
        if (classicButtonShaper == null) {
            return false;
        }
        GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(this.comboBox, SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.comboBox)), null);
        return generalPath.contains(mouseEvent.getPoint());
    }

    public void setPopupVisible(JComboBox jComboBox, boolean bl) {
        if (bl) {
            this.popup.show();
        } else if (this.popup instanceof SubstanceComboPopup) {
            try {
                this.popup.hide();
            }
            catch (Exception exception) {}
        } else {
            this.popup.hide();
        }
    }

    public class ComboBoxPropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        public ComboBoxPropertyChangeHandler() {
            super(SkinComboBoxUI.this);
        }

        @Override
        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("componentOrientation")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SkinComboBoxUI.this.comboBox == null) {
                            return;
                        }
                        ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                        ListCellRenderer listCellRenderer = SkinComboBoxUI.this.comboBox.getRenderer();
                        ComboBoxEditor comboBoxEditor = SkinComboBoxUI.this.comboBox.getEditor();
                        if (SkinComboBoxUI.this.popup instanceof Component) {
                            Component component = (Component)((Object)SkinComboBoxUI.this.popup);
                            component.applyComponentOrientation(componentOrientation);
                            component.doLayout();
                        }
                        if (listCellRenderer instanceof Component) {
                            ((Component)((Object)listCellRenderer)).applyComponentOrientation(componentOrientation);
                        }
                        if (comboBoxEditor != null && comboBoxEditor.getEditorComponent() != null) {
                            comboBoxEditor.getEditorComponent().applyComponentOrientation(componentOrientation);
                        }
                        if (SkinComboBoxUI.this.comboBox != null) {
                            SkinComboBoxUI.this.comboBox.repaint();
                        }
                        SkinComboBoxUI.this.configureArrowButtonStraightSide();
                    }
                });
            }
            if ("substancelaf.comboboxpopupFlyoutOrientation".equals(string)) {
                ((SubstanceDropDownButton)SkinComboBoxUI.this.arrowButton).setIcon(SubstanceCoreUtilities.getArrowIcon(SkinComboBoxUI.this.arrowButton, SubstanceCoreUtilities.getPopupFlyoutOrientation(SkinComboBoxUI.this.comboBox)));
            }
            if ("font".equals(string)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SkinComboBoxUI.this.comboBox != null) {
                            SkinComboBoxUI.this.comboBox.updateUI();
                        }
                    }
                });
            }
            if ("background".equals(string) && SkinComboBoxUI.this.comboBox.isEditable()) {
                SkinComboBoxUI.this.comboBox.getEditor().getEditorComponent().setBackground(SkinComboBoxUI.this.comboBox.getBackground());
                SkinComboBoxUI.this.popup.getList().setBackground(SkinComboBoxUI.this.comboBox.getBackground());
            }
            if ("editable".equals(string)) {
                SkinComboBoxUI.this.updateComboBoxBorder();
                SkinComboBoxUI.this.isMinimumSizeDirty = true;
            }
            if ("enabled".equals(string)) {
                SkinComboBoxUI.this.transitionModel.setEnabled(SkinComboBoxUI.this.comboBox.isEnabled());
            }
        }
    }

    private class SubstanceComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private SubstanceComboBoxLayoutManager() {
            super(SkinComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            Insets insets = SkinComboBoxUI.this.layoutInsets;
            int n3 = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(SkinComboBoxUI.this.comboBox));
            if (SkinComboBoxUI.this.arrowButton != null) {
                if (!SkinComboBoxUI.this.comboBox.isEditable()) {
                    SkinComboBoxUI.this.arrowButton.setBounds(0, 0, 0, 0);
                } else if (jComboBox.getComponentOrientation().isLeftToRight()) {
                    SkinComboBoxUI.this.arrowButton.setBounds(n - n3 - insets.right, 0, n3 + insets.right, n2);
                } else {
                    SkinComboBoxUI.this.arrowButton.setBounds(0, 0, n3 + insets.left, n2);
                }
            }
            if (SkinComboBoxUI.this.editor != null) {
                Rectangle rectangle = SkinComboBoxUI.this.rectangleForCurrentValue();
                SkinComboBoxUI.this.editor.setBounds(rectangle);
            }
        }
    }
}

