/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.gui.themes.SkinListUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceBorder;

public class SkinComboPopup
extends BasicComboPopup {
    private static final long serialVersionUID = -3629162645341440812L;

    public SkinComboPopup(JComboBox jComboBox) {
        super(jComboBox);
        this.setOpaque(true);
        this.list.setBackground(jComboBox.getBackground());
    }

    @Override
    protected void configurePopup() {
        super.configurePopup();
        this.setBorder(new SubstanceBorder(new Insets(0, 2, 2, 2)));
    }

    private void setListSelection(int n) {
        if (n == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    private Point getPopupLocation() {
        Dimension dimension = this.comboBox.getSize();
        Insets insets = this.getInsets();
        dimension.setSize(dimension.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
        Dimension dimension2 = rectangle.getSize();
        Point point = rectangle.getLocation();
        this.scroller.setMaximumSize(dimension2);
        this.scroller.setPreferredSize(dimension2);
        this.scroller.setMinimumSize(dimension2);
        this.list.revalidate();
        return new Point(point.x, point.y);
    }

    @Override
    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        Object object;
        Rectangle rectangle;
        Cloneable cloneable;
        int n5 = SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox);
        Insets insets = this.getInsets();
        int n6 = 0;
        int n7 = 0;
        switch (n5) {
            case 1: {
                n7 = -n4 - (int)this.comboBox.getSize().getHeight() - insets.top - insets.bottom;
                break;
            }
            case 0: {
                n7 = -n4 / 2 - (int)this.comboBox.getSize().getHeight() / 2 - insets.top / 2 - insets.bottom / 2;
                break;
            }
            case 3: {
                n6 = n3 + insets.left + insets.right;
                n7 = -((int)this.comboBox.getSize().getHeight());
                break;
            }
            case 7: {
                n6 = -n3 - insets.left - insets.right;
                n7 = -((int)this.comboBox.getSize().getHeight());
            }
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = this.comboBox.getGraphicsConfiguration();
        Point point = new Point();
        SwingUtilities.convertPointFromScreen(point, this.comboBox);
        if (graphicsConfiguration != null) {
            cloneable = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle = graphicsConfiguration.getBounds();
            rectangle.width -= cloneable.left + cloneable.right;
            rectangle.height -= cloneable.top + cloneable.bottom;
            rectangle.x += point.x + cloneable.left;
            rectangle.y += point.y + cloneable.top;
        } else {
            rectangle = new Rectangle(point, toolkit.getScreenSize());
        }
        cloneable = new Rectangle(n + n6, n2 + n7, n3, n4);
        if (n2 + n4 > rectangle.y + rectangle.height && n4 < rectangle.height) {
            ((Rectangle)cloneable).y = -((Rectangle)cloneable).height - insets.top - insets.bottom;
        }
        if ((object = SubstanceCoreUtilities.getComboPopupPrototypeDisplayValue(this.comboBox)) != null) {
            boolean bl;
            ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
            Component component = listCellRenderer.getListCellRendererComponent(this.list, object, -1, true, true);
            int n8 = component.getPreferredSize().width;
            boolean bl2 = bl = this.comboBox.getItemCount() > this.comboBox.getMaximumRowCount();
            if (bl) {
                JScrollBar jScrollBar = this.scroller.getVerticalScrollBar();
                n8 += jScrollBar.getPreferredSize().width;
            }
            ((Rectangle)cloneable).width = n3 = Math.max(n3, n8);
        }
        return cloneable;
    }

    @Override
    public void show() {
        this.setListSelection(this.comboBox.getSelectedIndex());
        Point point = this.getPopupLocation();
        this.show(this.comboBox, point.x, point.y);
    }

    @Override
    public void hide() {
        super.hide();
        SkinListUI skinListUI = (SkinListUI)this.list.getUI();
        skinListUI.resetRolloverIndex();
    }

    public JComboBox getCombobox() {
        return this.comboBox;
    }
}

