/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.gui.themes.BaseFileChooserUI;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SkinFileChooserUI
extends BaseFileChooserUI {
    private final SubstanceFileView fileView = new SubstanceFileView();

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SkinFileChooserUI((JFileChooser)jComponent);
    }

    public SkinFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    @Override
    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    private class SubstanceFileView
    extends BasicFileChooserUI.BasicFileView {
        private final Map<String, Icon> pathIconCache;

        private SubstanceFileView() {
            super(SkinFileChooserUI.this);
            this.pathIconCache = new HashMap<String, Icon>();
        }

        @Override
        public Icon getCachedIcon(File file) {
            return this.pathIconCache.get(file.getPath());
        }

        @Override
        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            icon = this.getDefaultIcon(file);
            if (icon == null && (icon = super.getIcon(file)) == null) {
                icon = new ImageIcon(SubstanceCoreUtilities.getBlankImage(8, 8));
            }
            this.cacheIcon(file, icon);
            return icon;
        }

        @Override
        public void cacheIcon(File file, Icon icon) {
            this.pathIconCache.put(file.getPath(), icon);
        }

        @Override
        public void clearIconCache() {
            this.pathIconCache.clear();
        }

        public Icon getDefaultIcon(File file) {
            JFileChooser jFileChooser = SkinFileChooserUI.this.getFileChooser();
            Icon icon = jFileChooser.getFileSystemView().getSystemIcon(file);
            if (SubstanceCoreUtilities.useThemedDefaultIcon(null)) {
                icon = SubstanceCoreUtilities.getThemedIcon(jFileChooser, icon);
            }
            return icon;
        }
    }
}

