/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.frostwire.gui.components.RangeSlider;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSliderUI;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.ClassicFillPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.SubstanceIconFactory;

public class SkinRangeSliderUI
extends BasicSliderUI
implements TransitionAwareUI {
    private ButtonModel thumbModel = new DefaultButtonModel();
    private RolloverControlListener substanceRolloverListener;
    private PropertyChangeListener substancePropertyChangeListener;
    protected StateTransitionTracker stateTransitionTracker;
    protected Icon horizontalIcon;
    protected Icon roundIcon;
    protected Icon verticalIcon;
    protected static final LazyResettableHashMap<BufferedImage> trackCache = new LazyResettableHashMap("SubstanceSliderUI.track");
    protected Rectangle upperThumbRect;
    protected boolean upperThumbSelected;
    private transient boolean lowerDragging;
    private transient boolean upperDragging;
    protected RangeSlider slider;
    protected int lastUpperValue;

    public static ComponentUI createUI(JComponent jComponent) {
        return ThemeMediator.CURRENT_THEME.createRangeSliderUI(jComponent);
    }

    public SkinRangeSliderUI(RangeSlider rangeSlider) {
        super(null);
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
        this.thumbModel.setEnabled(rangeSlider.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(rangeSlider, this.thumbModel);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.slider = (RangeSlider)jComponent;
        this.upperThumbRect = new Rectangle();
        this.lastUpperValue = this.slider.getUpperValue();
        super.installUI(jComponent);
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new RangeTrackListener();
    }

    @Override
    protected ChangeListener createChangeListener(JSlider jSlider) {
        return new ChangeHandler();
    }

    @Override
    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.upperThumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
    }

    @Override
    protected void calculateTrackRect() {
        super.calculateTrackRect();
        if (this.slider.getOrientation() == 0) {
            this.trackRect.y = 3 + (int)Math.ceil(SubstanceSizeUtils.getFocusStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.slider))) + this.insetCache.top;
        }
    }

    private Rectangle getPaintTrackRect() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getTrackWidth();
        if (this.slider.getOrientation() == 0) {
            n3 = 3 + this.insetCache.top + 2 * this.focusInsets.top;
            n4 = n3 + n5 - 1;
            n2 = this.trackRect.width;
            return new Rectangle(this.trackRect.x + n, n3, n2 - n, n4 - n3);
        }
        if (this.slider.getPaintLabels() || this.slider.getPaintTicks()) {
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                n = this.trackRect.x + this.insetCache.left + this.focusInsets.left;
                n2 = n + n5 - 1;
            } else {
                n2 = this.trackRect.x + this.trackRect.width - this.insetCache.right - this.focusInsets.right;
                n = n2 - n5 - 1;
            }
        } else if (this.slider.getComponentOrientation().isLeftToRight()) {
            n = (this.insetCache.left + this.focusInsets.left + this.slider.getWidth() - this.insetCache.right - this.focusInsets.right) / 2 - n5 / 2;
            n2 = n + n5 - 1;
        } else {
            n2 = (this.insetCache.left + this.focusInsets.left + this.slider.getWidth() - this.insetCache.right - this.focusInsets.right) / 2 + n5 / 2;
            n = n2 - n5 - 1;
        }
        n4 = this.trackRect.height - 1;
        return new Rectangle(n, this.trackRect.y + n3, n2 - n, n4 - n3);
    }

    @Override
    public void paintTrack(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        boolean bl = this.drawInverted();
        Rectangle rectangle = this.getPaintTrackRect();
        int n = rectangle.width;
        int n2 = rectangle.height;
        if (this.slider.getOrientation() == 1) {
            int n3 = n;
            n = n2;
            n2 = n3;
            object = graphics2D.getTransform();
            ((AffineTransform)object).translate(rectangle.x, n + rectangle.y);
            ((AffineTransform)object).rotate(-1.5707963267948966);
            graphics2D.setTransform((AffineTransform)object);
        } else {
            graphics2D.translate(rectangle.x, rectangle.y);
        }
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.stateTransitionTracker.getModelStateInfo();
        object = SubstanceColorSchemeUtilities.getColorScheme(this.slider, this.slider.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.slider, ColorSchemeAssociationKind.BORDER, this.slider.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        this.paintSliderTrack(graphics2D, bl, (SubstanceColorScheme)object, substanceColorScheme, n, n2);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
            float f;
            ComponentState componentState = entry.getKey();
            if (!componentState.isActive() || (f = entry.getValue().getContribution()) == 0.0f) continue;
            graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(this.slider, f, graphics));
            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.slider, componentState);
            SubstanceColorScheme substanceColorScheme3 = SubstanceColorSchemeUtilities.getColorScheme(this.slider, ColorSchemeAssociationKind.BORDER, componentState);
            this.paintSliderTrackSelected(graphics2D, bl, rectangle, substanceColorScheme2, substanceColorScheme3, n, n2);
        }
        graphics2D.dispose();
    }

    private void paintSliderTrack(Graphics2D graphics2D, boolean bl, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2, int n, int n2) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        ClassicFillPainter classicFillPainter = ClassicFillPainter.INSTANCE;
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(this.slider);
        int n3 = SubstanceSizeUtils.getComponentFontSize(this.slider);
        int n4 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(n3) / 2.0);
        float f = SubstanceSizeUtils.getClassicButtonCornerRadius(n3) / 2.0f;
        int n5 = (int)SubstanceSizeUtils.getBorderStrokeWidth(n3);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, n2, Float.valueOf(f), n4, n5, substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName());
        BufferedImage bufferedImage = trackCache.get(hashMapKey);
        if (bufferedImage == null) {
            bufferedImage = SubstanceCoreUtilities.getBlankImage(n + 1, n2 + 1);
            Graphics2D graphics2D3 = bufferedImage.createGraphics();
            GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n + 1, n2 + 1, f, null, n4);
            classicFillPainter.paintContourBackground(graphics2D3, this.slider, n, n2, generalPath, false, substanceColorScheme, false);
            GeneralPath generalPath2 = SubstanceOutlineUtilities.getBaseOutline(n + 1, n2 + 1, f - (float)n5, null, n5 + n4);
            substanceBorderPainter.paintBorder(graphics2D3, this.slider, n + 1, n2 + 1, generalPath, generalPath2, substanceColorScheme2);
            trackCache.put(hashMapKey, bufferedImage);
            graphics2D3.dispose();
        }
        graphics2D2.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D2.dispose();
    }

    private void paintSliderTrackSelected(Graphics2D graphics2D, boolean bl, Rectangle rectangle, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2, int n, int n2) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        Insets insets = this.slider.getInsets();
        insets.top /= 2;
        insets.left /= 2;
        insets.bottom /= 2;
        insets.right /= 2;
        SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.getFillPainter(this.slider);
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(this.slider);
        float f = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.slider)) / 2.0f;
        int n3 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.slider)) / 2.0);
        if (this.slider.isEnabled()) {
            if (this.slider.getOrientation() == 0) {
                int n4;
                int n5;
                int n6 = this.thumbRect.x + this.thumbRect.width / 2 - rectangle.x;
                int n7 = this.upperThumbRect.x + this.upperThumbRect.width / 2 - rectangle.x;
                if (bl) {
                    n5 = n6;
                    n4 = n7;
                } else {
                    n5 = n6;
                    n4 = n7;
                }
                int n8 = n4 - n5;
                int n9 = n2 + 1;
                if (n8 > 0 && n9 > 0) {
                    GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n8, n9, f, null, n3);
                    graphics2D2.translate(n5, 0);
                    substanceFillPainter.paintContourBackground(graphics2D2, this.slider, n8, n9, generalPath, false, substanceColorScheme, false);
                    substanceBorderPainter.paintBorder(graphics2D2, this.slider, n8, n9, generalPath, null, substanceColorScheme2);
                }
            } else {
                int n10;
                int n11;
                int n12 = this.thumbRect.y + this.thumbRect.height / 2 - rectangle.y;
                if (this.drawInverted()) {
                    n11 = 0;
                    n10 = n12;
                    graphics2D2.translate(n + 2 - n12, 0);
                } else {
                    n11 = n12;
                    n10 = n + 1;
                }
                int n13 = n10 - n11;
                int n14 = n2 + 1;
                if (n13 > 0 && n14 > 0) {
                    GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n13, n14, f, null, n3);
                    substanceFillPainter.paintContourBackground(graphics2D2, this.slider, n13, n14, generalPath, false, substanceColorScheme, false);
                    substanceBorderPainter.paintBorder(graphics2D2, this.slider, n13, n14, generalPath, null, substanceColorScheme2);
                }
            }
        }
        graphics2D2.dispose();
    }

    @Override
    protected Dimension getThumbSize() {
        Icon icon = this.getIcon();
        return new Dimension(icon.getIconWidth(), icon.getIconHeight());
    }

    protected Icon getIcon() {
        if (this.slider.getOrientation() == 0) {
            if (this.slider.getPaintTicks() || this.slider.getPaintLabels()) {
                return this.horizontalIcon;
            }
            return this.roundIcon;
        }
        if (this.slider.getPaintTicks() || this.slider.getPaintLabels()) {
            return this.verticalIcon;
        }
        return this.roundIcon;
    }

    @Override
    public void paintThumb(Graphics graphics) {
    }

    public void paintThumb(Graphics graphics, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Rectangle rectangle2 = rectangle;
        graphics2D.translate(rectangle2.x, rectangle2.y);
        Icon icon = this.getIcon();
        if (this.slider.getOrientation() == 0) {
            if (icon != null) {
                icon.paintIcon(this.slider, graphics2D, -1, 0);
            }
        } else if (this.slider.getComponentOrientation().isLeftToRight()) {
            if (icon != null) {
                icon.paintIcon(this.slider, graphics2D, 0, -1);
            }
        } else if (icon != null) {
            icon.paintIcon(this.slider, graphics2D, 0, 1);
        }
        graphics2D.dispose();
    }

    public void paintThumbs(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (this.upperThumbSelected) {
            if (rectangle.intersects(this.thumbRect)) {
                this.paintLowerThumb(graphics);
            }
            if (rectangle.intersects(this.upperThumbRect)) {
                this.paintUpperThumb(graphics);
            }
        } else {
            if (rectangle.intersects(this.upperThumbRect)) {
                this.paintUpperThumb(graphics);
            }
            if (rectangle.intersects(this.thumbRect)) {
                this.paintLowerThumb(graphics);
            }
        }
    }

    private void paintLowerThumb(Graphics graphics) {
        this.paintThumb(graphics, this.thumbRect);
    }

    private void paintUpperThumb(Graphics graphics) {
        this.paintThumb(graphics, this.upperThumbRect);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        ComponentState componentState = ComponentState.getState(this.thumbModel, this.slider);
        float f = SubstanceColorSchemeUtilities.getAlpha(this.slider, componentState);
        BackgroundPaintingUtils.updateIfOpaque(graphics2D, jComponent);
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle rectangle = graphics2D.getClipBounds();
        if (!rectangle.intersects(this.trackRect) && this.slider.getPaintTrack()) {
            this.calculateGeometry();
        }
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(this.slider, f, graphics));
        if (this.slider.getPaintTrack() && rectangle.intersects(this.trackRect)) {
            this.paintTrack(graphics2D);
        }
        if (this.slider.getPaintTicks() && rectangle.intersects(this.tickRect)) {
            this.paintTicks(graphics2D);
        }
        this.paintFocus(graphics2D);
        if (rectangle.intersects(this.thumbRect) || rectangle.intersects(this.upperThumbRect)) {
            this.paintThumbs(graphics2D);
        }
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(this.slider, 1.0f, graphics));
        if (this.slider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics2D);
        }
        graphics2D.dispose();
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        Rectangle rectangle = this.thumbRect;
        if (rectangle == null) {
            return false;
        }
        Rectangle rectangle2 = this.upperThumbRect;
        if (rectangle2 == null) {
            return false;
        }
        return rectangle.contains(mouseEvent.getX(), mouseEvent.getY()) || rectangle2.contains(mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        Font font = jSlider.getFont();
        if (font == null || font instanceof UIResource) {
            jSlider.setFont(new FontUIResource(SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getControlFont()));
        }
        int n = SubstanceSizeUtils.getSliderIconSize(SubstanceSizeUtils.getComponentFontSize(jSlider));
        this.horizontalIcon = SubstanceIconFactory.getSliderHorizontalIcon(n, false);
        this.roundIcon = SubstanceIconFactory.getSliderRoundIcon(n);
        this.verticalIcon = SubstanceIconFactory.getSliderVerticalIcon(n, false);
        int n2 = (int)Math.ceil(2.0 * (double)SubstanceSizeUtils.getFocusStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jSlider)));
        this.focusInsets = new Insets(n2, n2, n2, n2);
    }

    @Override
    protected void installListeners(final JSlider jSlider) {
        super.installListeners(jSlider);
        this.substanceRolloverListener = new RolloverControlListener(this, this.thumbModel);
        jSlider.addMouseListener(this.substanceRolloverListener);
        jSlider.addMouseMotionListener(this.substanceRolloverListener);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    SkinRangeSliderUI.this.thumbModel.setEnabled(jSlider.isEnabled());
                }
                if ("font".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jSlider.updateUI();
                        }
                    });
                }
            }
        };
        this.slider.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
    }

    @Override
    protected void uninstallListeners(JSlider jSlider) {
        super.uninstallListeners(jSlider);
        jSlider.removeMouseListener(this.substanceRolloverListener);
        jSlider.removeMouseMotionListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        jSlider.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
    }

    @Override
    public void paintFocus(Graphics graphics) {
        SubstanceCoreUtilities.paintFocus(graphics, this.slider, this.slider, this, null, null, 1.0f, (int)Math.ceil(SubstanceSizeUtils.getFocusStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.slider))) / 2);
    }

    protected int getThumbOverhang() {
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    protected int getTrackWidth() {
        return SubstanceSizeUtils.getSliderTrackSize(SubstanceSizeUtils.getComponentFontSize(this.slider));
    }

    @Override
    protected int getTickLength() {
        return SubstanceSizeUtils.getSliderTickSize(SubstanceSizeUtils.getComponentFontSize(this.slider));
    }

    @Override
    public void paintTicks(Graphics graphics) {
        Rectangle rectangle = this.tickRect;
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.slider, ColorSchemeAssociationKind.SEPARATOR, this.slider.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        if (this.slider.getOrientation() == 0) {
            int n;
            ArrayList<Integer> arrayList;
            int n2 = 0;
            if (this.slider.getMinorTickSpacing() > 0 && this.slider.getMajorTickSpacing() > 0) {
                arrayList = new ArrayList<Integer>();
                for (n = this.slider.getMinimum() + this.slider.getMinorTickSpacing(); n < this.slider.getMaximum(); n += this.slider.getMinorTickSpacing()) {
                    int n3 = n - this.slider.getMinimum();
                    if (n3 % this.slider.getMajorTickSpacing() == 0) continue;
                    n2 = this.xPositionForValue(n);
                    arrayList.add(n2 - 1);
                }
                SeparatorPainterUtils.paintVerticalLines(graphics, this.slider, substanceColorScheme, rectangle.y, arrayList, rectangle.height / 2, 0.75f);
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                arrayList = new ArrayList();
                for (n = this.slider.getMinimum() + this.slider.getMajorTickSpacing(); n < this.slider.getMaximum(); n += this.slider.getMajorTickSpacing()) {
                    n2 = this.xPositionForValue(n);
                    arrayList.add(n2 - 1);
                }
                SeparatorPainterUtils.paintVerticalLines(graphics, this.slider, substanceColorScheme, rectangle.y, arrayList, rectangle.height, 0.75f);
            }
        } else {
            ArrayList<Integer> arrayList;
            graphics.translate(rectangle.x, 0);
            int n = this.slider.getMinimum() + this.slider.getMinorTickSpacing();
            int n4 = 0;
            boolean bl = this.slider.getComponentOrientation().isLeftToRight();
            if (this.slider.getMinorTickSpacing() > 0) {
                arrayList = new ArrayList<Integer>();
                int n5 = 0;
                if (!bl) {
                    n5 = rectangle.width - rectangle.width / 2;
                }
                while (n < this.slider.getMaximum()) {
                    n4 = this.yPositionForValue(n);
                    arrayList.add(n4);
                    n += this.slider.getMinorTickSpacing();
                }
                SeparatorPainterUtils.paintHorizontalLines(graphics, this.slider, substanceColorScheme, n5, arrayList, rectangle.width / 2, bl ? 0.75f : 0.25f, bl);
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                arrayList = new ArrayList();
                for (n = this.slider.getMinimum() + this.slider.getMajorTickSpacing(); n < this.slider.getMaximum(); n += this.slider.getMajorTickSpacing()) {
                    n4 = this.yPositionForValue(n);
                    arrayList.add(n4);
                }
                SeparatorPainterUtils.paintHorizontalLines(graphics, this.slider, substanceColorScheme, 0, arrayList, rectangle.width, bl ? 0.75f : 0.25f, bl);
            }
            graphics.translate(-rectangle.x, 0);
        }
    }

    @Override
    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.slider.getPaintTicks() ? this.getTickLength() : 0;
        } else {
            this.tickRect.width = this.slider.getPaintTicks() ? this.getTickLength() : 0;
            this.tickRect.x = this.slider.getComponentOrientation().isLeftToRight() ? this.trackRect.x + this.trackRect.width : this.trackRect.x - this.tickRect.width;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
        }
        if (this.slider.getPaintTicks()) {
            if (this.slider.getOrientation() == 0) {
                this.tickRect.y -= 3;
            } else {
                this.tickRect.x = this.slider.getComponentOrientation().isLeftToRight() ? (this.tickRect.x -= 2) : (this.tickRect.x += 2);
            }
        }
    }

    @Override
    protected void calculateLabelRect() {
        super.calculateLabelRect();
        if (this.slider.getOrientation() == 1 && !this.slider.getPaintTicks() && this.slider.getComponentOrientation().isLeftToRight()) {
            this.labelRect.x += 3;
        }
        if (this.slider.getOrientation() == 1) {
            this.labelRect.width = this.getHeightOfTallestLabel();
        }
    }

    @Override
    protected void calculateThumbLocation() {
        double d;
        int n;
        super.calculateThumbLocation();
        Rectangle rectangle = this.getPaintTrackRect();
        if (this.slider.getOrientation() == 0) {
            n = this.xPositionForValue(this.slider.getValue());
            d = (double)rectangle.y + (double)rectangle.height / 2.0;
            this.thumbRect.y = (int)(d - (double)this.thumbRect.height / 2.0) + 1;
            this.thumbRect.x = n - this.thumbRect.width / 2;
        } else {
            n = this.yPositionForValue(this.slider.getValue());
            d = (double)rectangle.x + (double)rectangle.width / 2.0;
            this.thumbRect.x = (int)(d - (double)this.thumbRect.width / 2.0) + 1;
            this.thumbRect.y = n - this.thumbRect.height / 2;
        }
        if (this.slider.getOrientation() == 0) {
            n = this.xPositionForValue(this.slider.getUpperValue());
            d = (double)rectangle.y + (double)rectangle.height / 2.0;
            this.upperThumbRect.y = (int)(d - (double)this.upperThumbRect.height / 2.0) + 1;
            this.upperThumbRect.x = n - this.upperThumbRect.width / 2;
        } else {
            n = this.yPositionForValue(this.slider.getUpperValue());
            d = (double)rectangle.x + (double)rectangle.width / 2.0;
            this.upperThumbRect.x = (int)(d - (double)this.upperThumbRect.width / 2.0) + 1;
            this.upperThumbRect.y = n - this.upperThumbRect.height / 2;
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            dimension = new Dimension(this.getPreferredVerticalSize());
            dimension.width = this.insetCache.left + this.insetCache.right;
            dimension.width += this.focusInsets.left + this.focusInsets.right;
            dimension.width += this.trackRect.width;
            if (this.slider.getPaintTicks()) {
                dimension.width += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                dimension.width += this.getWidthOfWidestLabel();
            }
            dimension.width += 3;
        } else {
            dimension = new Dimension(this.getPreferredHorizontalSize());
            dimension.height = this.insetCache.top + this.insetCache.bottom;
            dimension.height += this.focusInsets.top + this.focusInsets.bottom;
            dimension.height += this.trackRect.height;
            if (this.slider.getPaintTicks()) {
                dimension.height += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                dimension.height += this.getHeightOfTallestLabel();
            }
            dimension.height += 3;
        }
        return dimension;
    }

    @Override
    public void setThumbLocation(int n, int n2) {
        super.setThumbLocation(n, n2);
        this.slider.repaint();
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return new Dimension(SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this.slider), 200, 1, 20, false), 21);
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return new Dimension(21, SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this.slider), 200, 1, 20, false));
    }

    private void setUpperThumbLocation(int n, int n2) {
        this.upperThumbRect.setLocation(n, n2);
        this.slider.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByBlock(int n) {
        RangeSlider rangeSlider = this.slider;
        synchronized (rangeSlider) {
            int n2 = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (n2 <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                n2 = 1;
            }
            int n3 = n2 * (n > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int n4 = this.slider.getUpperValue();
                this.slider.setUpperValue(n4 + n3);
            } else {
                int n5 = this.slider.getValue();
                this.slider.setValue(n5 + n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByUnit(int n) {
        RangeSlider rangeSlider = this.slider;
        synchronized (rangeSlider) {
            int n2 = 1 * (n > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int n3 = this.slider.getUpperValue();
                this.slider.setUpperValue(n3 + n2);
            } else {
                int n4 = this.slider.getValue();
                this.slider.setValue(n4 + n2);
            }
        }
    }

    public class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        public RangeTrackListener() {
            super(SkinRangeSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SkinRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (SkinRangeSliderUI.this.slider.isRequestFocusEnabled()) {
                SkinRangeSliderUI.this.slider.requestFocus();
            }
            boolean bl = false;
            boolean bl2 = false;
            if (SkinRangeSliderUI.this.upperThumbSelected) {
                if (SkinRangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    bl2 = true;
                } else if (SkinRangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    bl = true;
                }
            } else if (SkinRangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                bl = true;
            } else if (SkinRangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                bl2 = true;
            }
            if (bl) {
                switch (SkinRangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((SkinRangeSliderUI)SkinRangeSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((SkinRangeSliderUI)SkinRangeSliderUI.this).thumbRect.x;
                    }
                }
                SkinRangeSliderUI.this.upperThumbSelected = false;
                SkinRangeSliderUI.this.lowerDragging = true;
                return;
            }
            SkinRangeSliderUI.this.lowerDragging = false;
            if (bl2) {
                switch (SkinRangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - SkinRangeSliderUI.this.upperThumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - SkinRangeSliderUI.this.upperThumbRect.x;
                    }
                }
                SkinRangeSliderUI.this.upperThumbSelected = true;
                SkinRangeSliderUI.this.upperDragging = true;
                return;
            }
            SkinRangeSliderUI.this.upperDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            SkinRangeSliderUI.this.lowerDragging = false;
            SkinRangeSliderUI.this.upperDragging = false;
            SkinRangeSliderUI.this.slider.setValueIsAdjusting(false);
            super.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!SkinRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (SkinRangeSliderUI.this.lowerDragging) {
                SkinRangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveLowerThumb();
            } else if (SkinRangeSliderUI.this.upperDragging) {
                SkinRangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveUpperThumb();
            }
        }

        @Override
        public boolean shouldScroll(int n) {
            return false;
        }

        private void moveLowerThumb() {
            int n = 0;
            switch (SkinRangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2 = ((SkinRangeSliderUI)SkinRangeSliderUI.this).thumbRect.height / 2;
                    int n3 = this.currentMouseY - this.offset;
                    int n4 = ((SkinRangeSliderUI)SkinRangeSliderUI.this).trackRect.y;
                    int n5 = ((SkinRangeSliderUI)SkinRangeSliderUI.this).trackRect.y + (((SkinRangeSliderUI)SkinRangeSliderUI.this).trackRect.height - 1);
                    int n6 = SkinRangeSliderUI.this.yPositionForValue(SkinRangeSliderUI.this.slider.getValue() + SkinRangeSliderUI.this.slider.getExtent());
                    if (SkinRangeSliderUI.this.drawInverted()) {
                        n5 = n6;
                    } else {
                        n4 = n6;
                    }
                    n3 = Math.max(n3, n4 - n2);
                    n3 = Math.min(n3, n5 - n2);
                    SkinRangeSliderUI.this.setThumbLocation(((SkinRangeSliderUI)SkinRangeSliderUI.this).thumbRect.x, n3);
                    n = n3 + n2;
                    SkinRangeSliderUI.this.slider.setValue(SkinRangeSliderUI.this.valueForYPosition(n));
                    break;
                }
                case 0: {
                    int n7 = ((SkinRangeSliderUI)SkinRangeSliderUI.this).thumbRect.width / 2;
                    int n8 = this.currentMouseX - this.offset;
                    int n9 = ((SkinRangeSliderUI)SkinRangeSliderUI.this).trackRect.x;
                    int n10 = ((SkinRangeSliderUI)SkinRangeSliderUI.this).trackRect.x + (((SkinRangeSliderUI)SkinRangeSliderUI.this).trackRect.width - 1);
                    int n11 = SkinRangeSliderUI.this.xPositionForValue(SkinRangeSliderUI.this.slider.getValue() + SkinRangeSliderUI.this.slider.getExtent());
                    if (SkinRangeSliderUI.this.drawInverted()) {
                        n9 = n11;
                    } else {
                        n10 = n11;
                    }
                    n8 = Math.max(n8, n9 - n7);
                    n8 = Math.min(n8, n10 - n7);
                    SkinRangeSliderUI.this.setThumbLocation(n8, ((SkinRangeSliderUI)SkinRangeSliderUI.this).thumbRect.y);
                    n = n8 + n7;
                    SkinRangeSliderUI.this.slider.setValue(SkinRangeSliderUI.this.valueForXPosition(n));
                    break;
                }
                default: {
                    return;
                }
            }
        }

        private void moveUpperThumb() {
            int n = 0;
            switch (SkinRangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2 = ((SkinRangeSliderUI)SkinRangeSliderUI.this).thumbRect.height / 2;
                    int n3 = this.currentMouseY - this.offset;
                    int n4 = ((SkinRangeSliderUI)SkinRangeSliderUI.this).trackRect.y;
                    int n5 = ((SkinRangeSliderUI)SkinRangeSliderUI.this).trackRect.y + (((SkinRangeSliderUI)SkinRangeSliderUI.this).trackRect.height - 1);
                    int n6 = SkinRangeSliderUI.this.yPositionForValue(SkinRangeSliderUI.this.slider.getValue());
                    if (SkinRangeSliderUI.this.drawInverted()) {
                        n4 = n6;
                    } else {
                        n5 = n6;
                    }
                    n3 = Math.max(n3, n4 - n2);
                    n3 = Math.min(n3, n5 - n2);
                    SkinRangeSliderUI.this.setUpperThumbLocation(((SkinRangeSliderUI)SkinRangeSliderUI.this).thumbRect.x, n3);
                    n = n3 + n2;
                    SkinRangeSliderUI.this.slider.setExtent(SkinRangeSliderUI.this.valueForYPosition(n) - SkinRangeSliderUI.this.slider.getValue());
                    break;
                }
                case 0: {
                    int n7 = ((SkinRangeSliderUI)SkinRangeSliderUI.this).thumbRect.width / 2;
                    int n8 = this.currentMouseX - this.offset;
                    int n9 = ((SkinRangeSliderUI)SkinRangeSliderUI.this).trackRect.x;
                    int n10 = ((SkinRangeSliderUI)SkinRangeSliderUI.this).trackRect.x + (((SkinRangeSliderUI)SkinRangeSliderUI.this).trackRect.width - 1);
                    int n11 = SkinRangeSliderUI.this.xPositionForValue(SkinRangeSliderUI.this.slider.getValue());
                    if (SkinRangeSliderUI.this.drawInverted()) {
                        n10 = n11;
                    } else {
                        n9 = n11;
                    }
                    n8 = Math.max(n8, n9 - n7);
                    n8 = Math.min(n8, n10 - n7);
                    SkinRangeSliderUI.this.setUpperThumbLocation(n8, ((SkinRangeSliderUI)SkinRangeSliderUI.this).thumbRect.y);
                    n = n8 + n7;
                    SkinRangeSliderUI.this.slider.setExtent(SkinRangeSliderUI.this.valueForXPosition(n) - SkinRangeSliderUI.this.slider.getValue());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!SkinRangeSliderUI.this.lowerDragging && !SkinRangeSliderUI.this.upperDragging) {
                SkinRangeSliderUI.this.calculateThumbLocation();
                SkinRangeSliderUI.this.slider.repaint();
            }
        }
    }
}

