/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.gui.themes.ThemeMediator;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextAreaUI;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.RolloverTextControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SkinTextAreaUI
extends BasicTextAreaUI
implements TransitionAwareUI {
    protected StateTransitionTracker stateTransitionTracker;
    protected JTextArea textArea;
    protected PropertyChangeListener substancePropertyChangeListener;
    private RolloverTextControlListener substanceRolloverListener;
    private ButtonModel transitionModel;

    public static ComponentUI createUI(JComponent jComponent) {
        return ThemeMediator.CURRENT_THEME.createTextAreaUI(jComponent);
    }

    public SkinTextAreaUI(JComponent jComponent) {
        this.textArea = (JTextArea)jComponent;
        this.transitionModel = new DefaultButtonModel();
        this.transitionModel.setArmed(false);
        this.transitionModel.setSelected(false);
        this.transitionModel.setPressed(false);
        this.transitionModel.setRollover(false);
        this.transitionModel.setEnabled(this.textArea.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(this.textArea, this.transitionModel);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceRolloverListener = new RolloverTextControlListener(this.textArea, this, this.transitionModel);
        this.substanceRolloverListener.registerListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("font".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SkinTextAreaUI.this.textArea.updateUI();
                            Container container = SkinTextAreaUI.this.textArea.getParent();
                            if (container != null) {
                                container.invalidate();
                                container.validate();
                            }
                        }
                    });
                }
                if ("componentOrientation".equals(propertyChangeEvent.getPropertyName())) {
                    SkinTextAreaUI.this.getComponent().setText(SkinTextAreaUI.this.getComponent().getText());
                }
                if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    SkinTextAreaUI.this.transitionModel.setEnabled(SkinTextAreaUI.this.textArea.isEnabled());
                }
            }
        };
        this.textArea.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.textArea.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
                    return;
                }
                if (SkinTextAreaUI.this.textArea == null) {
                    return;
                }
                Color color = SkinTextAreaUI.this.textArea.getForeground();
                if (color == null || color instanceof UIResource) {
                    SkinTextAreaUI.this.textArea.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceLookAndFeel.getCurrentSkin(SkinTextAreaUI.this.textArea).getEnabledColorScheme(SubstanceLookAndFeel.getDecorationType(SkinTextAreaUI.this.textArea))));
                }
            }
        });
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        SubstanceTextUtilities.paintTextCompBackground(graphics, this.textArea);
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        return true;
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }
}

