/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.themes.ThemeSetter;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.gui.themes.setters.SubstanceThemeSetter;
import java.awt.Font;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import org.limewire.util.FileUtils;

public class ThemeMediator {
    public static ThemeSetter DEFAULT_THEME;
    public static ThemeSetter CURRENT_THEME;
    private static List<ThemeSetter> THEMES;
    private static final List<ThemeObserver> THEME_OBSERVERS;

    public static void updateComponentHierarchy() {
        TipOfTheDayMediator.instance().updateComponentTreeUI();
        NotifyUserProxy.instance().updateUI();
        ThemeMediator.updateThemeObservers();
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    public static void addThemeObserver(ThemeObserver themeObserver) {
        THEME_OBSERVERS.add(themeObserver);
    }

    public static void removeThemeObserver(ThemeObserver themeObserver) {
        THEME_OBSERVERS.remove(themeObserver);
    }

    public static void updateThemeObservers() {
        for (ThemeObserver themeObserver : THEME_OBSERVERS) {
            themeObserver.updateTheme();
        }
    }

    public static void changeTheme(final ThemeSetter themeSetter) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        themeSetter.apply();
                        CURRENT_THEME = themeSetter;
                        ThemeMediator.saveCurrentTheme(themeSetter);
                        ThemeMediator.updateComponentHierarchy();
                    }
                    catch (Exception exception) {
                        System.out.println("Theme '" + themeSetter.getName() + "' failed to apply: " + exception.getMessage());
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static List<ThemeSetter> loadThemes() {
        if (THEMES != null) {
            return THEMES;
        }
        ArrayList<ThemeSetter> arrayList = new ArrayList<ThemeSetter>();
        arrayList.add(SubstanceThemeSetter.SEA_GLASS);
        arrayList.add(SubstanceThemeSetter.FUELED);
        arrayList.add(SubstanceThemeSetter.AUTUMN);
        arrayList.add(SubstanceThemeSetter.BUSINESS_BLACK_STEEL);
        arrayList.add(SubstanceThemeSetter.BUSINESS_BLUE_STEEL);
        arrayList.add(SubstanceThemeSetter.BUSINESS);
        arrayList.add(SubstanceThemeSetter.CHALLENGER_DEEP);
        arrayList.add(SubstanceThemeSetter.CREME_COFFEE);
        arrayList.add(SubstanceThemeSetter.CREME);
        arrayList.add(SubstanceThemeSetter.DUST_COFFEE);
        arrayList.add(SubstanceThemeSetter.DUST);
        arrayList.add(SubstanceThemeSetter.EMERALD_DUSK);
        arrayList.add(SubstanceThemeSetter.GEMINI);
        arrayList.add(SubstanceThemeSetter.GRAPHITE_AQUA);
        arrayList.add(SubstanceThemeSetter.GRAPHITE_GLASS);
        arrayList.add(SubstanceThemeSetter.GRAPHITE);
        arrayList.add(SubstanceThemeSetter.MAGELLAN);
        arrayList.add(SubstanceThemeSetter.MARINER);
        arrayList.add(SubstanceThemeSetter.MIST_AQUA);
        arrayList.add(SubstanceThemeSetter.MIST_SILVER);
        arrayList.add(SubstanceThemeSetter.MODERATE);
        arrayList.add(SubstanceThemeSetter.NEBULA_BRICK_WALL);
        arrayList.add(SubstanceThemeSetter.NEBULA);
        arrayList.add(SubstanceThemeSetter.OFFICE_BLACK_2007);
        arrayList.add(SubstanceThemeSetter.OFFICE_BLUE_2007);
        arrayList.add(SubstanceThemeSetter.OFFICE_SILVER_2007);
        arrayList.add(SubstanceThemeSetter.RAVEN);
        arrayList.add(SubstanceThemeSetter.SAHARA);
        arrayList.add(SubstanceThemeSetter.TWILIGHT);
        DEFAULT_THEME = SubstanceThemeSetter.FUELED;
        THEMES = arrayList;
        CURRENT_THEME = ThemeMediator.loadCurrentTheme();
        return THEMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThemeSetter loadCurrentTheme() {
        ThemeSetter themeSetter;
        block6: {
            themeSetter = DEFAULT_THEME;
            BufferedReader bufferedReader = null;
            try {
                File file = ThemeSettings.SKINS_FILE;
                if (!file.exists()) break block6;
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                for (int i = 0; i < THEMES.size(); ++i) {
                    if (!THEMES.get(i).getName().equals(string)) continue;
                    themeSetter = THEMES.get(i);
                    break;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                FileUtils.close(bufferedReader);
            }
        }
        return themeSetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveCurrentTheme(ThemeSetter themeSetter) throws IOException {
        File file = ThemeSettings.SKINS_FILE;
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        try {
            bufferedWriter.write(themeSetter.getName());
        }
        finally {
            FileUtils.close(bufferedWriter);
        }
    }

    public static void applyCommonSkinUI() {
        UIManager.put("PopupMenuUI", "com.limegroup.gnutella.gui.themes.SkinPopupMenuUI");
        UIManager.put("MenuItemUI", "com.limegroup.gnutella.gui.themes.SkinMenuItemUI");
        UIManager.put("MenuUI", "com.limegroup.gnutella.gui.themes.SkinMenuUI");
        UIManager.put("CheckBoxMenuItemUI", "com.limegroup.gnutella.gui.themes.SkinCheckBoxMenuItemUI");
        UIManager.put("MenuBarUI", "com.limegroup.gnutella.gui.themes.SkinMenuBarUI");
        UIManager.put("RadioButtonMenuItemUI", "com.limegroup.gnutella.gui.themes.SkinRadioButtonMenuItemUI");
        UIManager.put("PopupMenuSeparatorUI", "com.limegroup.gnutella.gui.themes.SkinPopupMenuSeparatorUI");
        UIManager.put("TextAreaUI", "com.limegroup.gnutella.gui.themes.SkinTextAreaUI");
        UIManager.put("ListUI", "com.limegroup.gnutella.gui.themes.SkinListUI");
        UIManager.put("ComboBoxUI", "com.limegroup.gnutella.gui.themes.SkinComboBoxUI");
        UIManager.put("TreeUI", "com.limegroup.gnutella.gui.themes.SkinTreeUI");
        UIManager.put("TableUI", "com.limegroup.gnutella.gui.themes.SkinTableUI");
        UIManager.put("RangeSliderUI", "com.limegroup.gnutella.gui.themes.SkinRangeSliderUI");
        UIManager.put("FileChooserUI", "com.limegroup.gnutella.gui.themes.SkinFileChooserUI");
        UIManager.put("TabbedPaneUI", "com.limegroup.gnutella.gui.themes.SkinTabbedPaneUI");
        UIManager.put("ProgressBarUI", "com.limegroup.gnutella.gui.themes.SkinProgressBarUI");
        UIManager.put("ComboBox.editorInsets", new InsetsUIResource(2, 2, 3, 2));
    }

    public static void setFontSizeDelta(float f) {
        if (f == 0.0f) {
            return;
        }
        HashMap<Font, Font> hashMap = new HashMap<Font, Font>();
        String[] stringArray = new String[]{"Button.font", "CheckBox.font", "ComboBox.font", "DesktopIcon.font", "Label.font", "List.font", "ProgressBar.font", "RadioButton.font", "Slider.font", "Spinner.font", "TabbedPane.font", "TitledBorder.font", "ToggleButton.font", "CheckBoxMenuItem.font", "Menu.font", "MenuBar.font", "MenuItem.font", "PopupMenu.font", "RadioButtonMenuItem.font", "ToolBar.font", "ToolTip.font", "EditorPane.font", "FormattedTextField.font", "PasswordField.font", "Table.font", "TableHeader.font", "TextArea.font", "TextField.font", "TextPane.font", "Tree.font", "InternalFrame.titleFont"};
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length * 2);
        for (String string : stringArray) {
            Font font = UIManager.getFont(string);
            Font font2 = (Font)hashMap.get(font);
            if (font2 == null) {
                if (font == null) continue;
                font2 = new FontUIResource(font.deriveFont((float)font.getSize() + f));
                hashMap.put(font, font2);
            }
            arrayList.add(string);
            arrayList.add(font2);
        }
        UIManager.getDefaults().putDefaults(arrayList.toArray());
    }

    public static void resetFontSizes() {
        while (ThemeSettings.FONT_SIZE_INCREMENT.getValue() != 0) {
            int n = ThemeSettings.FONT_SIZE_INCREMENT.getValue() > 0 ? -1 : 1;
            ThemeSettings.FONT_SIZE_INCREMENT.setValue(ThemeSettings.FONT_SIZE_INCREMENT.getValue() + n);
            ThemeMediator.setFontSizeDelta(n);
            ThemeMediator.updateComponentHierarchy();
        }
    }

    static {
        ThemeMediator.loadThemes();
        THEME_OBSERVERS = new LinkedList<ThemeObserver>();
    }
}

