/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.settings.LimeProps;
import java.awt.Color;
import java.io.File;
import org.limewire.setting.ColorSetting;
import org.limewire.setting.FileSetting;
import org.limewire.setting.IntSetting;
import org.limewire.util.CommonUtils;

public final class ThemeSettings
extends LimeProps {
    public static final String EXTENSION = "fwtp";
    public static final File SKINS_FILE = new File(CommonUtils.getUserSettingsDir(), "skins.dat");
    public static final File THEME_DIR_FILE = new File(CommonUtils.getUserSettingsDir(), "themes");
    public static final String PINSTRIPES_OSX_THEME_NAME = "pinstripes_theme_osx.fwtp";
    public static final String BRUSHED_METAL_OSX_THEME_NAME = "brushed_metal_theme_osx.fwtp";
    public static final String WINDOWS_LAF_THEME_NAME = "windows_theme.fwtp";
    public static final String GTK_LAF_THEME_NAME = "GTK_theme.fwtp";
    public static final String PRO_THEME_NAME = "frostwirePro_theme.fwtp";
    public static final String OTHER_THEME_NAME = "other_theme.fwtp";
    static final File BRUSHED_METAL_OSX_THEME_FILE = new File(THEME_DIR_FILE, "brushed_metal_theme_osx.fwtp");
    static final File WINDOWS_LAF_THEME_FILE = new File(THEME_DIR_FILE, "windows_theme.fwtp");
    static final File GTK_LAF_THEME_FILE = new File(THEME_DIR_FILE, "GTK_theme.fwtp");
    static final File PRO_THEME_FILE = new File(THEME_DIR_FILE, "frostwirePro_theme.fwtp");
    static final File OTHER_THEME_FILE = new File(THEME_DIR_FILE, "other_theme.fwtp");
    public static ColorSetting PLAYING_DATA_LINE_COLOR = FACTORY.createColorSetting("PLAYING_DATA_LINE_COLOR", new Color(7, 170, 0));
    public static ColorSetting FILE_NO_EXISTS_DATA_LINE_COLOR = FACTORY.createColorSetting("FILE_NO_EXISTS_DATA_LINE_COLOR", Color.RED);
    public static final File THEME_DEFAULT = GTK_LAF_THEME_FILE;
    public static final File THEME_DEFAULT_DIR = new File(THEME_DIR_FILE, "GTK_theme");
    public static final FileSetting THEME_FILE = FACTORY.createFileSetting("THEME_FILE", THEME_DEFAULT);
    public static final FileSetting THEME_DIR = FACTORY.createFileSetting("THEME_DIR", THEME_DEFAULT_DIR);
    public static final IntSetting FONT_SIZE_INCREMENT = FACTORY.createIntSetting("FONT_SIZE_INCREMENT", 0);
    public static final ColorSetting DEFAULT_TABLE_EVEN_ROW_COLOR = FACTORY.createColorSetting("DEFAULT_TABLE_EVEN_ROW_COLOR", new Color(255, 255, 255));
    public static final ColorSetting DEFAULT_TABLE_ODD_ROW_COLOR = FACTORY.createColorSetting("DEFAULT_TABLE_ODD_ROW_COLOR", new Color(15923966));
    public static final ColorSetting DEFAULT_TIP_OF_THE_DAY_PANEL_COLOR = FACTORY.createColorSetting("DEFAULT_TIP_OF_THE_DAY_PANEL_COLOR", new Color(248, 248, 255));

    private ThemeSettings() {
    }

    public static boolean isDefaultTheme() {
        return THEME_FILE.getValue().equals(THEME_DEFAULT);
    }

    public static boolean isGTKTheme() {
        return false;
    }

    public static boolean isWindowsTheme() {
        return THEME_FILE.getValue().equals(WINDOWS_LAF_THEME_FILE);
    }

    public static boolean isBrushedMetalTheme() {
        return THEME_FILE.getValue().equals(BRUSHED_METAL_OSX_THEME_FILE);
    }

    public static boolean isNativeOSXTheme() {
        return false;
    }

    public static boolean isNativeTheme() {
        return ThemeSettings.isNativeOSXTheme() || ThemeSettings.isWindowsTheme() || ThemeSettings.isGTKTheme();
    }

    public static boolean isOtherTheme() {
        return THEME_FILE.getValue().equals(OTHER_THEME_FILE);
    }
}

