/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes.fueled;

import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.fueled.FueledTitledBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class FueledSkinWatermark
implements SubstanceWatermark {
    private static final int WATERMARK_WIDTH = 100;
    private static final int WATERMARK_HEIGHT = 100;
    private Image watermarkDarkDarkImage = null;
    private Image watermarkDarkImage = null;
    private Image watermarkLightImage = null;
    private int amount = 5;
    private float density = 0.5f;
    private Random randomNumbers = new Random();

    @Override
    public String getDisplayName() {
        return "FueledSkinWatermark";
    }

    @Override
    public void drawWatermarkImage(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        if (!component.isShowing()) {
            return;
        }
        if (component instanceof JScrollPane) {
            return;
        }
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MAX_VALUE;
        Border border = null;
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            n5 = this.hasClientProperty(jComponent, "CLIENT_PROPERTY_DARK_DARK_NOISE", 0);
            n6 = this.hasClientProperty(jComponent, "CLIENT_PROPERTY_DARK_NOISE", 0);
            n7 = this.hasClientProperty(jComponent, "CLIENT_PROPERTY_LIGHT_NOISE", 0);
            if (n5 == Integer.MAX_VALUE && n6 == Integer.MAX_VALUE && n7 == Integer.MAX_VALUE) {
                return;
            }
            border = jComponent.getBorder();
        }
        int n8 = component.getLocationOnScreen().x;
        int n9 = component.getLocationOnScreen().y;
        boolean bl = false;
        if (border instanceof FueledTitledBorder) {
            bl = true;
        }
        if (bl) {
            JScrollPane jScrollPane = this.isInsideScrollPane(component);
            if (jScrollPane != null) {
                this.drawImage(graphics, this.getIndexedImage(1, n7, n6, n5), n, n2, n3, n4, n8, n9);
                Image image = this.getIndexedImage(0, n7, n6, n5);
                if (n3 > 32 && n4 > 32) {
                    this.drawImage(graphics, image, n + 5, n2, n3 - 10, 2, n8, n9);
                    this.drawImage(graphics, image, n + 4, n2 + 2, n3 - 8, 2, n8, n9);
                    this.drawImage(graphics, image, n + 2, n2 + 4, n3 - 4, 2, n8, n9);
                    this.drawImage(graphics, image, n, n2 + 6, n3, n4 - 12, n8, n9);
                    this.drawImage(graphics, image, n + 2, n4 - 6, n3 - 4, 2, n8, n9);
                    this.drawImage(graphics, image, n + 4, n4 - 4, n3 - 8, 2, n8, n9);
                    this.drawImage(graphics, image, n + 5, n4 - 10, n3 - 10, 2, n8, n9);
                } else {
                    this.drawImage(graphics, image, n, n2, n3, n4, n8, n9);
                }
            } else {
                this.drawImage(graphics, this.getIndexedImage(1, n7, n6, n5), n, n2, n3, n4, n8, n9);
                RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2, n3, n4, 16.0f, 16.0f);
                graphics.setClip(float_);
                this.drawImage(graphics, this.getIndexedImage(0, n7, n6, n5), n, n2, n3, n4, n8, n9);
            }
        } else {
            this.drawImage(graphics, this.getIndexedImage(0, n7, n6, n5), n, n2, n3, n4, n8, n9);
        }
    }

    private void drawImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        if (image == null) {
            return;
        }
        int n7 = n3 / 100;
        int n8 = n4 / 100;
        for (int i = 0; i <= n7; ++i) {
            for (int j = 0; j <= n8; ++j) {
                int n9 = Math.min(100, n3 - i * 100);
                int n10 = Math.min(100, n4 - j * 100);
                graphics.drawImage(image, n + i * 100, n2 + j * 100, n9, n10, null);
            }
        }
    }

    private Image getIndexedImage(int n, int n2, int n3, int n4) {
        Image image = null;
        int[] nArray = new int[]{n2, n3, n4};
        Arrays.sort(nArray);
        int n5 = nArray[n];
        if (n5 == Integer.MAX_VALUE) {
            image = null;
        }
        if (n2 == n5) {
            image = this.watermarkLightImage;
        } else if (n3 == n5) {
            image = this.watermarkDarkImage;
        } else if (n4 == n5) {
            image = this.watermarkDarkDarkImage;
        }
        return image;
    }

    @Override
    public boolean updateWatermarkImage(SubstanceSkin substanceSkin) {
        GraphicsDevice[] graphicsDeviceArray;
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            rectangle = rectangle.union(graphicsConfiguration.getBounds());
        }
        int n = 100;
        int n2 = 100;
        this.watermarkDarkDarkImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = (Graphics2D)this.watermarkDarkDarkImage.getGraphics().create();
        boolean bl = this.drawWatermarkImage(substanceSkin, graphics2D, 0, 0, n, n2, false, ThemeMediator.CURRENT_THEME.getCustomUI().getDarkDarkNoise());
        graphics2D.dispose();
        this.watermarkDarkImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        graphics2D = (Graphics2D)this.watermarkDarkImage.getGraphics().create();
        bl &= this.drawWatermarkImage(substanceSkin, graphics2D, 0, 0, n, n2, false, ThemeMediator.CURRENT_THEME.getCustomUI().getDarkNoise());
        graphics2D.dispose();
        this.watermarkLightImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        graphics2D = (Graphics2D)this.watermarkLightImage.getGraphics().create();
        graphics2D.dispose();
        return bl &= this.drawWatermarkImage(substanceSkin, graphics2D, 0, 0, n, n2, false, ThemeMediator.CURRENT_THEME.getCustomUI().getLightNoise());
    }

    @Override
    public void previewWatermark(Graphics graphics, SubstanceSkin substanceSkin, int n, int n2, int n3, int n4) {
    }

    @Override
    public void dispose() {
        this.watermarkDarkDarkImage = null;
        this.watermarkDarkImage = null;
        this.watermarkLightImage = null;
    }

    private boolean drawWatermarkImage(SubstanceSkin substanceSkin, Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl, Color color) {
        graphics2D.drawImage((Image)this.getNoiseImage(substanceSkin, n3, n4, true, color), n, n2, null);
        return true;
    }

    public BufferedImage getNoiseImage(SubstanceSkin substanceSkin, int n, int n2, boolean bl, Color color) {
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[n3] = this.filterRGB(j, i, color.getRGB());
                ++n3;
            }
        }
        return bufferedImage;
    }

    private int filterRGB(int n, int n2, int n3) {
        if (this.randomNumbers.nextFloat() <= this.density) {
            int n4 = n3 & 0xFF000000;
            int n5 = n3 >> 16 & 0xFF;
            int n6 = n3 >> 8 & 0xFF;
            int n7 = n3 & 0xFF;
            int n8 = (int)(this.randomNumbers.nextGaussian() * (double)this.amount);
            n5 = FueledSkinWatermark.clip(n5 + n8);
            n6 = FueledSkinWatermark.clip(n6 + n8);
            n7 = FueledSkinWatermark.clip(n7 + n8);
            return n4 | n5 << 16 | n6 << 8 | n7;
        }
        return n3;
    }

    private static int clip(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }

    private int hasClientProperty(JComponent jComponent, String string, int n) {
        Boolean bl = (Boolean)jComponent.getClientProperty(string);
        if (bl != null) {
            return bl != false ? n : Integer.MAX_VALUE;
        }
        if (jComponent.getParent() instanceof JComponent) {
            int n2 = this.hasClientProperty((JComponent)jComponent.getParent(), string, n);
            return n2 != Integer.MAX_VALUE ? n2 + 1 : Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private JScrollPane isInsideScrollPane(Component component) {
        if (component.getParent() instanceof JScrollPane) {
            return (JScrollPane)component.getParent();
        }
        return component.getParent() != null && component.getParent() instanceof Component ? this.isInsideScrollPane(component.getParent()) : null;
    }
}

