/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes.fueled;

import com.limegroup.gnutella.gui.themes.fueled.NoiseFactory;
import com.limegroup.gnutella.gui.themes.fueled.NoiseFilter;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceNoiseWatermark
implements SubstanceWatermark {
    private Image watermarkImage = null;
    protected String displayName;
    protected double xFactor;
    protected double yFactor;
    protected boolean hasConstantZ;
    protected NoiseFilter noiseFilter;
    protected boolean toBlur;

    public SubstanceNoiseWatermark(String string, double d, double d2, boolean bl, NoiseFilter noiseFilter, boolean bl2) {
        this.displayName = string;
        this.xFactor = d;
        this.yFactor = d2;
        this.hasConstantZ = bl;
        this.noiseFilter = noiseFilter;
        this.toBlur = bl2;
    }

    @Override
    public void drawWatermarkImage(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        if (!component.isShowing()) {
            return;
        }
        int n5 = component.getLocationOnScreen().x;
        int n6 = component.getLocationOnScreen().y;
        graphics.drawImage(this.watermarkImage, n, n2, n + n3, n2 + n4, n + n5, n2 + n6, n + n5 + n3, n2 + n6 + n4, null);
    }

    @Override
    public boolean updateWatermarkImage(SubstanceSkin substanceSkin) {
        GraphicsDevice[] graphicsDeviceArray;
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            rectangle = rectangle.union(graphicsConfiguration.getBounds());
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        this.watermarkImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = (Graphics2D)this.watermarkImage.getGraphics().create();
        boolean bl = this.drawWatermarkImage(substanceSkin, graphics2D, 0, 0, n, n2, false);
        graphics2D.dispose();
        return bl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void previewWatermark(Graphics graphics, SubstanceSkin substanceSkin, int n, int n2, int n3, int n4) {
        this.drawWatermarkImage(substanceSkin, (Graphics2D)graphics, n, n2, n3, n4, true);
    }

    private boolean drawWatermarkImage(SubstanceSkin substanceSkin, Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        SubstanceColorScheme substanceColorScheme = substanceSkin.getWatermarkColorScheme();
        if (bl) {
            graphics2D.drawImage((Image)NoiseFactory.getNoiseImage(substanceSkin, n3, n4, this.xFactor, this.yFactor, this.hasConstantZ, this.noiseFilter, this.toBlur, true), n, n2, null);
        } else {
            int n5 = substanceColorScheme.isDark() ? 200 : 140;
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)n5 / 255.0f));
            graphics2D.drawImage((Image)NoiseFactory.getNoiseImage(substanceSkin, n3, n4, this.xFactor, this.yFactor, this.hasConstantZ, this.noiseFilter, this.toBlur, false), n, n2, null);
        }
        return true;
    }

    @Override
    public void dispose() {
        this.watermarkImage = null;
    }
}

