/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes.setters;

import com.frostwire.gui.components.RangeSlider;
import com.limegroup.gnutella.gui.themes.SkinComboBoxUI;
import com.limegroup.gnutella.gui.themes.SkinCustomUI;
import com.limegroup.gnutella.gui.themes.SkinListUI;
import com.limegroup.gnutella.gui.themes.SkinProgressBarUI;
import com.limegroup.gnutella.gui.themes.SkinRangeSliderUI;
import com.limegroup.gnutella.gui.themes.SkinTabbedPaneUI;
import com.limegroup.gnutella.gui.themes.SkinTableUI;
import com.limegroup.gnutella.gui.themes.SkinTextAreaUI;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSetter;
import com.limegroup.gnutella.gui.themes.fueled.FueledCustomUI;
import com.limegroup.gnutella.gui.themes.setters.SubstanceCustomUI;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Font;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.OSUtils;
import org.pushingpixels.lafwidget.utils.LookUtils;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.fonts.SubstanceFontUtilities;
import org.pushingpixels.substance.internal.ui.SubstanceCheckBoxMenuItemUI;
import org.pushingpixels.substance.internal.ui.SubstanceMenuBarUI;
import org.pushingpixels.substance.internal.ui.SubstanceMenuItemUI;
import org.pushingpixels.substance.internal.ui.SubstanceMenuUI;
import org.pushingpixels.substance.internal.ui.SubstancePopupMenuSeparatorUI;
import org.pushingpixels.substance.internal.ui.SubstancePopupMenuUI;
import org.pushingpixels.substance.internal.ui.SubstanceRadioButtonMenuItemUI;
import org.pushingpixels.substance.internal.ui.SubstanceTreeUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceThemeSetter
implements ThemeSetter {
    private static final Log LOG = LogFactory.getLog(SubstanceThemeSetter.class);
    private final String _name;
    private final String _skinClassName;
    private final SkinCustomUI customUI;
    private final float LINUX_SCALED_FONT_POLICY_FACTOR = 0.87f;
    private final float WINDOWS_SCALED_FONT_POLICY_FACTOR = 0.92f;
    private final float MAC_SCALED_FONT_POLICY_FACTOR = 0.87f;
    public static final SubstanceThemeSetter SEA_GLASS = new SubstanceThemeSetter("Sea Glass", "com.limegroup.gnutella.gui.themes.SeaGlassSkin");
    public static final SubstanceThemeSetter FUELED = new SubstanceThemeSetter("Fueled", "com.limegroup.gnutella.gui.themes.fueled.FueledSkin", new FueledCustomUI());
    public static final SubstanceThemeSetter AUTUMN = new SubstanceThemeSetter("Autumn", "org.pushingpixels.substance.api.skin.AutumnSkin");
    public static final SubstanceThemeSetter BUSINESS_BLACK_STEEL = new SubstanceThemeSetter("Business Black Steel", "org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin");
    public static final SubstanceThemeSetter BUSINESS_BLUE_STEEL = new SubstanceThemeSetter("Business Blue Steel", "org.pushingpixels.substance.api.skin.BusinessBlueSteelSkin");
    public static final SubstanceThemeSetter BUSINESS = new SubstanceThemeSetter("Business", "org.pushingpixels.substance.api.skin.BusinessSkin");
    public static final SubstanceThemeSetter CHALLENGER_DEEP = new SubstanceThemeSetter("Challenger Deep", "org.pushingpixels.substance.api.skin.ChallengerDeepSkin");
    public static final SubstanceThemeSetter CREME_COFFEE = new SubstanceThemeSetter("Creme Coffee", "org.pushingpixels.substance.api.skin.CremeCoffeeSkin");
    public static final SubstanceThemeSetter CREME = new SubstanceThemeSetter("Creme", "org.pushingpixels.substance.api.skin.CremeSkin");
    public static final SubstanceThemeSetter DUST_COFFEE = new SubstanceThemeSetter("Dust Coffee", "org.pushingpixels.substance.api.skin.DustCoffeeSkin");
    public static final SubstanceThemeSetter DUST = new SubstanceThemeSetter("Dust", "org.pushingpixels.substance.api.skin.DustSkin");
    public static final SubstanceThemeSetter EMERALD_DUSK = new SubstanceThemeSetter("Emerald Dusk", "org.pushingpixels.substance.api.skin.EmeraldDuskSkin");
    public static final SubstanceThemeSetter GEMINI = new SubstanceThemeSetter("Gemini", "org.pushingpixels.substance.api.skin.GeminiSkin");
    public static final SubstanceThemeSetter GRAPHITE_AQUA = new SubstanceThemeSetter("Graphite Aqua", "org.pushingpixels.substance.api.skin.GraphiteAquaSkin");
    public static final SubstanceThemeSetter GRAPHITE_GLASS = new SubstanceThemeSetter("Graphite Glass", "org.pushingpixels.substance.api.skin.GraphiteGlassSkin");
    public static final SubstanceThemeSetter GRAPHITE = new SubstanceThemeSetter("Graphite", "org.pushingpixels.substance.api.skin.GraphiteSkin");
    public static final SubstanceThemeSetter MAGELLAN = new SubstanceThemeSetter("Magellan", "org.pushingpixels.substance.api.skin.MagellanSkin");
    public static final SubstanceThemeSetter MARINER = new SubstanceThemeSetter("Mariner", "org.pushingpixels.substance.api.skin.MarinerSkin");
    public static final SubstanceThemeSetter MIST_AQUA = new SubstanceThemeSetter("Mist Aqua", "org.pushingpixels.substance.api.skin.MistAquaSkin");
    public static final SubstanceThemeSetter MIST_SILVER = new SubstanceThemeSetter("Mist Silver", "org.pushingpixels.substance.api.skin.MistSilverSkin");
    public static final SubstanceThemeSetter MODERATE = new SubstanceThemeSetter("Moderate", "org.pushingpixels.substance.api.skin.ModerateSkin");
    public static final SubstanceThemeSetter NEBULA_BRICK_WALL = new SubstanceThemeSetter("Nebula Brick Wall", "org.pushingpixels.substance.api.skin.NebulaBrickWallSkin");
    public static final SubstanceThemeSetter NEBULA = new SubstanceThemeSetter("Nebula", "org.pushingpixels.substance.api.skin.NebulaSkin");
    public static final SubstanceThemeSetter OFFICE_BLACK_2007 = new SubstanceThemeSetter("Office Black 2007", "org.pushingpixels.substance.api.skin.OfficeBlack2007Skin");
    public static final SubstanceThemeSetter OFFICE_BLUE_2007 = new SubstanceThemeSetter("Office Blue 2007", "org.pushingpixels.substance.api.skin.OfficeBlue2007Skin");
    public static final SubstanceThemeSetter OFFICE_SILVER_2007 = new SubstanceThemeSetter("Office Silver 2007", "org.pushingpixels.substance.api.skin.OfficeSilver2007Skin");
    public static final SubstanceThemeSetter RAVEN = new SubstanceThemeSetter("Raven", "org.pushingpixels.substance.api.skin.RavenSkin");
    public static final SubstanceThemeSetter SAHARA = new SubstanceThemeSetter("Sahara", "org.pushingpixels.substance.api.skin.SaharaSkin");
    public static final SubstanceThemeSetter TWILIGHT = new SubstanceThemeSetter("Twilight", "org.pushingpixels.substance.api.skin.TwilightSkin");

    private SubstanceThemeSetter(String string, String string2, SkinCustomUI skinCustomUI) {
        this._name = string;
        this._skinClassName = string2;
        this.customUI = skinCustomUI;
    }

    private SubstanceThemeSetter(String string, String string2) {
        this(string, string2, new SubstanceCustomUI());
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void apply() {
        SubstanceLookAndFeel.setSkin(this._skinClassName);
        ThemeMediator.applyCommonSkinUI();
        float f = 0.92f;
        if (OSUtils.isMacOSX()) {
            f = 0.87f;
        } else if (OSUtils.isLinux()) {
            f = 0.87f;
        }
        if (LookUtils.IS_OS_WINDOWS) {
            this.fixWindowsOSFont();
        } else if (LookUtils.IS_OS_LINUX) {
            this.fixLinuxOSFont();
        }
        SubstanceLookAndFeel.setFontPolicy(SubstanceFontUtilities.getScaledFontPolicy(f));
        UIManager.put("Tree.leafIcon", UIManager.getIcon("Tree.closedIcon"));
        UIManager.put("SplitPane.border", BorderFactory.createEmptyBorder());
        if (!OSUtils.isMacOSX()) {
            UIManager.put("Table.focusRowHighlightBorder", UIManager.get("Table.focusCellHighlightBorder"));
        }
        UIManager.put("Table.focusCellHighlightBorder", BorderFactory.createEmptyBorder(1, 1, 1, 1));
        Font font = UIManager.getFont("Table.font");
        FontUIResource fontUIResource = new FontUIResource(font.getName(), 1, font.getSize());
        UIManager.put("Table.font.bold", fontUIResource);
        UIManager.put("Tree.rowHeight", 0);
    }

    @Override
    public SkinCustomUI getCustomUI() {
        return this.customUI;
    }

    @Override
    public ComponentUI createCheckBoxMenuItemUI(JComponent jComponent) {
        return SubstanceCheckBoxMenuItemUI.createUI(jComponent);
    }

    @Override
    public ComponentUI createMenuBarUI(JComponent jComponent) {
        return SubstanceMenuBarUI.createUI(jComponent);
    }

    @Override
    public ComponentUI createMenuItemUI(JComponent jComponent) {
        return SubstanceMenuItemUI.createUI(jComponent);
    }

    @Override
    public ComponentUI createMenuUI(JComponent jComponent) {
        return SubstanceMenuUI.createUI(jComponent);
    }

    @Override
    public ComponentUI createPopupMenuSeparatorUI(JComponent jComponent) {
        return SubstancePopupMenuSeparatorUI.createUI(jComponent);
    }

    @Override
    public ComponentUI createPopupMenuUI(JComponent jComponent) {
        return SubstancePopupMenuUI.createUI(jComponent);
    }

    @Override
    public ComponentUI createRadioButtonMenuItemUI(JComponent jComponent) {
        return SubstanceRadioButtonMenuItemUI.createUI(jComponent);
    }

    @Override
    public ComponentUI createTextAreaUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SkinTextAreaUI(jComponent);
    }

    @Override
    public ComponentUI createListUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SkinListUI();
    }

    @Override
    public ComponentUI createComboBoxUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SkinComboBoxUI((JComboBox)jComponent);
    }

    @Override
    public ComponentUI createTreeUI(JComponent jComponent) {
        return SubstanceTreeUI.createUI(jComponent);
    }

    @Override
    public ComponentUI createTableUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SkinTableUI();
    }

    @Override
    public ComponentUI createTabbedPaneUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SkinTabbedPaneUI((JTabbedPane)jComponent);
    }

    @Override
    public ComponentUI createRangeSliderUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SkinRangeSliderUI((RangeSlider)jComponent);
    }

    @Override
    public ComponentUI createProgressBarUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SkinProgressBarUI();
    }

    private void fixWindowsOSFont() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Method method = Toolkit.class.getDeclaredMethod("setDesktopProperty", String.class, Object.class);
            method.setAccessible(true);
            String string = null;
            String string2 = ApplicationSettings.getLanguage();
            if (string2 != null) {
                if (string2.startsWith("ja")) {
                    string = "Meiryo";
                } else if (string2.startsWith("ko")) {
                    string = "Malgun Gothic";
                } else if (string2.startsWith("zh")) {
                    string = "Microsoft JhengHei";
                } else if (string2.startsWith("he")) {
                    string = "Gisha";
                } else if (string2.startsWith("th")) {
                    string = "Leelawadee";
                }
            }
            if (string != null) {
                Font font = new Font(string, 0, 12);
                method.invoke((Object)toolkit, "win.icon.font", font);
                SubstanceLookAndFeel.setFontPolicy(SubstanceFontUtilities.getDefaultFontPolicy());
            }
        }
        catch (Throwable throwable) {
            LOG.error("Error fixing font", throwable);
        }
    }

    private void fixLinuxOSFont() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Method method = Toolkit.class.getDeclaredMethod("setDesktopProperty", String.class, Object.class);
            method.setAccessible(true);
            String string = null;
            String string2 = ApplicationSettings.getLanguage();
            if (string2 != null) {
                if (string2.startsWith("ja")) {
                    string = "Meiryo";
                } else if (string2.startsWith("ko")) {
                    string = "Malgun Gothic";
                } else if (string2.startsWith("zh")) {
                    string = "Microsoft JhengHei";
                } else if (string2.startsWith("he")) {
                    string = "Gisha";
                } else if (string2.startsWith("th")) {
                    string = "Leelawadee";
                }
            }
            if (string != null) {
                string = "Dialog";
                method.invoke((Object)toolkit, "gnome.Gtk/FontName", string);
                SubstanceLookAndFeel.setFontPolicy(SubstanceFontUtilities.getDefaultFontPolicy());
            }
        }
        catch (Throwable throwable) {
            LOG.error("Error fixing font", throwable);
        }
    }
}

