/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.trees;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeModel
implements TreeModel {
    protected transient EventListenerList listenerList = new EventListenerList();
    protected StringBuilder root;

    public AbstractTreeModel(String string) {
        this.root = new StringBuilder(string);
    }

    public void changeRootText(String string) {
        this.root.setLength(0);
        this.root.append(string);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    protected void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            ((TreeModelListener)objectArray[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            ((TreeModelListener)objectArray[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            ((TreeModelListener)objectArray[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    @Override
    public abstract Object getChild(Object var1, int var2);

    @Override
    public abstract int getChildCount(Object var1);

    @Override
    public abstract int getIndexOfChild(Object var1, Object var2);

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public abstract boolean isLeaf(Object var1);

    public void reload() {
        Object[] objectArray = new Object[]{this.getRoot()};
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, objectArray));
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }
}

