/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.LimeWireSettings;
import java.util.HashMap;
import java.util.Map;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.Setting;
import org.limewire.setting.SettingsFactory;

public final class TablesHandlerSettings
extends LimeWireSettings {
    private static final TablesHandlerSettings INSTANCE = new TablesHandlerSettings();
    private static final SettingsFactory FACTORY = INSTANCE.getFactory();
    private static final String WIDTH = "_WIDTH";
    private static final String ORDER = "_ORDER";
    private static final String VISBL = "_VISIBLE";
    private static final Map<String, Setting> SETS = new HashMap<String, Setting>();

    public static TablesHandlerSettings instance() {
        return INSTANCE;
    }

    private TablesHandlerSettings() {
        super("tables.props", "FrostWire tables file");
    }

    public static IntSetting getWidth(String string, int n) {
        return TablesHandlerSettings.getSetting(string + WIDTH, n);
    }

    public static IntSetting getOrder(String string, int n) {
        return TablesHandlerSettings.getSetting(string + ORDER, n);
    }

    public static BooleanSetting getVisibility(String string, boolean bl) {
        return TablesHandlerSettings.getSetting(string + VISBL, bl);
    }

    private static IntSetting getSetting(String string, int n) {
        IntSetting intSetting = (IntSetting)SETS.get(string);
        if (intSetting == null) {
            intSetting = FACTORY.createIntSetting(string, n);
            SETS.put(string, intSetting);
        }
        return intSetting;
    }

    private static BooleanSetting getSetting(String string, boolean bl) {
        BooleanSetting booleanSetting = (BooleanSetting)SETS.get(string);
        if (booleanSetting == null) {
            booleanSetting = FACTORY.createBooleanSetting(string, bl);
            SETS.put(string, booleanSetting);
        }
        return booleanSetting;
    }
}

