/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.EncodingUtils;
import com.limegroup.gnutella.util.Tagged;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.limewire.setting.SettingsFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;
import org.limewire.util.VersionUtils;

public final class FrostWireUtils {
    private static final String FROSTWIRE_VERSION = "5.3.9";
    private static boolean temporaryDirectoryInUse;

    private FrostWireUtils() {
    }

    public static String getFrostWireVersion() {
        return FROSTWIRE_VERSION;
    }

    public static String addLWInfoToUrl(String string, byte[] byArray) {
        string = string.indexOf(63) == -1 ? string + "?" : string + "&";
        string = string + "guid=" + EncodingUtils.encode(new GUID(byArray).toHexString()) + "&lang=" + EncodingUtils.encode(ApplicationSettings.getLanguage()) + "&lv=" + EncodingUtils.encode(FrostWireUtils.getFrostWireVersion()) + "&jv=" + EncodingUtils.encode(VersionUtils.getJavaVersion()) + "&os=" + EncodingUtils.encode(OSUtils.getOS()) + "&osv=" + EncodingUtils.encode(OSUtils.getOSVersion());
        return string;
    }

    public static boolean isTemporaryDirectoryInUse() {
        return temporaryDirectoryInUse;
    }

    public static boolean hasSettingsLoadSaveFailures() {
        return SettingsFactory.hasLoadSaveFailure();
    }

    public static void setTemporaryDirectoryInUse(boolean bl) {
        temporaryDirectoryInUse = bl;
    }

    public static void resetSettingsLoadSaveFailures() {
        SettingsFactory.resetLoadSaveFailure();
    }

    public static String getFrostWireJarPath() {
        return new File(FrostWireUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
    }

    public static File getFrostWireRootFolder() {
        String string = null;
        if (OSUtils.isWindowsVista() || OSUtils.isWindows7()) {
            string = SystemUtils.getSpecialPath(SystemUtils.SpecialLocations.DOWNLOADS);
        } else if (OSUtils.isWindows()) {
            string = SystemUtils.getSpecialPath(SystemUtils.SpecialLocations.DOCUMENTS);
        }
        if (string == null || "".equals(string)) {
            string = CommonUtils.getUserHomeDir().getPath();
        }
        return new File(string, "FrostWire");
    }

    public static Tagged<String> getArg(Map<String, String> map, String string, String string2) {
        String string3 = map.get(string);
        if (string3 == null || string3.equals("")) {
            return new Tagged<String>("missing.callback.parameter", false);
        }
        String string4 = string3;
        try {
            string4 = URLDecoder.decode(string3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Tagged<String>(string4, true);
    }

    public static <T> void map(List<T> list, IndexedMapFunction<T> indexedMapFunction) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            indexedMapFunction.map(i, list.get(i));
        }
    }

    public static Set<File> getFrostWire4SaveDirectories() {
        HashSet<File> hashSet = new HashSet<File>();
        try {
            String[] stringArray;
            File file = new File(CommonUtils.getFrostWire4UserSettingsDir(), "frostwire.props");
            Properties properties = new Properties();
            properties.load(new FileInputStream(file));
            if (properties.containsKey("DIRECTORY_FOR_SAVING_FILES")) {
                hashSet.add(new File(properties.getProperty("DIRECTORY_FOR_SAVING_FILES")));
            }
            for (String string : stringArray = new String[]{"document", "application", "audio", "video", "image"}) {
                String string2 = "DIRECTORY_FOR_SAVING_" + string + "_FILES";
                if (!properties.containsKey(string2)) continue;
                hashSet.add(new File(properties.getProperty(string2)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashSet;
    }

    public static File getUserMusicFolder() {
        File file = null;
        file = OSUtils.isMacOSX() ? new File(CommonUtils.getUserHomeDir(), "Music") : (OSUtils.isWindowsXP() ? new File(CommonUtils.getUserHomeDir(), "My Documents" + File.separator + "My Music") : (OSUtils.isWindowsVista() || OSUtils.isWindows7() ? new File(CommonUtils.getUserHomeDir(), "Music") : (OSUtils.isUbuntu() ? new File(CommonUtils.getUserHomeDir(), "Music") : new File(CommonUtils.getUserHomeDir(), "Music"))));
        return file;
    }

    public static interface IndexedMapFunction<T> {
        public void map(int var1, T var2);
    }
}

