/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.limewire.util.StringUtils;

public final class HTTPUtils {
    private static final String CRLF = "\r\n";
    private static final String COLON_SPACE = ": ";
    public static final String COLON = ":";

    private HTTPUtils() {
    }

    public static String createHeader(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 4);
        return stringBuilder.append(string).append(COLON_SPACE).append(string2).append(CRLF).toString();
    }

    public static String parseValue(String string) throws IOException {
        int n = string.indexOf("=");
        if (n == -1 || n >= string.length() - 1) {
            throw new IOException("invalid keyValuePair: " + string);
        }
        return string.substring(n + 1).trim();
    }

    public static String getDateValue() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date());
    }

    public static String encode(String string, String string2) throws IOException {
        return StringUtils.replace(URLEncoder.encode(string, string2), "+", "%20");
    }
}

