/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.settings.URLHandlerSettings;
import com.limegroup.gnutella.util.LaunchException;
import com.limegroup.gnutella.util.LimeProcess;
import com.limegroup.gnutella.util.QuotedStringTokenizer;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.SystemUtils;

public final class Launcher {
    private static boolean _macClassesLoadedSuccessfully = true;
    private static Method _openURL;

    private Launcher() {
    }

    public static int openURL(String string) throws IOException {
        if (OSUtils.isWindows()) {
            return Launcher.openURLWindows(string);
        }
        if (OSUtils.isMacOSX()) {
            Launcher.openURLMac(string);
        } else {
            Launcher.launchFileOther(string);
        }
        return -1;
    }

    private static int openURLWindows(String string) throws IOException {
        string = string.replace("&", "^&");
        String[] stringArray = new String[]{"cmd.exe", "/c", "start", string};
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        processBuilder.start();
        return 0;
    }

    private static void openURLMac(String string) throws IOException {
        if (!_macClassesLoadedSuccessfully) {
            throw new IOException();
        }
        try {
            Object[] objectArray = new Object[]{string};
            _openURL.invoke(null, objectArray);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new IOException();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new IOException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException();
        }
    }

    public static LimeProcess launchFile(File file) throws IOException, SecurityException {
        List<String> list = Arrays.asList("exe", "vbs", "lnk", "bat", "sys", "com", "js", "scpt");
        if (file.isFile() && list.contains(FileUtils.getFileExtension(file))) {
            throw new SecurityException();
        }
        String string = file.getCanonicalPath();
        if (OSUtils.isWindows()) {
            Launcher.launchFileWindows(string);
            return null;
        }
        if (OSUtils.isMacOSX()) {
            return Launcher.launchFileMacOSX(string);
        }
        return Launcher.launchFileOther(string);
    }

    public static void launchExplorer(File file) throws IOException, SecurityException {
        if (OSUtils.isWindows()) {
            String string = file.getPath();
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (file.isDirectory()) {
                LimeProcess.exec(new String[]{"explorer", string});
            } else {
                LimeProcess.exec(new String[]{"explorer", "/select,", string});
            }
        } else if (OSUtils.isMacOSX()) {
            LimeProcess.exec(Launcher.selectFileCommand(file));
        } else if (OSUtils.isLinux() && file.isDirectory()) {
            Desktop.getDesktop().open(file);
        }
    }

    public static int launchFileWindows(String string) throws IOException {
        try {
            return SystemUtils.openFile(string);
        }
        catch (IOException iOException) {
            throw new LaunchException(iOException, string);
        }
    }

    private static LimeProcess launchFileMacOSX(String string) throws IOException {
        return LimeProcess.exec(new String[]{"open", string});
    }

    private static String[] selectFileCommand(File file) {
        String string = null;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        String[] stringArray = new String[]{"osascript", "-e", "set unixPath to \"" + string + "\"", "-e", "set hfsPath to POSIX file unixPath", "-e", "tell application \"Finder\"", "-e", "activate", "-e", "select hfsPath", "-e", "end tell"};
        return stringArray;
    }

    private static void loadMacClasses() throws IOException {
        try {
            Class<?> clazz = Class.forName("net.roydesign.mac.MRJAdapter");
            _openURL = clazz.getDeclaredMethod("openURL", String.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException();
        }
        catch (SecurityException securityException) {
            throw new IOException();
        }
    }

    private static LimeProcess launchFileOther(String string) throws IOException {
        String string2 = MediaType.getAudioMediaType().matches(string) ? URLHandlerSettings.AUDIO_PLAYER.getValue() : (MediaType.getVideoMediaType().matches(string) ? URLHandlerSettings.VIDEO_PLAYER.getValue() : (MediaType.getImageMediaType().matches(string) ? URLHandlerSettings.IMAGE_VIEWER.getValue() : URLHandlerSettings.BROWSER.getValue()));
        QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string2);
        String[] stringArray = new String[quotedStringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = StringUtils.replace(quotedStringTokenizer.nextToken(), "$URL$", string);
        }
        return LimeProcess.exec(stringArray);
    }

    static {
        if (OSUtils.isMacOSX()) {
            try {
                Launcher.loadMacClasses();
            }
            catch (IOException iOException) {
                _macClassesLoadedSuccessfully = false;
            }
        }
    }
}

