/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.Interpretor;
import irc.NotEnoughParametersException;
import irc.RootInterpretor;
import irc.Server;
import irc.Source;
import java.util.Enumeration;

public class BasicInterpretor
extends RootInterpretor
implements Interpretor {
    public BasicInterpretor(IRCConfiguration iRCConfiguration) {
        this(iRCConfiguration, null);
    }

    public BasicInterpretor(IRCConfiguration iRCConfiguration, Interpretor interpretor) {
        super(iRCConfiguration, interpretor);
    }

    @Override
    protected void handleCommand(Source source, String string, String[] stringArray, String[] stringArray2) {
        try {
            Server server = source.getServer();
            if (string.equals("echo")) {
                this.test(string, stringArray, 1);
                source.report(stringArray2[1]);
            } else if (string.equals("sleep")) {
                this.test(string, stringArray, 1);
                try {
                    int n = new Integer(stringArray[1]);
                    Thread.sleep(n);
                }
                catch (Exception exception) {}
            } else if (string.equals("me")) {
                this.test(string, stringArray, 1);
                this.sendString(source, "/ctcp action " + stringArray2[1]);
            } else if (string.equals("action")) {
                this.test(string, stringArray, 1);
                this.sendString(source, "/ctcp action " + stringArray2[1]);
            } else if (string.equals("play")) {
                this.test(string, stringArray, 1);
                this._ircConfiguration.getAudioConfiguration().play(stringArray[1]);
            } else if (string.equals("url")) {
                this.test(string, stringArray, 1);
                if (stringArray.length >= 3) {
                    this._ircConfiguration.getURLHandler().openURL(stringArray[1], stringArray[2]);
                } else {
                    this._ircConfiguration.getURLHandler().openURL(stringArray[1]);
                }
            } else if (string.equals("clear")) {
                source.clear();
            } else if (string.equals("leave")) {
                source.leave();
            } else if (string.equals("msg")) {
                this.test(string, stringArray, 2);
                boolean bl = false;
                Enumeration<Source> enumeration = server.getSources();
                while (enumeration.hasMoreElements()) {
                    Source source2 = enumeration.nextElement();
                    if (!source2.getName().equals(stringArray[1])) continue;
                    this.say(source2, stringArray2[2]);
                    bl = true;
                }
                if (!bl) {
                    server.say(stringArray[1], stringArray2[2]);
                }
            } else {
                super.handleCommand(source, string, stringArray, stringArray2);
            }
        }
        catch (NotEnoughParametersException notEnoughParametersException) {
            source.report(" *** Invalid command format: " + notEnoughParametersException.getMessage());
        }
    }
}

