/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.ChanListListener;
import irc.ChannelInfo;
import irc.IRCConfiguration;
import irc.IRCServer;
import irc.IRCSource;
import irc.ListenerGroup;
import java.util.Vector;

public class ChanList
extends IRCSource {
    private ListenerGroup _listeners;
    private Vector<ChannelInfo> _channels;
    private String _name;
    private boolean _running;
    private int _ignored;

    public ChanList(IRCConfiguration iRCConfiguration, IRCServer iRCServer, String string) {
        super(iRCConfiguration, iRCServer);
        this._name = string;
        this._server = iRCServer;
        this._listeners = new ListenerGroup();
        this._channels = new Vector();
        this._running = false;
    }

    @Override
    public String getType() {
        return "ChanList";
    }

    @Override
    public String getName() {
        return this._name;
    }

    public ChannelInfo[] getChannels() {
        ChannelInfo[] channelInfoArray = new ChannelInfo[this._channels.size()];
        for (int i = 0; i < this._channels.size(); ++i) {
            channelInfoArray[i] = this._channels.elementAt(i);
        }
        return channelInfoArray;
    }

    public int getChannelCount() {
        return this._channels.size();
    }

    public int getIgnoredChannelCount() {
        return this._ignored;
    }

    public void addChannel(ChannelInfo channelInfo) {
        if (this._channels.size() > 1024 && channelInfo.userCount < 5) {
            ++this._ignored;
            return;
        }
        this._channels.insertElementAt(channelInfo, this._channels.size());
        this._listeners.sendEvent("channelAdded", channelInfo, this);
    }

    public void begin() {
        this._ignored = 0;
        this._running = true;
        this._channels = new Vector();
        this._listeners.sendEvent("channelBegin", this);
    }

    public void end() {
        this._running = false;
        this._listeners.sendEvent("channelEnd", this);
    }

    public void addChanListListener(ChanListListener chanListListener) {
        this._listeners.addListener(chanListListener);
    }

    public void removeChanListListeners(ChanListListener chanListListener) {
        this._listeners.removeListener(chanListListener);
    }

    @Override
    public void leave() {
        if (this._running) {
            return;
        }
        this.getIRCServer().leaveChanList(this._name);
    }

    @Override
    public boolean talkable() {
        return false;
    }

    @Override
    public boolean mayDefault() {
        return false;
    }
}

