/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.IRCInterpretor;
import irc.IRCServer;
import irc.NotEnoughParametersException;
import irc.Server;
import irc.Source;

public class ChannelInterpretor
extends IRCInterpretor {
    public ChannelInterpretor(IRCConfiguration iRCConfiguration) {
        super(iRCConfiguration);
    }

    private boolean isChannel(String string, Source source) {
        if (string.length() == 0) {
            return false;
        }
        Server server = source.getServer();
        if (server instanceof IRCServer) {
            char[] cArray = ((IRCServer)server).getChannelPrefixes();
            for (int i = 0; i < cArray.length; ++i) {
                if (string.charAt(0) != cArray[i]) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void handleCommand(Source source, String string, String[] stringArray, String[] stringArray2) {
        try {
            if (string.equals("part")) {
                if (stringArray.length == 1) {
                    this.sendString(source, "/part " + source.getName());
                } else if (this.isChannel(stringArray[1], source)) {
                    super.handleCommand(source, string, stringArray, stringArray2);
                } else {
                    this.sendString(source, "/part " + source.getName() + " " + stringArray2[1]);
                }
            } else if (string.equals("hop")) {
                this.sendString(source, "/part");
                this.sendString(source, "/join " + source.getName());
            } else if (string.equals("onotice")) {
                this.test(string, stringArray, 1);
                if (this.isChannel(stringArray[1], source)) {
                    super.handleCommand(source, string, stringArray, stringArray2);
                } else {
                    this.sendString(source, "/onotice " + source.getName() + " " + stringArray2[1]);
                }
            } else {
                super.handleCommand(source, string, stringArray, stringArray2);
            }
        }
        catch (NotEnoughParametersException notEnoughParametersException) {
            source.report("\u00032      *** Invalid command format: " + notEnoughParametersException.getMessage());
        }
    }
}

