/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.EventDispatcher;
import irc.EventItem;
import irc.LinkedList;

class DispatchThread
extends Thread {
    private LinkedList _list;
    private Object _manageLock = new Object();
    private boolean _terminated = false;
    private boolean _processing = false;

    public DispatchThread(String string) {
        super(string + " event dispatch thread");
        this._list = new LinkedList();
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventItem addEvent(Object object, String string, Object[] objectArray) {
        if (this._terminated) {
            return null;
        }
        EventItem eventItem = new EventItem(object, string, objectArray);
        Object object2 = this._manageLock;
        synchronized (object2) {
            this._list.addLast(eventItem);
            this._manageLock.notify();
        }
        return eventItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        do {
            EventItem eventItem;
            Object object = this._manageLock;
            synchronized (object) {
                if (this._list.size() > 0) {
                    eventItem = (EventItem)this._list.removeFirst();
                } else {
                    eventItem = null;
                    try {
                        this._manageLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                n = this._list.size();
            }
            if (eventItem == null) continue;
            this._processing = true;
            eventItem.resultException = null;
            try {
                eventItem.result = EventDispatcher.dispatchEventSyncEx(eventItem.target, eventItem.method, eventItem.params);
            }
            catch (Throwable throwable) {
                eventItem.resultException = throwable;
            }
            this._processing = false;
            object = eventItem.endLock;
            synchronized (object) {
                eventItem.resultAvailable = true;
                eventItem.endLock.notify();
            }
        } while (!this._terminated || n != 0);
    }

    public void terminate() {
        this._terminated = true;
        if (!this._processing) {
            this.interrupt();
        }
    }
}

