/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.AWTImageLoader;
import irc.CTCPInterpretor;
import irc.ConfigurationLoader;
import irc.DefaultInterpretor;
import irc.DefaultSource;
import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.IRCObject;
import irc.IRCServer;
import irc.Interpretor;
import irc.LocalFileHandler;
import irc.NullSoundHandler;
import irc.NullURLHandler;
import irc.ParameterProvider;
import irc.PluginManager;
import irc.Server;
import irc.ServerListener;
import irc.ServerManager;
import irc.Source;
import irc.StartupConfiguration;
import irc.StreamParameterProvider;
import irc.gui.GUISource;
import irc.gui.IRCInterface;
import irc.gui.IRCInterfaceListener;
import irc.ident.IdentListener;
import irc.ident.IdentWrapper;
import irc.plugin.Plugin;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class IRCApplication
extends IRCObject
implements ServerListener,
ServerManager,
IdentListener,
IRCInterfaceListener,
WindowListener,
ActionListener,
PluginManager {
    private DefaultSource _defaultSource;
    private Interpretor _inter;
    private IdentWrapper _ident;
    private StartupConfiguration _start;
    private IRCInterface _interface;
    private Vector<Plugin> _plugins;
    private Hashtable<String, Plugin> _pluginsTable;
    private JFrame _frame;
    private Container _container;
    private Hashtable<Server, Server> _servers;
    private Object _nickLock = new Object();

    public IRCApplication(IRCConfiguration iRCConfiguration, StartupConfiguration startupConfiguration, Container container) {
        super(iRCConfiguration);
        Object object;
        this._container = container;
        this._start = startupConfiguration;
        this._plugins = new Vector();
        this._pluginsTable = new Hashtable();
        String string = iRCConfiguration.getS("gui");
        try {
            object = Class.forName("irc.gui." + string + ".Interface");
            Constructor<?> constructor = ((Class)object).getDeclaredConstructor(iRCConfiguration.getClass());
            this._interface = (IRCInterface)constructor.newInstance(iRCConfiguration);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
            throw new Error("Unable to load interface " + string + " : " + invocationTargetException.getTargetException());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new Error("Unable to load interface " + string + " : " + throwable);
        }
        this._servers = new Hashtable();
        this._defaultSource = new DefaultSource(this._ircConfiguration);
        object = new DefaultInterpretor(this._ircConfiguration, this._start, this, this);
        this._defaultSource.setInterpretor((Interpretor)object);
    }

    public synchronized void init() {
        this.loadPlugin(this._interface);
        String[] stringArray = this._start.getPlugins();
        for (int i = 0; i < stringArray.length; ++i) {
            this.loadPlugin(stringArray[i]);
        }
        this._interface.addIRCInterfaceListener(this);
        if (this._container == null) {
            this._frame = new JFrame();
            this._frame.addWindowListener(this);
            if (this._interface.getComponent() != null) {
                this._frame.add(this._interface.getComponent());
            }
            this._frame.setFont(new Font("", 0, 12));
            this._frame.setSize(640, 400);
            this._frame.setVisible(true);
        } else {
            this._frame = null;
            this._container.removeAll();
            this._container.setLayout(new GridLayout(1, 1));
            if (this._interface.getComponent() != null) {
                this._container.add(this._interface.getComponent());
            }
        }
        this._inter = new CTCPInterpretor(this._ircConfiguration, this._defaultSource.getInterpretor(), this);
        this._inter.addLast(this._interface.getInterpretor());
        if (this._ircConfiguration.getB("useidentserver")) {
            try {
                this._ident = new IdentWrapper(this._ircConfiguration);
                Exception exception = this._ident.start(this._start.getName(), this);
                if (exception != null) {
                    this._defaultSource.report("\u00036*** " + this.getText(513, exception.getMessage()));
                }
            }
            catch (Throwable throwable) {
                this._ircConfiguration.internalError("ident error", throwable, "bugs@frostwire.com");
            }
        } else {
            this._ident = null;
        }
        String[] stringArray2 = this._ircConfiguration.getInitialization();
        for (int i = 0; i < stringArray2.length; ++i) {
            this._defaultSource.sendString(stringArray2[i]);
        }
        IRCServer iRCServer = new IRCServer(this._ircConfiguration, this, this._start.getNick(), this._start.getAltNick(), this._start.getName(), this._start.getAlias());
        iRCServer.setServers(this._start.getHost(), this._start.getPort(), this._start.getPass());
        this.newServer(iRCServer, this._ircConfiguration.getB("autoconnection"));
        if (!this._start.getSmileysSupport()) {
            this._ircConfiguration.resetSmileyTable();
            System.out.println("Smileys should be DISABLED!");
        } else {
            this._ircConfiguration.restoreSmileyTable();
            System.out.println("Smileys should be ACTIVE!");
        }
        this.requestSourceFocus();
    }

    public IRCInterface getIRCInterface() {
        return this._interface;
    }

    @Override
    public void newServer(Server server, boolean bl) {
        server.addServerListener(this);
        this._servers.put(server, server);
        Enumeration<Plugin> enumeration = this._plugins.elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = enumeration.nextElement();
            plugin.serverCreated(server);
        }
        server.enumerateSourcesAsCreated(this);
        if (bl) {
            server.connect();
        }
    }

    public synchronized void uninit() {
        Enumeration<Server> enumeration = this._servers.keys();
        while (enumeration.hasMoreElements()) {
            Server server = enumeration.nextElement();
            server.leave();
        }
        if (this._ident != null) {
            this._ident.stop();
        }
        this._interface.removeIRCInterfaceListener(this);
        if (this._frame != null) {
            this._frame.removeWindowListener(this);
        }
        this._frame = null;
        while (this._plugins.size() > 0) {
            this.unloadPlugin(this._plugins.elementAt(this._plugins.size() - 1));
        }
        this._pluginsTable = new Hashtable();
        if (this._container != null) {
            this._container.removeAll();
        }
        EventDispatcher.clearCache();
    }

    @Override
    public boolean loadPlugin(String string) {
        Plugin plugin;
        if (this._pluginsTable.get(string) != null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("irc.plugin." + string);
            Constructor<?> constructor = clazz.getDeclaredConstructor(this._ircConfiguration.getClass());
            plugin = (Plugin)constructor.newInstance(this._ircConfiguration);
            this.loadPlugin(plugin);
        }
        catch (Throwable throwable) {
            System.out.println("IRCApplication.loadPlugin() here is where the exception got thrown");
            return false;
        }
        this._pluginsTable.put(string, plugin);
        return true;
    }

    @Override
    public boolean unloadPlugin(String string) {
        Plugin plugin = this._pluginsTable.get(string);
        if (plugin == null) {
            return false;
        }
        this._pluginsTable.remove(string);
        this.unloadPlugin(plugin);
        return true;
    }

    private void loadPlugin(Plugin plugin) {
        plugin.setIRCApplication(this);
        plugin.load();
        this._plugins.insertElementAt(plugin, this._plugins.size());
        plugin.sourceCreated(this._defaultSource, Boolean.TRUE);
        Enumeration<Server> enumeration = this._servers.keys();
        while (enumeration.hasMoreElements()) {
            Server server = enumeration.nextElement();
            plugin.serverCreated(server);
            class AddHandler
            implements ServerListener {
                private Plugin _plugin;

                public AddHandler(Plugin plugin) {
                    this._plugin = plugin;
                }

                @Override
                public void serverConnected(Server server) {
                }

                @Override
                public void serverDisconnected(Server server) {
                }

                @Override
                public void serverLeft(Server server) {
                }

                @Override
                public String[] cannotUseRequestedNicknames(Server server) {
                    return null;
                }

                @Override
                public void sourceCreated(Source source, Server server, Boolean bl) {
                    this._plugin.sourceCreated(source, bl);
                }

                @Override
                public void sourceRemoved(Source source, Server server) {
                }

                @Override
                public Object specialServerRequest(String string, Server server, Object[] objectArray) {
                    return null;
                }
            }
            server.enumerateSourcesAsCreated(new AddHandler(plugin));
        }
    }

    private void unloadPlugin(Plugin plugin) {
        for (int i = 0; i < this._plugins.size(); ++i) {
            if (this._plugins.elementAt(i) != plugin) continue;
            this._plugins.removeElementAt(i);
            Enumeration<Server> enumeration = this._servers.keys();
            while (enumeration.hasMoreElements()) {
                Server server = enumeration.nextElement();
                class RemoveHandler
                implements ServerListener {
                    private Plugin _plugin;

                    public RemoveHandler(Plugin plugin) {
                        this._plugin = plugin;
                    }

                    @Override
                    public void serverConnected(Server server) {
                    }

                    @Override
                    public void serverDisconnected(Server server) {
                    }

                    @Override
                    public void serverLeft(Server server) {
                    }

                    @Override
                    public String[] cannotUseRequestedNicknames(Server server) {
                        return null;
                    }

                    @Override
                    public void sourceCreated(Source source, Server server, Boolean bl) {
                    }

                    @Override
                    public void sourceRemoved(Source source, Server server) {
                        this._plugin.sourceRemoved(source);
                    }

                    @Override
                    public Object specialServerRequest(String string, Server server, Object[] objectArray) {
                        return null;
                    }
                }
                server.enumerateSourcesAsRemoved(new RemoveHandler(plugin));
                plugin.serverRemoved(server);
            }
            plugin.sourceRemoved(this._defaultSource);
            plugin.unload();
            return;
        }
    }

    @Override
    public void sourceCreated(Source source, Server server, Boolean bl) {
        source.getInterpretor().addLast(this._inter);
        Enumeration<Plugin> enumeration = this._plugins.elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = enumeration.nextElement();
            plugin.sourceCreated(source, bl);
        }
    }

    @Override
    public void sourceRemoved(Source source, Server server) {
        Enumeration<Plugin> enumeration = this._plugins.elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = enumeration.nextElement();
            plugin.sourceRemoved(source);
        }
    }

    @Override
    public void serverLeft(Server server) {
        Enumeration<Plugin> enumeration = this._plugins.elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = enumeration.nextElement();
            plugin.serverRemoved(server);
        }
        this._servers.remove(server);
        server.removeServerListener(this);
    }

    private JFrame getParentFrame() {
        if (this._frame != null) {
            return this._frame;
        }
        for (Container container = this._container; container != null; container = container.getParent()) {
            if (!(container instanceof JFrame)) continue;
            return (JFrame)container;
        }
        return null;
    }

    public Container getContainer() {
        if (this._frame != null) {
            return this._frame;
        }
        return this._container;
    }

    @Override
    public Object specialServerRequest(String string, Server server, Object[] objectArray) {
        if (string.equals("DCCFileRequest")) {
            File file = this._ircConfiguration.getSecurityProvider().getSaveFile(objectArray[1].toString(), this.getText(769) + " [" + objectArray[1] + "]");
            return file;
        }
        if (string.equals("DCCChatRequest")) {
            boolean bl = this._ircConfiguration.getSecurityProvider().confirm(this.getParentFrame(), this.getText(1820), this.getText(1821, (String)objectArray[0]));
            return new Boolean(bl);
        }
        this._ircConfiguration.internalError("Unknown request : " + string, null, "bugs@frostwire.com");
        return null;
    }

    @Override
    public void serverConnected(Server server) {
        Object object;
        for (int i = 0; i < this._start.getCommands().length; ++i) {
            object = this._start.getCommands()[i];
            if (((String)object).startsWith("/") && server instanceof IRCServer) {
                ((IRCServer)server).getStatus().sendString(this._start.getCommands()[i]);
                continue;
            }
            server.execute(this._start.getCommands()[i]);
        }
        Enumeration<Plugin> enumeration = this._plugins.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ((Plugin)object).serverConnected(server);
        }
    }

    @Override
    public void serverDisconnected(Server server) {
        Enumeration<Plugin> enumeration = this._plugins.elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = enumeration.nextElement();
            plugin.serverDisconnected(server);
        }
    }

    @Override
    public void identRequested(String string, Integer n, String string2) {
        this._defaultSource.report("\u00036*** " + this.getText(514, string));
        String string3 = "";
        switch (n) {
            case -1: {
                string3 = this.getText(515);
                break;
            }
            case 0: {
                string3 = this.getText(516, string2);
                break;
            }
            case 1: {
                string3 = this.getText(516, this.getText(517) + " : " + string2);
                break;
            }
            case 2: {
                string3 = this.getText(518);
                break;
            }
            default: {
                string3 = this.getText(523);
            }
        }
        this._defaultSource.report("\u00036*** " + string3);
    }

    @Override
    public void identRunning(Integer n) {
        this._defaultSource.report("\u00036*** " + this.getText(519, n + ""));
    }

    @Override
    public void identLeaving(String string) {
        this._defaultSource.report("\u00036*** " + this.getText(520, string));
    }

    @Override
    public void activeChanged(GUISource gUISource, IRCInterface iRCInterface) {
        if (gUISource != null) {
            if (gUISource.getSource().mayDefault()) {
                gUISource.getSource().getServer().setDefaultSource(gUISource.getSource());
            }
            if (this._frame != null) {
                this._frame.setTitle(gUISource.getTitle());
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this._frame) {
            EventDispatcher.dispatchEventAsync(this, "uninit", new Object[0]);
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        ((JFrame)windowEvent.getSource()).setVisible(false);
        ((JFrame)windowEvent.getSource()).dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    private GUISource getActiveSource() {
        return this._interface.getActive();
    }

    private Source getSource(String string, String string2, String string3) {
        Enumeration<Server> enumeration = this._servers.keys();
        while (enumeration.hasMoreElements()) {
            Server server = enumeration.nextElement();
            String string4 = server.getServerName();
            if (!string4.equals(string) && string.length() != 0) continue;
            Enumeration<Source> enumeration2 = server.getSources();
            while (enumeration2.hasMoreElements()) {
                Source source = enumeration2.nextElement();
                if (!source.getType().equals(string2) || !source.getName().equals(string3)) continue;
                return source;
            }
        }
        return null;
    }

    public void requestSourceFocus() {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return;
        }
        gUISource.requestFocus();
    }

    public void requestSourceFocus(String string, String string2, String string3) {
        GUISource gUISource;
        Source source = this.getSource(string, string2, string3);
        if (source != null && (gUISource = this._interface.getGUISource(source)) != null) {
            this._interface.setActive(gUISource);
        }
    }

    public void sendString(String string, String string2, String string3, String string4) {
        Source source = this.getSource(string, string2, string3);
        if (source != null) {
            source.sendString(string4);
        }
    }

    public void sendUserString(String string) {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return;
        }
        gUISource.getSource().sendUserString(string);
    }

    public void sendString(String string) {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return;
        }
        gUISource.getSource().sendString(string);
    }

    public boolean isConnected() {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return false;
        }
        return gUISource.getSource().isConnected();
    }

    public void sendReport(String string) {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return;
        }
        gUISource.getSource().report(string);
    }

    public void setFieldText(String string) {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return;
        }
        gUISource.setFieldText(string);
    }

    public String getFieldText() {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return "";
        }
        return gUISource.getFieldText();
    }

    public void validateText() {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return;
        }
        gUISource.validateText();
    }

    public void sendPluginEvent(String string, Object object) {
        Plugin plugin = this._pluginsTable.get(string);
        if (plugin == null) {
            return;
        }
        plugin.externalEvent(object);
    }

    public Object getPluginValue(String string, Object object) {
        Plugin plugin = this._pluginsTable.get(string);
        if (plugin == null) {
            return null;
        }
        return plugin.getValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] cannotUseRequestedNicknames(Server server) {
        Object object = this._nickLock;
        synchronized (object) {
            if (this._interface.getComponent() != null) {
                this._interface.getComponent().setEnabled(false);
            }
            if (this._frame != null) {
                this._frame.setEnabled(false);
            }
            JFrame jFrame = new JFrame();
            jFrame.setLayout(new FlowLayout());
            jFrame.setSize(200, 65);
            jFrame.setTitle("Change nickname to");
            JTextField jTextField = new JTextField(this._start.getNick());
            JButton jButton = new JButton("Ok");
            jButton.addActionListener(this);
            jFrame.add(jTextField);
            jFrame.add(jButton);
            jFrame.setVisible(true);
            try {
                this._nickLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            jFrame.setVisible(false);
            jFrame.remove(jButton);
            jFrame.remove(jTextField);
            jFrame.dispose();
            String[] stringArray = new String[]{jTextField.getText()};
            if (this._frame != null) {
                this._frame.setEnabled(true);
            }
            if (this._interface.getComponent() != null) {
                this._interface.getComponent().setEnabled(true);
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this._nickLock;
        synchronized (object) {
            this._nickLock.notifyAll();
        }
    }

    private static void usage() {
        System.out.println("Usage :");
        System.out.println("   java irc.IRCApplication -f configfile");
        System.out.println("or java irc.IRCApplication -p nick fullname host gui");
        System.out.println("");
        System.out.println("Without any parameter, '-f pjirc.cfg' parameters are assumed.");
    }

    public static void go(String[] stringArray) {
        LocalFileHandler localFileHandler = new LocalFileHandler();
        try {
            StartupConfiguration startupConfiguration;
            IRCConfiguration iRCConfiguration;
            Object object;
            if (stringArray.length == 0 || stringArray.length >= 2 && stringArray[0].equals("-f")) {
                object = "pjirc.cfg";
                if (stringArray.length >= 2) {
                    object = stringArray[1];
                }
                StreamParameterProvider streamParameterProvider = new StreamParameterProvider(localFileHandler.getInputStream((String)object));
                ConfigurationLoader configurationLoader = new ConfigurationLoader(streamParameterProvider, new NullURLHandler(), new AWTImageLoader(), new NullSoundHandler(), localFileHandler);
                iRCConfiguration = configurationLoader.loadIRCConfiguration();
                startupConfiguration = configurationLoader.loadStartupConfiguration();
            } else if (stringArray.length >= 5 && stringArray[0].equals("-p")) {
                object = new StreamParameterProvider(null);
                ConfigurationLoader configurationLoader = new ConfigurationLoader((ParameterProvider)object, new NullURLHandler(), new AWTImageLoader(), new NullSoundHandler(), localFileHandler);
                iRCConfiguration = configurationLoader.loadIRCConfiguration();
                iRCConfiguration.set("gui", stringArray[4]);
                startupConfiguration = new StartupConfiguration(stringArray[1], "", stringArray[2], new String[]{""}, new String[]{stringArray[3]}, new int[]{6667}, "", new String[0], new String[0], true);
            } else {
                IRCApplication.usage();
                return;
            }
            object = new IRCApplication(iRCConfiguration, startupConfiguration, null);
            EventDispatcher.dispatchEventAsyncAndWaitEx(object, "init", new Object[0]);
        }
        catch (Throwable throwable) {
            System.out.println("Error : " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        IRCApplication.go(stringArray);
    }
}

