/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.AWTImageLoader;
import irc.AboutDialog;
import irc.AudioConfiguration;
import irc.ConfigurationLoader;
import irc.FileHandler;
import irc.ImageLoader;
import irc.ListHandler;
import irc.LocalFileHandler;
import irc.NullItem;
import irc.NullSoundHandler;
import irc.NullURLHandler;
import irc.ParameterProvider;
import irc.RuleList;
import irc.SmileyLoader;
import irc.SmileyTable;
import irc.SoundHandler;
import irc.StreamParameterProvider;
import irc.StyleContext;
import irc.TextProvider;
import irc.URLHandler;
import irc.security.SecurityProvider;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.util.Hashtable;
import java.util.Locale;

public class IRCConfiguration {
    public static final int TILING_CENTER = 0;
    public static final int TILING_STRETCH = 1;
    public static final int TILING_TILE = 2;
    public static final int TILING_FIXED = 3;
    public static final int TILING_HORIZONTAL_LEFT = 0;
    public static final int TILING_HORIZONTAL_RIGHT = 256;
    public static final int TILING_VERTICAL_UP = 0;
    public static final int TILING_VERTICAL_DOWN = 512;
    private NullItem NULL_ITEM = new NullItem();
    private TextProvider _textProvider;
    private ImageLoader _loader;
    private SmileyLoader _smileyLoader;
    private URLHandler _handler;
    private FileHandler _file;
    private AudioConfiguration _audioConfig;
    private RuleList _backgroundImageRules;
    private RuleList _backgroundTilingRules;
    private RuleList _colorsRules;
    private RuleList _fontRules;
    private SmileyTable _table;
    private SmileyTable _backuptable;
    private ListHandler _mayJoinList;
    private ListHandler _mayLeaveList;
    private ListHandler _mayCommandList;
    private Hashtable<String, Object> _htable;
    private SecurityProvider _provider = new SecurityProvider();
    private ParameterProvider _paramProvider;
    private ParameterProvider _interfaceParamProvider;
    private String _guiInfoString;
    private String[] _initCommands;

    public IRCConfiguration(TextProvider textProvider, URLHandler uRLHandler, ImageLoader imageLoader, SoundHandler soundHandler, FileHandler fileHandler, ParameterProvider parameterProvider, ParameterProvider parameterProvider2) {
        this._paramProvider = parameterProvider;
        this._interfaceParamProvider = parameterProvider2;
        this._htable = new Hashtable();
        this._backgroundImageRules = new RuleList();
        this._backgroundTilingRules = new RuleList();
        this._backgroundTilingRules.setDefaultValue(new Integer(0));
        this._fontRules = new RuleList();
        this._fontRules.setDefaultValue(new Font("SanSerif", 0, 13));
        this._colorsRules = new RuleList();
        Color[] colorArray = new Color[16];
        this.loadDefaultColors(colorArray);
        this._colorsRules.setDefaultValue(colorArray);
        this._audioConfig = new AudioConfiguration(soundHandler);
        this._table = new SmileyTable();
        this._backuptable = new SmileyTable();
        this._file = fileHandler;
        this._loader = imageLoader;
        this._textProvider = textProvider;
        this._handler = uRLHandler;
        this._guiInfoString = "";
        this._initCommands = new String[0];
    }

    public static IRCConfiguration createDummyIRCConfiguration() {
        try {
            LocalFileHandler localFileHandler = new LocalFileHandler();
            StreamParameterProvider streamParameterProvider = new StreamParameterProvider(null);
            ConfigurationLoader configurationLoader = new ConfigurationLoader(streamParameterProvider, new NullURLHandler(), new AWTImageLoader(), new NullSoundHandler(), localFileHandler);
            return configurationLoader.loadIRCConfiguration();
        }
        catch (Exception exception) {
            throw new Error("Error creating dummy IRCConfiguration : " + exception);
        }
    }

    public String[] getInitialization() {
        return this._initCommands;
    }

    public void setInitialisation(String[] stringArray) {
        this._initCommands = stringArray;
    }

    public String getGUIInfoString() {
        return this._guiInfoString;
    }

    public void setGUIInfoString(String string) {
        this._guiInfoString = string;
    }

    public FileHandler getFileHandler() {
        return this._file;
    }

    public void displayAboutPage() {
        new AboutDialog(this);
    }

    public ParameterProvider getParameterProvider() {
        return this._paramProvider;
    }

    public ParameterProvider getInterfaceParameterProvider() {
        return this._interfaceParamProvider;
    }

    public int getVersionHigh() {
        return 2;
    }

    public int getVersionMed() {
        return 2;
    }

    public int getVersionLow() {
        return 1;
    }

    public String getVersionModifiers() {
        return "";
    }

    public String getVersion() {
        return this.getVersionHigh() + "." + this.getVersionMed() + "." + this.getVersionLow() + this.getVersionModifiers();
    }

    public SecurityProvider getSecurityProvider() {
        return this._provider;
    }

    public synchronized void set(String string, Object object) {
        if (object == null) {
            object = this.NULL_ITEM;
        }
        this._htable.put(string.toLowerCase(Locale.ENGLISH), object);
    }

    public synchronized void set(String string, int n) {
        this.set(string, new Integer(n));
    }

    public synchronized void set(String string, boolean bl) {
        this.set(string, new Boolean(bl));
    }

    public synchronized Object get(String string) {
        Object object = this._htable.get(string.toLowerCase(Locale.ENGLISH));
        if (object == null) {
            throw new RuntimeException("Unknown configuration property " + string);
        }
        if (object == this.NULL_ITEM) {
            object = null;
        }
        return object;
    }

    public synchronized int getI(String string) {
        Integer n = (Integer)this.get(string);
        return n;
    }

    public synchronized boolean getB(String string) {
        Boolean bl = (Boolean)this.get(string);
        return bl;
    }

    public synchronized String getS(String string) {
        return (String)this.get(string);
    }

    public synchronized boolean mayLeave(String string) {
        return this._mayLeaveList.inList(string);
    }

    public synchronized boolean mayJoin(String string) {
        return this._mayJoinList.inList(string);
    }

    public synchronized void setJoinList(String string) {
        this._mayJoinList = new ListHandler(string);
    }

    public synchronized void setLeaveList(String string) {
        this._mayLeaveList = new ListHandler(string);
    }

    public synchronized void setCommandList(String string) {
        this._mayCommandList = new ListHandler(string);
    }

    public synchronized boolean mayCommand(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return this._mayCommandList.inList(string);
    }

    public synchronized Image getBackgroundImage(String string, String string2) {
        if (!this.getB("style:backgroundImage")) {
            return null;
        }
        return (Image)this._backgroundImageRules.findValue(new String[]{string, string2});
    }

    public synchronized int getBackgroundTiling(String string, String string2) {
        return (Integer)this._backgroundTilingRules.findValue(new String[]{string, string2});
    }

    public synchronized void setBackgroundImage(String string, String string2, String string3) {
        this._backgroundImageRules.addRule(new String[]{string, string2}, this.getImageLoader().getImage(string3));
    }

    public synchronized void setBackgroundTiling(String string, String string2, int n) {
        this._backgroundTilingRules.addRule(new String[]{string, string2}, new Integer(n));
    }

    public synchronized void setFont(String string, String string2, Font font) {
        this._fontRules.addRule(new String[]{string, string2}, font);
    }

    public synchronized String formatASL(String string) {
        int n;
        int n2;
        String string2 = this.getS("noasldisplayprefix");
        if (string2.length() > 0 && string.startsWith(string2)) {
            return "";
        }
        String string3 = this.getS("aslseparatorstring");
        if (string3.length() > 0 && (n2 = string.indexOf(string3)) >= 0) {
            string = string.substring(0, n2);
        }
        String string4 = string;
        int n3 = string.indexOf(32);
        if (n3 < 0) {
            return string4;
        }
        String string5 = string.substring(0, n3).trim();
        if ((n3 = (string = string.substring(n3 + 1).trim()).indexOf(32)) < 0) {
            return string4;
        }
        String string6 = string.substring(0, n3).trim().toLowerCase(Locale.ENGLISH);
        String string7 = string.substring(n3 + 1).trim();
        if (string6.equals(this.getS("aslmale").toLowerCase(Locale.ENGLISH))) {
            n = 2049;
        } else if (string6.equals(this.getS("aslfemale").toLowerCase(Locale.ENGLISH))) {
            n = 2050;
        } else if (string6.equals(this.getS("aslunknown").toLowerCase(Locale.ENGLISH))) {
            n = 2051;
        } else {
            return string4;
        }
        return this.getText(n, string5, string7);
    }

    public synchronized Color getASLColor(String string, Color color, Color color2, Color color3) {
        int n = string.indexOf(32);
        if (n < 0) {
            return color3;
        }
        if ((n = (string = string.substring(n).trim()).indexOf(32)) < 0) {
            return color3;
        }
        if ((string = string.substring(0, n).trim().toLowerCase(Locale.ENGLISH)).equals(this.getS("aslmale").toLowerCase(Locale.ENGLISH))) {
            return color;
        }
        if (string.equals(this.getS("aslfemale").toLowerCase(Locale.ENGLISH))) {
            return color2;
        }
        return color3;
    }

    public AudioConfiguration getAudioConfiguration() {
        return this._audioConfig;
    }

    public synchronized StyleContext getDefaultStyleContext() {
        return this.getStyleContext("", "");
    }

    public synchronized StyleContext getStyleContext(String string, String string2) {
        StyleContext styleContext = new StyleContext();
        styleContext.type = string;
        styleContext.name = string2;
        return styleContext;
    }

    public synchronized void loadDefaultColors(Color[] colorArray) {
        colorArray[0] = new Color(0xFFFFFF);
        colorArray[1] = new Color(0);
        colorArray[2] = new Color(127);
        colorArray[3] = new Color(37632);
        colorArray[4] = new Color(0xFF0000);
        colorArray[5] = new Color(0x7F0000);
        colorArray[6] = new Color(0x9C009C);
        colorArray[7] = new Color(16547584);
        colorArray[8] = new Color(0xFFFF00);
        colorArray[9] = new Color(64512);
        colorArray[10] = new Color(37779);
        colorArray[11] = new Color(65535);
        colorArray[12] = new Color(252);
        colorArray[13] = new Color(0xFF00FF);
        colorArray[14] = new Color(0x7F7F7F);
        colorArray[15] = new Color(0xD2D2D2);
    }

    public synchronized void setSourceColor(String string, String string2, Color[] colorArray) {
        this._colorsRules.addRule(new String[]{string, string2}, colorArray);
    }

    public synchronized Color[] getStyleColors(StyleContext styleContext) {
        return (Color[])this._colorsRules.findValue(new String[]{styleContext.type, styleContext.name});
    }

    public synchronized Font getStyleFont(StyleContext styleContext) {
        return (Font)this._fontRules.findValue(new String[]{styleContext.type, styleContext.name});
    }

    public synchronized Image getStyleBackgroundImage(StyleContext styleContext) {
        return this.getBackgroundImage(styleContext.type, styleContext.name);
    }

    public synchronized int getStyleBackgroundTiling(StyleContext styleContext) {
        return this.getBackgroundTiling(styleContext.type, styleContext.name);
    }

    private ImageLoader getSmileyLoader() {
        if (this._smileyLoader == null) {
            this._smileyLoader = new SmileyLoader();
        }
        return this._smileyLoader;
    }

    public synchronized void addSmiley(String string, String string2) {
        this._table.addSmiley(string, this.getSmileyLoader().getImage(string2));
        this._backuptable.addSmiley(string, this.getSmileyLoader().getImage(string2));
    }

    public ImageLoader getImageLoader() {
        return this._loader;
    }

    public SmileyTable getSmileyTable() {
        return this._table;
    }

    public SmileyTable resetSmileyTable() {
        this._table = new SmileyTable();
        return this._table;
    }

    public SmileyTable restoreSmileyTable() {
        this._table = this._backuptable;
        return this._table;
    }

    public String reloadSmileyTable() {
        int n = this._table.getSize();
        System.out.print("The Smiley Table has been changed, previous value: ");
        System.out.println(n);
        if (n == 0) {
            System.out.println("Smileys are now enabled");
            this.restoreSmileyTable();
            return "Smileys are now enabled";
        }
        System.out.println("Smileys are now disabled");
        this.resetSmileyTable();
        return "Smileys are now disabled";
    }

    public synchronized boolean getASLMaster() {
        return this.getB("asl") | this.getB("style:floatingasl");
    }

    public URLHandler getURLHandler() {
        return this._handler;
    }

    public TextProvider getTextProvider() {
        return this._textProvider;
    }

    public void internalError(String string, Throwable throwable, String string2) {
        System.err.println("************ Internal error ************");
        System.err.println("Please submit a bug report to " + string2 + " including the following information:");
        System.err.println("Message:");
        System.err.println(string);
        if (throwable != null) {
            System.err.println("Root cause:");
            throwable.printStackTrace();
        }
        System.err.println("Stack trace:");
        Thread.dumpStack();
    }

    public synchronized String getText(int n) {
        return this._textProvider.getString(n);
    }

    public synchronized String getText(int n, String string) {
        return this._textProvider.getString(n, string);
    }

    public synchronized String getText(int n, String string, String string2) {
        return this._textProvider.getString(n, string, string2);
    }

    public synchronized String getText(int n, String string, String string2, String string3) {
        return this._textProvider.getString(n, string, string2, string3);
    }
}

