/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.StringParser;
import java.util.Vector;

public class ModeHandler {
    private String _mode;
    private Vector<String> _parameters;
    private char[][] _modes;
    private char[] _prefix;

    public ModeHandler(char[][] cArray, char[] cArray2) {
        this("", cArray, cArray2);
    }

    public ModeHandler(String string, char[][] cArray, char[] cArray2) {
        this._modes = cArray;
        this._prefix = cArray2;
        this._mode = "";
        this._parameters = new Vector();
        if (string.startsWith("+")) {
            string = string.substring(1);
        }
        this.apply("+" + string);
    }

    public void reset() {
        this._mode = "";
    }

    public String getPassword() {
        if (this.hasMode('k')) {
            return this.findParameter('k');
        }
        return "";
    }

    public int getLimit() {
        if (this.hasMode('l')) {
            return new Integer(this.findParameter('l'));
        }
        return 0;
    }

    private boolean inside(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            return true;
        }
        return false;
    }

    private String findParameter(char c) {
        int n = this.getParameterIndex(c);
        if (n >= 0) {
            return this._parameters.elementAt(n);
        }
        return "";
    }

    private boolean hasParameter(boolean bl, char c) {
        if (this.inside(this._prefix, c)) {
            return false;
        }
        if (this.inside(this._modes[0], c)) {
            return true;
        }
        if (this.inside(this._modes[1], c)) {
            return true;
        }
        if (this.inside(this._modes[2], c)) {
            return bl;
        }
        return false;
    }

    private int getParameterIndex(char c) {
        if (this._parameters.size() == 0) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < this._mode.length(); ++i) {
            char c2 = this._mode.charAt(i);
            if (this.hasParameter(true, c2)) {
                if (c2 == c) {
                    return n;
                }
                if (++n < this._parameters.size()) continue;
                return -1;
            }
            if (c2 != c) continue;
            return -1;
        }
        return -1;
    }

    private void addMode(char c, String string) {
        if (this.hasMode(c)) {
            this.removeMode(c, string);
        }
        this._mode = this._mode + c;
        if (this.hasParameter(true, c)) {
            this._parameters.insertElementAt(string, this._parameters.size());
        }
    }

    private void removeMode(char c, String string) {
        if (!this.hasMode(c)) {
            return;
        }
        if (this.hasParameter(true, c)) {
            this._parameters.removeElementAt(this.getParameterIndex(c));
        }
        int n = this._mode.indexOf(c);
        this._mode = this._mode.substring(0, n) + this._mode.substring(n + 1);
    }

    private void applyOne(boolean bl, char c, String string) {
        if (bl) {
            this.addMode(c, string);
        } else {
            this.removeMode(c, string);
        }
    }

    public void apply(String string) {
        String[] stringArray = new StringParser().parseString(string);
        boolean bl = true;
        int n = 0;
        for (int i = 0; i < stringArray[0].length(); ++i) {
            char c = stringArray[0].charAt(i);
            if (c == '+') {
                bl = true;
                continue;
            }
            if (c == '-') {
                bl = false;
                continue;
            }
            String string2 = "";
            if (this.hasParameter(bl, c)) {
                if (++n >= stringArray.length) {
                    return;
                }
                string2 = stringArray[n];
            }
            this.applyOne(bl, c, string2);
        }
    }

    public boolean hasMode(char c) {
        return this._mode.indexOf(c) != -1;
    }

    public String getMode() {
        String string = this._mode;
        for (int i = 0; i < this._parameters.size(); ++i) {
            string = string + " " + this._parameters.elementAt(i);
        }
        return string;
    }
}

