/*
 * Decompiled with CFR 0.152.
 */
package irc;

import java.io.IOException;
import java.io.InputStream;

class MyPushbackStream
extends InputStream {
    private InputStream _is;
    private int _back;
    private boolean _closed;

    public MyPushbackStream(InputStream inputStream) {
        this._is = inputStream;
        this._back = -1;
        this._closed = false;
    }

    @Override
    public void close() throws IOException {
        this._is.close();
        this._back = -1;
        this._closed = true;
    }

    @Override
    public int read() throws IOException {
        if (this._back != -1) {
            int n = this._back;
            this._back = -1;
            return n;
        }
        return this._is.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this._back != -1) {
            byArray[n] = (byte)this._back;
            this._back = -1;
            return 1;
        }
        return this._is.read(byArray, n, n2);
    }

    @Override
    public int available() throws IOException {
        if (this._back != -1) {
            return 1 + this._is.available();
        }
        return this._is.available();
    }

    public void unread(byte by) {
        if (this._closed) {
            return;
        }
        this._back = by;
    }
}

